# catalog awareness for zwiki pages
# based on Casey Duncan's DTMLDocumentExt 0.1
#
# todo: may want to make these all safe against Catalog errors

import string
#import sys
#from Products.ZWiki.ZWikiPage import ZWikiPage

###########################################################################
# CLASS CatalogAware
###########################################################################

class CatalogAware:
    """
    Holds most of ZWikiPage's catalog awareness code.
    Zope's CatalogAwareness didn't work for me and this one
    is a little more flexible or at least familiar.

    >>> # the doctest setup/teardown creates & destroys TestPage -
    >>> # use another in case of confusion
    >>> # check everything is clean before we start
    >>> zc.Catalog(id='CatalogTestPage')
    []
    >>> zc.Catalog(PrincipiaSearchSource="blah")
    []
    >>> zc.Catalog(PrincipiaSearchSource="blob")
    []
    >>> # add a page via ZMI
    >>> ZWiki.manage_addZWikiPage('CatalogTestPage',title='test page',\
                                  file='blah')
    ''
    >>> zc.Catalog(id='CatalogTestPage')[0][0]
    'CatalogTestPage'
    >>> zc.Catalog(PrincipiaSearchSource="blah")[0][0]
    'CatalogTestPage'
    >>> zc.Catalog(PrincipiaSearchSource="blob")
    []
    >>> # edit a page via ZMI
    >>> zc.CatalogTestPage.manage_edit('blob','')
    >>> zc.Catalog(PrincipiaSearchSource="blah")
    []
    >>> zc.Catalog(PrincipiaSearchSource="blob")[0][0]
    'CatalogTestPage'
    >>> # delete a page via ZMI
    >>> zc.manage_delObjects(['CatalogTestPage'])
    >>> zc.Catalog(id='CatalogTestPage')
    []
    """

    # cataloging methods

    def getCatalogId(self):
        """Return the name of the catalog used by this document"""
        return getattr(self, 'SITE_CATALOG', 'Catalog')

    def url(self):
        """Return the absolute object path"""
        return string.join(self.getPhysicalPath(),'/')

    def index_object(self):
        """A common method to allow Findables to index themselves."""
        if hasattr(self, self.getCatalogId()) and \
           not getattr(self, 'NOT_CATALOGED', 0):
            #sys.stderr.write( 'INDEXING PAGE!' +'\n') #SKWM
            getattr(self, self.getCatalogId()).catalog_object(self, self.url())
            self.is_indexed_ = 1
            #sys.stderr.write( 'INDEX DONE!' +'\n') #SKWM

    def unindex_object(self):
        """A common method to allow Findables to unindex themselves."""
        #sys.stderr.write( 'UNINDEX_OBJECT!' +'\n') #SKWM
        if hasattr(self, self.getCatalogId()):
            getattr(self, self.getCatalogId()).uncatalog_object(self.url())
            self.is_indexed_ = 0

    def reindex_object(self):
        """Reindex the object in the Catalog"""
        if getattr(self, 'is_indexed_', 0): self.unindex_object()
        self.index_object()


# enable catalog awareness for common ZMI operations
# have to do this in __init__ because of an import loop ?
