###################################################################################################
# zmsgraphic.py
#
# $Id: zmsgraphic.py,v 1.5 2004/02/24 19:57:22 dnordmann Exp $
# $Name:  $
# $Author: dnordmann $
# $Revision: 1.5 $
#
# Implementation of class ZMSGraphic (see below).
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
###################################################################################################

# Imports.
from Globals import HTMLFile
import string 
import urllib
# Product Imports.
from zmsobject import ZMSObject
import _blobfields
import _fileutil
import _globals
import _metadata
import _objtypes


###################################################################################################
###################################################################################################
###   
###   C o n s t r u c t o r ( s )
###   
###################################################################################################
###################################################################################################

def manage_addZMSGraphic(self, lang, manage_lang, _sort_id, REQUEST, RESPONSE):
  """ manage_addZMSGraphic """
  
  ##### Create ####
  id_prefix = _globals.id_prefix(REQUEST.get('id','e'))
  obj = ZMSGraphic(self.getNewId(id_prefix),_sort_id+1)
  self._setObject(obj.id, obj)
  
  obj = getattr(self,obj.id)
  ##### Object State ####
  obj.setObjStateNew(REQUEST)
  ##### Init Coverage ####
  coverage = self.getDCCoverage(REQUEST)
  if coverage.find('local.')==0:
    obj.setObjProperty('attr_dc_coverage',coverage)
  else:
    obj.setObjProperty('attr_dc_coverage','global.'+lang)
  ##### Init Properties ####
  obj.setObjProperty('active',1,lang)
  ##### VersionManager ####
  obj.onChangeObj(REQUEST)
  
  ##### Normalize Sort-IDs ####
  self.normalizeSortIds(id_prefix)
  
  # Return with message.
  message = self.getLangStr('MSG_INSERTED',manage_lang)%obj.display_type(REQUEST)
  RESPONSE.redirect('%s/%s/manage_main?lang=%s&manage_lang=%s&manage_tabs_message=%s'%(self.absolute_url(),obj.id,lang,manage_lang,urllib.quote(message)))


###################################################################################################
###################################################################################################
###   
###   C l a s s
###   
###################################################################################################
###################################################################################################

class ZMSGraphic(ZMSObject, _metadata.Metadata):

    # Properties.
    # -----------
    meta_type = 'ZMSGraphic'
    icon = "misc_/zms/zmsgraphic.gif"
    icon_disabled = 'misc_/zms/zmsgraphic_disabled.gif'

    # Management Options.
    # -------------------
    manage_options = (  
	{'label': 'TAB_EDIT',       'action': 'manage_main'},
	{'label': 'TAB_REFERENCES', 'action': 'manage_RefForm'},
	{'label': 'TAB_HISTORY',    'action': 'manage_UndoVersionForm'},
	{'label': 'TAB_PREVIEW',    'action': 'preview_html'}, # empty string defaults to index_html
	) 

    # Management Permissions.
    # -----------------------
    __authorPermissions__ = (
		'manage','manage_main','manage_workspace',
		'manage_moveObjUp','manage_moveObjDown',
		'manage_cutObjects','manage_copyObjects','manage_pasteObjs',
		'manage_changeProperties',
		'manage_userForm','manage_user',
		)
    __ac_permissions__=(
		('ZMS Author', __authorPermissions__),
		)

    # Properties.
    # -----------
    __obj_attrs__ = {
        # Changed by
        'change_uid':{'datatype':'string','multilang':1,'xml':0,'lang_inherit':_globals.false},
        'change_dt':{'datatype':'datetime','multilang':1,'xml':0,'lang_inherit':_globals.false},
        # Properties
        'sort_id':{'datatype':'string','xml':0},
        'active':{'datatype':'boolean','multilang':1},
        'attr_active_start':{'datatype':'datetime','multilang':1},
        'attr_active_end':{'datatype':'datetime','multilang':1},
        'format':{'datatype':'string'},
        'img':{'datatype':'image','multilang':1},
        'imghires':{'datatype':'image','multilang':1},
        'imgsuperres':{'datatype':'image','multilang':1},
        'text':{'datatype':'text','multilang':1,'type':'text','size':50},
        'align':{'datatype':'string','type':'select','default':'LEFT','options':['LEFT','LEFT','RIGHT','RIGHT','CENTER','CENTER']},
        'textalign':{'datatype':'string','type':'select','default':'LEFT','options':['LEFT','LEFT','RIGHT','RIGHT','CENTER','CENTER']},
        'displaytype':{'datatype':'int','default':2},
        'img_attrs_spec':{'datatype':'string','size':30,'default':'alt="" border="0"'},
        'attr_url':{'datatype':'url','multilang':1},
        # Meta-Data
        'attr_dc_coverage':{'datatype':'string'},
        # Meta-Dictionaries        
        '$metadict':{'datatype':'MetaDict'},
    }


    # Management Interface.
    # ---------------------
    manage_main = HTMLFile('dtml/zmsgraphic/manage_main', globals())


    """
    ###############################################################################################    
    #
    #   CONSTRUCTOR
    #
    ###############################################################################################    
    """

    # ---------------------------------------------------------------------------------------------
    #  ZMSGraphic.recurse_updateVersion:
    #
    #  Update version.
    # ---------------------------------------------------------------------------------------------
    def recurse_updateVersion(self, REQUEST):
      message = ''
      
      # Process super-objects.
      message += ZMSObject.recurse_updateVersion(self,REQUEST)
      
      # Process object.
      # [...]
      
      # Return with message.
      return message


    """
    ###############################################################################################    
    ###
    ###   P r o p e r t i e s
    ###
    ###############################################################################################    
    """

    ###############################################################################################
    #  ZMSGraphic.manage_changeProperties:
    #
    #  Change properties.
    ###############################################################################################
    def manage_changeProperties(self, lang, manage_lang, REQUEST, RESPONSE): 
      """ ZMSGraphic.manage_changeProperties """
      message = ''
      
      redirect_self = 0
      redirect_self = redirect_self or REQUEST.get('btn','') == '' 
      redirect_self = redirect_self and not REQUEST.get('btn','') == self.getLangStr('BTN_CANCEL',manage_lang)
      
      if REQUEST.get('btn','') != self.getLangStr('BTN_CANCEL',manage_lang):
        
        ##### Object State #####
        self.setObjStateModified(REQUEST)
        
        ##### Properties #####
        # Metadata.
        self.setMetadata(lang,manage_lang,REQUEST)
        # Active.
        self.setReqProperty('active',REQUEST)
        self.setReqProperty('attr_active_start',REQUEST)
        self.setReqProperty('attr_active_end',REQUEST)
        # Attributes.
        self.setReqProperty('text',REQUEST)
        self.setReqProperty('align',REQUEST)
        self.setReqProperty('textalign',REQUEST)
        self.setReqProperty('format',REQUEST)
        self.setReqProperty('img_attrs_spec',REQUEST)
        self.setReqProperty('displaytype',REQUEST)
        self.setReqProperty('img',REQUEST)
        self.setReqProperty('imghires',REQUEST)
        self.setReqProperty('imgsuperres',REQUEST)
        self.setReqProperty('attr_url',REQUEST)
        
        ##### [PIL] Scale Image #####
        img = self.getObjProperty('img',REQUEST)
        if img is not None and \
           REQUEST.get('perc_img_%s'%lang,100) != 100 and \
           self.getConfProperty('InstalledProducts.pil',0) and \
           self.getConfProperty('InstalledProducts.pil.scale',0):
          img = _fileutil.resizeImage(img,REQUEST['perc_img_%s'%lang])
          self.setObjProperty('img',img,lang)
        
        ##### Blobs #####
        _blobfields.thumbnailImageFields(self,lang,manage_lang,REQUEST)
        _blobfields.synchronizeBlobFields(self)
        
        ##### VersionManager ####
        self.onChangeObj(REQUEST)
        
        ##### Message #####
        message = self.getLangStr('MSG_CHANGED',manage_lang)
      
      # Return with message.
      if redirect_self:
        return RESPONSE.redirect('manage_main?lang=%s&manage_lang=%s&manage_tabs_message=%s'%(lang,manage_lang,urllib.quote(message)))
      else:
        self.checkIn(REQUEST)
        return RESPONSE.redirect('%s/manage_main?lang=%s&manage_lang=%s&manage_tabs_message=%s#_%s'%(self.getParentNode().absolute_url(),lang,manage_lang,urllib.quote(message),self.id))


    # ---------------------------------------------------------------------------------------------
    #  ZMSGraphic.isPageElement
    # ---------------------------------------------------------------------------------------------
    def isPageElement(self): return 1

    # ---------------------------------------------------------------------------------------------
    #  ZMSGraphic.getTitlealt
    # ---------------------------------------------------------------------------------------------
    def getTitlealt(self,REQUEST): return self.display_type(REQUEST)

    # ---------------------------------------------------------------------------------------------
    #  ZMSGraphic.getText
    # ---------------------------------------------------------------------------------------------
    def getText(self,REQUEST): 
      return self.getObjProperty('text',REQUEST,'')

    # ---------------------------------------------------------------------------------------------
    #  ZMSGraphic.getImage
    # ---------------------------------------------------------------------------------------------
    def getImage(self,REQUEST): return self.getObjProperty('img',REQUEST)

    # ---------------------------------------------------------------------------------------------
    #  ZMSGraphic.getUrl
    # ---------------------------------------------------------------------------------------------
    def getUrl(self, REQUEST): return self.getLinkUrl(self.getObjProperty('attr_url',REQUEST),REQUEST)

    # ---------------------------------------------------------------------------------------------
    #  ZMSGraphic.getFormat
    # ---------------------------------------------------------------------------------------------
    def getFormat(self,REQUEST): return self.getObjProperty('format',REQUEST)


    """
    ###############################################################################################
    ###
    ###  H T M L - P r e s e n t a t i o n 
    ###
    ###############################################################################################
    """

    # ---------------------------------------------------------------------------------------------
    #  ZMSGraphic._getBodyContent:
    #
    #  HTML presentation of Graphic (and Caption).
    # ---------------------------------------------------------------------------------------------
    def _getBodyContent(self, REQUEST, thumbnail=0):
      # Retrieve properties.
      displaytype = self.getObjProperty('displaytype',REQUEST)
      imgattr      = 'img'
      imghiresattr = 'imghires'
      imgalign     = self.getObjProperty('align',REQUEST)
      imgurl       = self.getUrl(REQUEST)
      imgthumb     = thumbnail
      imgspecial   = self.getObjProperty('img_attrs_spec',REQUEST)
      imgclass	   = None
      textformat   = self.getFormat(REQUEST)
      text         = self.getText(REQUEST)
      if len(text) > 0:
        text         = self.renderText(self.id, textformat, text, REQUEST)
        text         = self.renderContentEditable('text', text, REQUEST)
      textalign    = self.getObjProperty('textalign',REQUEST)
      textclass    = None
      # Return <html>-presentation.
      return self.renderDisplaytype(displaytype,imgattr,imghiresattr,imgalign,imgurl,imgthumb,imgspecial,imgclass,text,textalign,textclass,REQUEST)

    # ---------------------------------------------------------------------------------------------
    #  ZMSGraphic.renderShort:
    #
    #  Renders short presentation of Graphic.
    # ---------------------------------------------------------------------------------------------
    def renderShort(self,REQUEST):
      html = self._getBodyContent(REQUEST,thumbnail=1)
      # Process html <form>-tags.
      html = _globals.form_quote(html,REQUEST)
      # Return <html>.
      return html

###############################################################################################
