###################################################################################################
# _multilangmanager.py
#
# $Id: _multilangmanager.py,v 1.5 2004/02/24 19:57:21 dnordmann Exp $
# $Name:  $
# $Author: dnordmann $
# $Revision: 1.5 $
#
# Implementation of class MultiLanguageManager (see below).
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
###################################################################################################

# Imports.
from __future__ import nested_scopes
from Globals import HTMLFile
import copy
import urllib
# Product Imports.
import _globals

# -------------------------------------------------------------------------------------------------
#  Constants
# -------------------------------------------------------------------------------------------------
STYLESHEET_CSS = \
	'<dtml-call "REQUEST.RESPONSE.setHeader(\'Cache-Control\',\'public, max-age=3600\')">' + \
	'<dtml-call f_standard_html_request>' + \
	'<dtml-var "_[\'stylesheet.css\']">'

# -------------------------------------------------------------------------------------------------
#  importXml
# -------------------------------------------------------------------------------------------------
def _importXml(self, item):
  key = item['key']
  lang_dict = self.get_lang_dict()
  lang_dict[key] = {}
  for s_lang in self.getLangIds():
    lang_dict[key][s_lang] = item[s_lang]
  self.setConfProperty('ZMS.custom.langs.dict',lang_dict.copy())

def importXml(self, xml, REQUEST=None):
  value = self.parseXmlString(xml)
  if type(value) is type([]):
    for item in value:
      _importXml(self,item)
  else:
    _importXml(self,value)


# -------------------------------------------------------------------------------------------------
#  _multilangmanager.getDescLangs
# -------------------------------------------------------------------------------------------------
def getDescLangs(self, id, langs):
  obs = []
  # Primary language is always the first item in the sorted list.
  if id == self.getPrimaryLanguage():
    label = '*'
  elif langs.has_key(id):
    label = langs[id]['label']
  else:
    label = id
  obs.append((label,id))
  # Iterate descending languages.
  for key in langs.keys():
    if langs[key]['parent'] == id:
      obs.extend(getDescLangs(self,key,langs))
  return obs


# ------------------------------------------------------------------------------------------
#  _multilangmanager._set_method: 
# 
#  Set/add DTML-Method (e.g. index_lang.html) for specified language.
# ------------------------------------------------------------------------------------------
def _set_method(self, id, raw):
  # remove existing method            
  try: self.manage_delObjects(ids=[id])
  except: pass
  # add new method
  title = '*** DO NOT DELETE OR MODIFY ***'
  self.manage_addDTMLMethod(id,title,raw)


###################################################################################################
###################################################################################################
###
###   C l a s s   M u l t i L a n g u a g e M a n a g e r
###
###################################################################################################
###################################################################################################
class MultiLanguageManager:

    # Management Interface.
    # ---------------------
    manage_customizeLanguagesForm = HTMLFile('dtml/zms/manage_customizelanguagesform', globals()) 

    # ------------------------------------------------------------------------------------------
    #  MultiLanguageManager.recurse_updateVersionLanguages: 
    #
    #  Update version.
    # ------------------------------------------------------------------------------------------
    def recurse_updateVersionLanguages(self, REQUEST):
      
      # ---------------------------------------------------------------------
      # dd.mm.yyyy Build <#116
      # Initialize parent.
      # ---------------------------------------------------------------------
      if getattr(self.getDocumentElement(),'build','') < '116':
        old_langs = self.getLangs()
        new_langs = {}
        for id in old_langs.keys():
          if type(old_langs[id]) is type({}):
            new_langs[id] = old_langs[id].copy()
          elif type(old_langs[id]) is type(''):
            new_langs[id] = {}
            new_langs[id]['label'] = old_langs[id]
            if id == self.getPrimaryLanguage():
              new_langs[id]['parent'] = ''
            else:
              new_langs[id]['parent'] = self.getPrimaryLanguage()
        self.attr_languages = {}
        for id in new_langs.keys():
          label = new_langs[id]['label']
          parent = new_langs[id]['parent']
          self.__set_lang__(id,label,parent)
      
      # ---------------------------------------------------------------------
      # 26.01.2004 Build #117
      # Add support for multilingual stylesheets.
      # ---------------------------------------------------------------------
      if getattr(self.getDocumentElement(),'build','') < '117':
        for lang in self.getLangIds():
          _set_method(self,'stylesheet_%s.css'%lang,STYLESHEET_CSS)


    """
    ###############################################################################################
    #	P R I M A R Y   L A N G U A G E
    ###############################################################################################
    """

    # ------------------------------------------------------------------------------------------
    #  MultiLanguageManager.setPrimaryLanguage: 
    #
    #  Sets ID of the primary language.
    # ------------------------------------------------------------------------------------------
    def setPrimaryLanguage(self, lang):
      self.language_primary = lang


    # ------------------------------------------------------------------------------------------
    #  MultiLanguageManager.getPrimaryLanguage: 
    #
    #  Returns ID of the primary language.
    # ------------------------------------------------------------------------------------------
    def getPrimaryLanguage(self):
      return self.language_primary


    # ------------------------------------------------------------------------------------------
    #  MultiLanguageManager.getParentLanguage: 
    #
    #  Returns ID of parent language.
    # ------------------------------------------------------------------------------------------
    def getParentLanguage(self, id):
      parent = None
      langs = self.getLangs()
      if langs.has_key(id):
        lang = langs[id]
        parent = lang['parent']
      return parent


    # ------------------------------------------------------------------------------------------
    #  MultiLanguageManager.getParentLanguages: 
    #
    #  Returns IDs of parent languages.
    # ------------------------------------------------------------------------------------------
    def getParentLanguages(self, id):
      obs = []
      langs = self.getLangs()
      if not langs.has_key(id):
        id = self.getPrimaryLanguage()
      parent = id
      while 1:
        parent = langs[parent]['parent']
        if parent:
          obs.append(parent)
        else:
          break
      return obs


    # ------------------------------------------------------------------------------------------
    #  MultiLanguageManager.getManageLanguage: 
    #
    #  Returns ID of the preferred language for the management interface.
    # ------------------------------------------------------------------------------------------
    def getManageLanguage(self, id):
      languages = self.getLangs()[id]
      if type(languages) is type({}) and languages.has_key('manage'):
        rtn = languages['manage']
      elif id in self.getManageLanguages():
        rtn = id
      elif id in ['de','at']:
        rtn = 'ger'
      elif id in ['fr']:
        rtn = 'fra'
      else:
        rtn = 'eng'
      return rtn


    # ------------------------------------------------------------------------------------------
    #  MultiLanguageManager.getLanguageLabel: 
    #
    #  Returns language-label of specified ID.
    # ------------------------------------------------------------------------------------------
    def getLanguageLabel(self, id):
      label = id
      langs = self.getLangs()
      if langs.has_key(id):
        label = langs[id]['label']
      return label


    # ------------------------------------------------------------------------------------------
    #  MultiLanguageManager.getLangs:
    # 
    #  Returns dictionary of languages.
    # ------------------------------------------------------------------------------------------
    def getLangs(self):
      return getattr(self,'attr_languages',{})


    # ------------------------------------------------------------------------------------------
    #  MultiLanguageManager.getLang: 
    # ------------------------------------------------------------------------------------------
    def getLang(self, id):
      return self.getLangs()[id]


    # ------------------------------------------------------------------------------------------
    #  MultiLanguageManager.getLangIds: 
    #
    #  Returns list of Ids of languages (primary language 1st).
    # ------------------------------------------------------------------------------------------
    def getLangIds(self, sort=1):
      obs = []
      langs = self.getLangs()
      for key in langs.keys():
        if key == self.getPrimaryLanguage(): 
          label = '*'
        else: 
          label = langs[key]['label']
        obs.append((label,key))
      obs.sort()
      return map(lambda ob: ob[1],obs)


    # ------------------------------------------------------------------------------------------
    #  MultiLanguageManager.getLanguages: 
    #
    #  Returns list of Ids of languages (primary language 1st).
    # ------------------------------------------------------------------------------------------
    def getLanguages(self, REQUEST=None):
      user_langs = ['*']
      if REQUEST is not None:
        user_langs = self.getUserLangs(str(REQUEST['AUTHENTICATED_USER']))
      return filter(lambda x: ('*' in user_langs) or (x in user_langs), self.getLangIds())


    # ------------------------------------------------------------------------------------------
    #  MultiLanguageManager.getDescendantLanguages: 
    #
    #  Returns IDs of descendant languages.
    # ------------------------------------------------------------------------------------------
    def getDescendantLanguages(self, id, REQUEST=None):
      obs = []
      user_langs = ['*']
      if REQUEST is not None:
        user_langs = self.getUserLangs(REQUEST['AUTHENTICATED_USER'])
      langs = self.getLangs()
      obs = getDescLangs(self,id,langs)
      if not '*' in user_langs:
        obs = filter(lambda x: x[1] in user_langs,obs)
      obs.sort()
      return map(lambda ob: ob[1],obs)


    # ------------------------------------------------------------------------------------------
    #  MultiLanguageManager.getLanguage: 
    #
    #  Get requested language of specified URL (used by index_html).
    # ------------------------------------------------------------------------------------------
    def getLanguage(self, REQUEST): 
      lang = REQUEST.get('lang',None)
      langs = self.getLangIds()
      if lang not in langs:
        url = REQUEST.get('URL')
        path = url
        i = url.rfind('.')
        if i > 0:
          path = url[:i]
        j = path.rfind('_')
        if j > 0:
          suffix = path[j+1:]
          if suffix in langs:
            lang = suffix
      if lang not in langs:
        if self.getConfProperty('ZMS.http_accept_language',0)==1:
          accept = REQUEST.get('HTTP_ACCEPT_LANGUAGE','')
          if accept in langs:
            lang = accept
          elif accept=='de' and 'ger' in langs:
            lang = 'ger'
          elif accept=='en' and 'eng' in langs:
            lang = 'eng'
          elif accept=='fr' and 'fra' in langs:
            lang = 'fra'
      if lang not in langs:
        lang = self.getPrimaryLanguage()
      return lang


    # ------------------------------------------------------------------------------------------
    #  MultiLanguageManager.__set_lang__: 
    # 
    #  Set/add language with specified values.
    # ------------------------------------------------------------------------------------------
    def __set_lang__(self, lang, label, parent, newManage=None, newCharset=''):
      
      if len(parent) == 0:
        primLangOld = self.getPrimaryLanguage()
        for id in self.getLangs().keys():
          if id != lang and self.getParentLanguage(id) == '':
            attr_languages = self.getLangs()
            attr_languages[id]['parent'] = lang
            self.attr_languages = attr_languages.copy()
        self.setPrimaryLanguage(lang)
      
      #-- Set/Add language.
      attr_languages = self.getLangs()
      attr_languages[lang] = {}
      attr_languages[lang]['label'] = label
      attr_languages[lang]['parent'] = parent
      if newManage is not None: attr_languages[lang]['manage'] = newManage
      attr_languages[lang]['charset'] = newCharset
      self.attr_languages = attr_languages.copy()
      
      #-- Set/Add Standard DTML-Methods.
      _set_method(self,'stylesheet_%s.css'%lang,STYLESHEET_CSS)
      _set_method(self,'index_%s.html'%lang,'<dtml-var index_html>')
      _set_method(self,'sitemap_%s.html'%lang,'<dtml-call "REQUEST.set(\'op\',\'sitemap\')"><dtml-var index_html>')
      _set_method(self,'index_print_%s.html'%lang,'<dtml-call "REQUEST.set(\'op\',\'print\')"><dtml-var index_html>')
      _set_method(self,'search_%s.html'%lang,'<dtml-call "REQUEST.set(\'op\',\'search\')"><dtml-var index_html>')
      
      #-- Recreate catalog.
      self.recreateCatalog()


    # ------------------------------------------------------------------------------------------
    #  MultiLanguageManager.__del_lang__: 
    # 
    #  Delete language.
    # ------------------------------------------------------------------------------------------
    def __del_lang__(self, lang):
      
      #-- Delete language.
      dctLanguages = self.getLangs()
      self.attr_languages = {}
      for id in dctLanguages.keys():
        if id != lang:
          self.attr_languages[id] = dctLanguages[id]
      self.attr_languages = self.attr_languages.copy()
      
      #-- Delete Standard DTML-Methods.
      suffix = '_%s.html'%lang
      ids = []
      for id in self.objectIds(['DTML Method']):
        if id[-len(suffix):]==suffix:
          ids.append(id)
      try:
        self.manage_delObjects(ids)
      except:
        pass
      
      #-- Recreate catalog.
      self.recreateCatalog()


    ###############################################################################################
    #  MultiLanguageManager.manage_changeLanguages:
    #
    #  Change languages.
    ###############################################################################################
    def manage_changeLanguages(self, lang, manage_lang, REQUEST, RESPONSE):
        """ MultiLanguageManager.manage_changeLanguages """
        
        # Delete.
        # -------
        if REQUEST['btn'] == self.getLangStr('BTN_DELETE',manage_lang):
          ids = REQUEST.get('ids',[])
          for id in ids:
            self.__del_lang__(id) 
        
        # Change.
        # -------
        elif REQUEST['btn'] == self.getLangStr('BTN_CHANGE',manage_lang):
          for id in self.getLangIds():
            newLabel = REQUEST.get('%s_label'%id).strip()
            newParent = REQUEST.get('%s_parent'%id).strip()
            newManage = REQUEST.get('%s_manage'%id).strip()
            newCharset = REQUEST.get('%s_charset'%id).strip()
            self.__set_lang__(id, newLabel, newParent, newManage, newCharset)
        
        # Insert.
        # -------
        elif REQUEST['btn'] == self.getLangStr('BTN_INSERT',manage_lang):
          id = REQUEST['language_id']
          newLabel = REQUEST.get('language_label').strip()
          if len(self.getLangIds()) == 0:
            newParent = ''
          else:
            newParent = REQUEST.get('language_parent').strip()
          newManage = REQUEST.get('language_manage').strip()
          newCharset = REQUEST.get('language_charset').strip()
          self.__set_lang__(id, newLabel, newParent, newManage, newCharset)
        
        # Return with message.
        message = urllib.quote(self.getLangStr('MSG_CHANGED',manage_lang))
        return RESPONSE.redirect('manage_customizeLanguagesForm?lang=%s&manage_lang=%s&manage_tabs_message=%s'%(lang,manage_lang,message))


    # ------------------------------------------------------------------------------------------
    #  MultiLanguageManager.get_lang_dict:
    #
    #  Returns language-dictionary.
    # ------------------------------------------------------------------------------------------
    def get_lang_dict(self):
      return self.getConfProperty('ZMS.custom.langs.dict',{})


    # ------------------------------------------------------------------------------------------
    #  MultiLanguageManager.getLangDict:
    #
    #  Returns list of entries from language-dictionary (ordered by key).
    # ------------------------------------------------------------------------------------------
    def getLangDict(self):
      lang_dict = self.get_lang_dict()
      lang_list = []
      keys = lang_dict.keys()
      keys.sort()
      for key in keys:
        dict = lang_dict[key]
        dict['key'] = key
        lang_list.append(dict)
      return lang_list


    ###############################################################################################
    #  MultiLanguageManager.manage_changeLangDictProperties:
    #
    #  Change property of language-dictionary.
    ###############################################################################################
    def manage_changeLangDictProperties(self, lang, manage_lang, REQUEST, RESPONSE):
        """ MultiLanguageManager.manage_changeLangDictProperties """
        
        # Delete.
        # -------
        if REQUEST['btn'] == self.getLangStr('BTN_DELETE',manage_lang):
          ids = REQUEST.get('ids',[])
          dict = self.get_lang_dict()
          lang_dict = {}
          for id in dict.keys():
            if not id in ids:
              lang_dict[id] = dict[id]
          self.setConfProperty('ZMS.custom.langs.dict',lang_dict.copy())
        
        # Change.
        # -------
        elif REQUEST['btn'] == self.getLangStr('BTN_CHANGE',manage_lang):
          dict = self.get_lang_dict()
          lang_dict = {}
          for id in dict.keys():
            key = REQUEST['%s_key'%(id)].strip()
            lang_dict[key] = {}
            for s_lang in self.getLangIds():
              lang_dict[key][s_lang] = REQUEST['%s_value_%s'%(id,s_lang)].strip()
          self.setConfProperty('ZMS.custom.langs.dict',lang_dict.copy())
        
        # Insert.
        # -------
        elif REQUEST['btn'] == self.getLangStr('BTN_INSERT',manage_lang):
          id = ''
          key = REQUEST['%s_key'%(id)].strip()
          lang_dict = self.get_lang_dict()
          lang_dict[key] = {}
          for s_lang in self.getLangIds():
            lang_dict[key][s_lang] = REQUEST['%s_value_%s'%(id,s_lang)].strip()
          self.setConfProperty('ZMS.custom.langs.dict',lang_dict.copy())
        
        # Export.
        # -------
        elif REQUEST['btn'] == self.getLangStr('BTN_EXPORT',manage_lang):
          value = []
          ids = REQUEST.get('ids',[])
          dict = self.get_lang_dict()
          for id in dict.keys():
            item = dict[id]
            if id in ids or len(ids) == 0:
              value.append(item)
          if len(value)==1:
            value = value[0]
          content_type = 'text/xml'
          filename = 'ZMS.custom.langs.dict.xml'
          export = self.getXmlHeader() + self.toXmlString(value,1)
          RESPONSE.setHeader('Content-Type',content_type)
          RESPONSE.setHeader('Content-Disposition','inline;filename=%s'%filename)
          return export
        
        # Import.
        # -------
        elif REQUEST['btn'] == self.getLangStr('BTN_IMPORT',manage_lang):
          importXml(self,xml=REQUEST['file'])
          message = self.getLangStr('MSG_IMPORTED',manage_lang)%('<i>%s</i>'%REQUEST['file'].filename)
        
        # Return with message.
        message = urllib.quote(self.getLangStr('MSG_CHANGED',manage_lang))
        return RESPONSE.redirect('manage_customizeLanguagesForm?lang=%s&manage_lang=%s&manage_tabs_message=%s#langdict'%(lang,manage_lang,message))

###################################################################################################
