##############################################################################
#
# Copyright (c) 2002 Ingeniweb SARL
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################

"""
ZAttachmentAttribute product
"""


from config import *
import os
import string

from Products.ZAttachmentAttribute import ZAttachmentAttribute
from Products.ZAttachmentAttribute import ZAttachmentRegistry
from Products.ZAttachmentAttribute import ZAbstractAttachment
from Products.ZAttachmentAttribute.Log import *

class TextAttachment(ZAbstractAttachment.ZAbstractAttachment):
    """
    Text file abstraction
    """
    
    icon_file = "text.gif"
    small_icon_file = "text_small.gif"
    content_types = ('text/plain', )
    index_list = ()


    def indexAttachment(self):
        """
        indexAttachment(self) => index a Text file and store it in the index variable.
        This method is called only once (in the __init__) during the class's lifetime.
        """
        return self.getContent()


    def isPreviewAvailable(self,):
        return 1


    def convertPreview(self,):
        """
        Let's convert things into pretty HTML !
        """
        Log(LOG_DEBUG, "Converting preview", )
        return self.textToHTML(self.getContent())



ZAttachmentRegistry.AttachmentRegistry.registerClass(TextAttachment, globals())

