""" TTW Type Information

configure the TTWObject objects.
It is implemented as a TypeInformation object.

(C) 2003 by Christian Scholz/MrTopf of COM.lounge

"""

from Products.CMFCore.TypesTool import TypeInformation
from Products.CMFCore import CMFCorePermissions
from Products.CMFCore.utils import getToolByName
from Products.Formulator.Form import ZMIForm
from Globals import InitializeClass, DTMLFile
from AccessControl import getSecurityManager, ClassSecurityInfo

from ttwobject import TTWObject

DEFAULT_FTI= { 
        'id'		 : 'TTWObject'
      , 'meta_type'      : 'TTWObject'
      , 'description'    : ""
      , 'icon'           : 'document_icon.gif'
      , 'product'        : 'TTWType'
      , 'factory'        : 'addTTWType'
      , 'immediate_view' : 'portal_form/ttw_edit_form'
      , 'actions'        :
	( { 'id'            : 'view'
          , 'name'          : 'View'
          , 'action'        : 'ttw_view'
          , 'permissions'   : (
          CMFCorePermissions.View, )
	} 
      , { 'id'            : 'edit'
          , 'name'          : 'Edit'
          , 'action'        : 'portal_form/ttw_edit_form'
          , 'permissions'   : (CMFCorePermissions.ModifyPortalContent, )
	} 
      , { 'id'            : 'metadata'
          , 'name'          : 'Metadata'
          , 'action'        : 'metadata_edit_form'
          , 'permissions'   : (CMFCorePermissions.ModifyPortalContent, )
	})
    }

class TTWTypeInformation(TypeInformation):
    """ create a ttw type via formulator """

    meta_type = "TTW Type Information"
    security = ClassSecurityInfo()

    _properties = (TypeInformation._basic_properties
                  +TypeInformation._advanced_properties)

    manage_options=(
	    TypeInformation.manage_options +
	    ({'label'	: 'Fields',
	      'action'	: 'form/manage_workspace'},))

    security.declarePublic('isConstructionAllowed')
    def isConstructionAllowed(self, container):
	""" check for the existance of the form """

	form=getattr(self,'form',None)
	if not form: return 0
	if len(form.get_fields())==0: return 0
	return 1

    security.declarePublic('constructInstance')
    def constructInstance(self,container,id,*args,**kw):
	""" create an instance of this type """

	id=str(id)
	args= ( id, self )

	# this is actually the constructor method
	o=apply(TTWObject, args, kw)
	container._setObject(id,o)
	# end of constructor

	ob=container._getOb(id)
	return self._finishConstruction(ob)

    def getForm(self):
	""" return the form object of this type """
	return self.form

InitializeClass(TTWTypeInformation)

# create add form
manage_addTTWTypeInformationForm=DTMLFile('dtml/addTTWTypeInformationForm', globals())

def manage_addTTWTypeInformation(self, add_meta_type, id=None,
    typeinfo_name=None, RESPONSE=None):
    """ add the TypeInfo and a form for it """
    tool=getToolByName(self, 'portal_types', None)
    if tool is None:
	return

    # prepare the FTI
    fti=DEFAULT_FTI.copy()
    fti['id']=id

    obj=apply(TTWTypeInformation,(),fti)
    tool._setObject(id,obj)
    obj=self._getOb(id)

    # now add the Formulator form to the type info
    form=ZMIForm('form','TTW Type Information Form')
    setattr(obj,'form',form)
    if RESPONSE is not None:
	RESPONSE.redirect('%s/manage_main' % self.absolute_url())

