# -*- coding: UTF-8 -*-

# List by Alexander Limi, Plone Solutions - http://www.plonesolutions.com
# Please contact me if you have any corrections or additions.

languages = {
'aa':'магIарул мацI', # Afar
'ab':'бызшәа', # Abkhazian
'af':'Afrikaans',
'am':'አማርኛ', # Amharic
'ar':'العربية', # Arabic
'as':'অসমিয়া', # Assamese
'ay':'Aymara',
'az':'Azəri Türkçəsi', # Azerbaijani
'ba':'Bashkir',
'be':'Беларускі', # Belarusian
'bg':'Български', # Bulgarian
'bh':'Bihari',
'bi':'Bislama',
'bn':'বাংলা', # Bengali
'bo':'བོད་སྐད་', # Tibetan
'bs':'Bosanski', # Bosnian
'br':'Brezhoneg', # Breton
'ca':'Català', # Catalan
'co':'Corsu', # Corsican
'cs':'Čeština',  # Czech
'cy':'Cymraeg',  # Welsh
'da':'Dansk',  # Danish
'de':'Deutsch', # German
'dz':'Bhutani', # Indian Bhutani
'el':'Ελληνικά', # Greek
'en':'English',
'eo':'Esperanto',
'es':'Español', # Spanish
'et':'Eesti', # Estonian
'eu':'Euskara', # Basque
'fa':'فارسی', # Persian
'fi':'Suomi', # Finnish
'fj':'Fiji',
'fo':'Føroyska', # Faroese
'fr':'Français', # French
'fy':'Frysk', # Frisian
'ga':'Gaeilge', # Irish Gaelic
'gd':'Gàidhlig', # Scottish Gaelic
'gl':'Galego', # Galician
'gn':'Guarani',
'gu':'ગુજરાતી', # Gujarati
'gv':'Gaelg',  # Manx Gaelic
'ha':'هَوُس',  # Hausa
'he':'עברית', # Hebrew
'hi':'हिंदी', # Hindi
'hr':'Hrvatski', # Croatian
'hu':'Magyar', # Hungarian
'hy':'Հայերէն', # Armenian
'ia':'Interlingua',
'id':'Bahasa Indonesia', # Indonesian
'ie':'Interlingue',
'ik':'Inupiak',
'is':'Íslenska', # Icelandic
'it':'Italiano', # Italian
'iu':'ᐃᓄᒃᑎᑐᑦ', # Inuktitut
'ja':'日本語', # Japanese
'jw':'Javanese',
'ka':'ქართული', # Georgian
'kk':'ﻗﺎﺯﺍﻗﺸﺎ', # Kazakh
'kl':'Greenlandic',
'km':'ខ្មែរ', # Cambodian/Khmer
'kn':'ಕನ್ನಡ', # Kannada
'ko':'한국어',  # Korean
'ks':'काऽशुर', # Kashmiri
'ku':'Kurdí', # Kurdish
'kw':'Kernewek', # Cornish
'ky':'Кыргыз', # Kyrgyz
'la':'Latin',
'lb':'Lëtzebuergesch', # Luxemburgish
'li':'Limburgs', # Limburgish
'ln':'Lingala',
'lo':'ພາສາລາວ', # Laotian
'lt':'Lietuviskai', # Lithuanian
'lv':'Latviešu', # Latvian
'mg':'Malagasy', # Madagascarian
'mi':'Maori',
'mk':'Македонски', # Macedonian
'ml':'മലയാളം', # Malayalam
'mn':'Монгол', # Mongolian
'mo':'Moldavian',
'mr':'मराठी', # Marathi
'ms':'Bahasa Melayu', # Malay
'mt':'Malti', # Maltese
'my':'Burmese',
'na':'Nauru', # Nauruan
'ne':'नेपाली', # Nepali
'nl':'Nederlands', # Dutch
'no':'Norsk', # Norwegian
'nn':'Nynorsk', # Norwegian Nynorsk
'oc':'Occitan',
'om':'Oromo',
'or':'ଓଡ଼ିଆ', # Oriya
'pa':'ਪੰਜਾਬੀ', # Punjabi
'pl':'Polski', # Polish
'ps':'پښتو', # Pashto
'pt':'Português', # Portuguese
'qu':'Quechua',
'rm':'Rhaeto-Romance',
'rn':'Kirundi',
'ro':'Română', # Romanian
'ru':'Русский', # Russian
'rw':'Kiyarwanda',
'sa':'संस्कृत', # Sanskrit
'sd':'Sindhi',
'se':'Northern Sámi',
'sg':'Sangho',
'sh':'Serbo-Croatian',
'si':'Singhalese',
'sk':'Slovenčina', # Slovak
'sl':'Slovenščina', # Slovenian
'sm':'Samoan',
'sn':'Shona',
'so':'Somali',
'sq':'Shqip', # Albanian
'sr':'српски', # Serbian
'ss':'Siswati',
'st':'Sesotho',
'su':'Sudanese',
'sv':'Svenska', # Swedish
'sw':'Swahili',
'ta':'தமிழ', # Tamil
'te':'తెలుగు', # Telugu
'tg':'Тоҷики', # Tadjik
'th':'ไทย', # Thai
'ti':'ትግርኛ', # Tigrinya
'tk':'түркmенче', # Turkmen
'tl':'Tagalog',
'tn':'Setswana',
'to':'Tonga',
'tr':'Türkçe', # Turkish
'ts':'Tsonga',
'tt':'татарча', # Tatar
'tw':'Twi',
'ug':'Uigur',
'uk':'Українська', # Ukrainian
'ur':'اردو', # Urdu
'uz':'Ўзбекча', # Uzbek
'vi':'Tiếng Việt', # Vietnamese
'vo':'Volapük',
'wa':'Walon', # Walloon
'wo':'Wolof',
'xh':'isiXhosa', # Xhosa
'yi':'ײִדיש', # Yiddish
'yo':'Yorùbá', # Yorouba
'za':'Zhuang',
'zh':'简体中文', # Chinese
'zu':'isiZulu', # Zulu
}

languages_english = {
'aa':'Afar',
'ab':'Abkhazian',
'af':'Afrikaans',
'am':'Amharic',
'ar':'Arabic',
'as':'Assamese',
'ay':'Aymara',
'az':'Azerbaijani',
'ba':'Bashkir',
'be':'Byelorussian (Belarussian)',
'bg':'Bulgarian',
'bh':'Bihari',
'bi':'Bislama',
'bn':'Bengali',
'bo':'Tibetan',
'bs':'Bosnian',
'br':'Breton',
'ca':'Catalan',
'co':'Corsican',
'cs':'Czech',
'cy':'Welsh',
'da':'Danish',
'de':'German',
'dz':'Bhutani',
'el':'Greek',
'en':'English',
'eo':'Esperanto',
'es':'Spanish',
'et':'Estonian',
'eu':'Basque',
'fa':'Persian',
'fi':'Finnish',
'fj':'Fiji',
'fo':'Faroese',
'fr':'French',
'fy':'Frisian',
'ga':'Irish (Irish Gaelic)',
'gd':'Scots Gaelic (Scottish Gaelic)',
'gl':'Galician',
'gn':'Guarani',
'gu':'Gujarati',
'gv':'Manx Gaelic',
'ha':'Hausa',
'he':'Hebrew',
'hi':'Hindi',
'hr':'Croatian',
'hu':'Hungarian',
'hy':'Armenian',
'ia':'Interlingua',
'id':'Indonesian',
'ie':'Interlingue',
'ik':'Inupiak',
'is':'Icelandic',
'it':'Italian',
'iu':'Inuktitut',
'ja':'Japanese',
'jw':'Javanese',
'ka':'Georgian',
'kk':'Kazakh',
'kl':'Greenlandic',
'km':'Cambodian',
'kn':'Kannada',
'ko':'Korean',
'ks':'Kashmiri',
'ku':'Kurdish',
'kw':'Cornish',
'ky':'Kirghiz',
'la':'Latin',
'lb':'Luxemburgish',
'li':'Limburgish',
'ln':'Lingala',
'lo':'Laotian',
'lt':'Lithuanian',
'lv':'Latvian Lettish',
'mg':'Malagasy',
'mi':'Maori',
'mk':'Macedonian',
'ml':'Malayalam',
'mn':'Mongolian',
'mo':'Moldavian',
'mr':'Marathi',
'ms':'Malay',
'mt':'Maltese',
'my':'Burmese',
'na':'Nauru',
'ne':'Nepali',
'nl':'Dutch',
'no':'Norwegian',
'nn':'Norwegian Nynorsk',
'oc':'Occitan',
'om':'Oromo',
'or':'Oriya',
'pa':'Punjabi',
'pl':'Polish',
'ps':'Pashto',
'pt':'Portuguese',
'qu':'Quechua',
'rm':'Rhaeto-Romance',
'rn':'Kirundi',
'ro':'Romanian',
'ru':'Russian',
'rw':'Kiyarwanda',
'sa':'Sanskrit',
'sd':'Sindhi',
'se':'Northern Sámi',
'sg':'Sangho',
'sh':'Serbo-Croatian',
'si':'Singhalese',
'sk':'Slovak',
'sl':'Slovenian',
'sm':'Samoan',
'sn':'Shona',
'so':'Somali',
'sq':'Albanian',
'sr':'Serbian',
'ss':'Siswati',
'st':'Sesotho',
'su':'Sudanese',
'sv':'Swedish',
'sw':'Swahili',
'ta':'Tamil',
'te':'Telugu',
'tg':'Tajik',
'th':'Thai',
'ti':'Tigrinya',
'tk':'Turkmen',
'tl':'Tagalog',
'tn':'Setswana',
'to':'Tonga',
'tr':'Turkish',
'ts':'Tsonga',
'tt':'Tatar',
'tw':'Twi',
'ug':'Uigur',
'uk':'Ukrainian',
'ur':'Urdu',
'uz':'Uzbek',
'vi':'Vietnamese',
'vo':'Volapük',
'wa':'Walloon',
'wo':'Wolof',
'xh':'Xhosa',
'yi':'Yiddish',
'yo':'Yorouba',
'za':'Zhuang',
'zh':'Chinese',
'zu':'Zulu',
}

combined = {
'ar-ae':'Arabic (United Arab Emirates)',
'ar-bh':'Arabic (Bahrain)',
'ar-dz':'Arabic (Algeria)',
'ar-eg':'Arabic (Egypt)',
'ar-il':'Arabic (Israel)',
'ar-iq':'Arabic (Iraq)',
'ar-jo':'Arabic (Jordan)',
'ar-kw':'Arabic (Kuwait)',
'ar-lb':'Arabic (Lebanon)',
'ar-ly':'Arabic (Libya)',
'ar-ma':'Arabic (Morocco)',
'ar-mr':'Arabic (Mauritania)',
'ar-om':'Arabic (Oman)',
'ar-ps':'Arabic (Palestinian West Bank and Gaza)',
'ar-qa':'Arabic (Qatar)',
'ar-sa':'Arabic (Saudi Arabia)',
'ar-sd':'Arabic (Sudan)',
'ar-so':'Arabic (Somalia)',
'ar-sy':'Arabic (Syria)',
'ar-td':'Arabic (Chad)',
'ar-tn':'Arabic (Tunisia)',
'ar-ye':'Arabic (Yemen)',
'bn-bd':'Bengali (Bangladesh)',
'bn-in':'Bengali (India)',
'bn-sg':'Bengali (Singapore)',
'ch-gu':'Chamorro (Guam)',
'ch-mp':'Chamorro (Northern Mariana Islands)',
'da-dk':'Danish (Denmark)',
'da-gl':'Danish (Greenland)',
'de-at':'German (Austria)',
'de-be':'German (Belgium)',
'de-ch':'German (Switzerland)',
'de-de':'German (Germany)',
'de-dk':'German (Denmark)',
'de-li':'German (Liechtenstein)',
'de-lu':'German (Luxembourg)',
'el-cy':'Greek (Cyprus)',
'el-gr':'Greek (Greece)',
'en-ag':'English (Antigua and Barbuda)',
'en-ai':'English (Anguilla)',
'en-as':'English (American Samoa)',
'en-au':'English (Australia)',
'en-bb':'English (Barbados)',
'en-bm':'English (Bermuda)',
'en-bn':'English (Brunei)',
'en-bs':'English (Bahamas)',
'en-bw':'English (Botswana)',
'en-bz':'English (Belize)',
'en-ca':'English (Canada)',
'en-ck':'English (Cook Islands)',
'en-cm':'English (Cameroon)',
'en-dm':'English (Dominica)',
'en-er':'English (Eritrea)',
'en-et':'English (Ethiopia)',
'en-fj':'English (Fiji)',
'en-fk':'English (Falkland Islands)',
'en-fm':'English (Micronesia)',
'en-gb':'English (United Kingdom)',
'en-gd':'English (Grenada)',
'en-gh':'English (Ghana)',
'en-gi':'English (Gibraltar)',
'en-gm':'English (Gambia)',
'en-gu':'English (Guam)',
'en-gy':'English (Guyana)',
'en-ie':'English (Ireland)',
'en-il':'English (Israel)',
'en-io':'English (British Indian Ocean Territory)',
'en-jm':'English (Jamaica)',
'en-ke':'English (Kenya)',
'en-ki':'English (Kiribati)',
'en-kn':'English (St. Kitts-Nevis)',
'en-ky':'English (Cayman Islands)',
'en-lc':'English (St. Lucia)',
'en-lr':'English (Liberia)',
'en-ls':'English (Lesotho)',
'en-mp':'English (Northern Mariana Islands)',
'en-ms':'English (Montserrat)',
'en-mt':'English (Malta)',
'en-mu':'English (Mauritius)',
'en-mw':'English (Malawi)',
'en-na':'English (Namibia)',
'en-nf':'English (Norfolk Island)',
'en-ng':'English (Nigeria)',
'en-nr':'English (Nauru)',
'en-nu':'English (Niue)',
'en-nz':'English (New Zealand)',
'en-pg':'English (Papua New Guinea)',
'en-ph':'English (Philippines)',
'en-pk':'English (Pakistan)',
'en-pn':'English (Pitcairn)',
'en-pr':'English (Puerto Rico)',
'en-pw':'English (Palau)',
'en-rw':'English (Rwanda)',
'en-sb':'English (Solomon Islands)',
'en-sc':'English (Seychelles)',
'en-sg':'English (Singapore)',
'en-sh':'English (St. Helena)',
'en-sl':'English (Sierra Leone)',
'en-so':'English (Somalia)',
'en-sz':'English (Swaziland)',
'en-tc':'English (Turks and Caicos Islands)',
'en-tk':'English (Tokelau)',
'en-to':'English (Tonga)',
'en-tt':'English (Trinidad and Tobago)',
'en-ug':'English (Uganda)',
'en-us':'English (USA)',
'en-vc':'English (St. Vincent and the Grenadi)',
'en-vg':'English (British Virgin Islands)',
'en-vi':'English (U.S. Virgin Islands)',
'en-vu':'English (Vanuatu)',
'en-ws':'English (Western Samoa)',
'en-za':'English (South Africa)',
'en-zm':'English (Zambia)',
'en-zw':'English (Zimbabwe)',
'es-ar':'Spanish (Argentina)',
'es-bo':'Spanish (Bolivia)',
'es-cl':'Spanish (Chile)',
'es-co':'Spanish (Colombia)',
'es-cr':'Spanish (Costa Rica)',
'es-cu':'Spanish (Cuba)',
'es-do':'Spanish (Dominican Republic)',
'es-ec':'Spanish (Ecuador)',
'es-es':'Spanish (Spain)',
'es-gq':'Spanish (Equatorial Guinea)',
'es-gt':'Spanish (Guatemala)',
'es-hn':'Spanish (Honduras)',
'es-mx':'Spanish (Mexico)',
'es-ni':'Spanish (Nicaragua)',
'es-pa':'Spanish (Panama)',
'es-pe':'Spanish (Peru)',
'es-pr':'Spanish (Puerto Rico)',
'es-py':'Spanish (Paraguay)',
'es-sv':'Spanish (El Salvador)',
'es-us':'Spanish (USA)',
'es-uy':'Spanish (Uruguay)',
'es-ve':'Spanish (Venezuela)',
'fr-ad':'French (Andorra)',
'fr-be':'French (Belgium)',
'fr-bf':'French (Burkina Faso)',
'fr-bi':'French (Burundi)',
'fr-bj':'French (Benin)',
'fr-ca':'French (Canada)',
'fr-cd':'French (Democratic Republic of Congo)',
'fr-cf':'French (Central African Republic)',
'fr-cg':'French (Congo)',
'fr-ch':'French (Switzerland)',
'fr-ci':'French (Cote d\'Ivoire)',
'fr-cm':'French (Cameroon)',
'fr-dj':'French (Djibouti)',
'fr-fr':'French (France)',
'fr-ga':'French (Gabon)',
'fr-gb':'French (United Kingdom)',
'fr-gf':'French (French Guiana)',
'fr-gn':'French (Guinea)',
'fr-gp':'French (Guadeloupe)',
'fr-ht':'French (Haiti)',
'fr-it':'French (Italy)',
'fr-km':'French (Comoros Islands)',
'fr-lb':'French (Lebanon)',
'fr-lu':'French (Luxembourg)',
'fr-mc':'French (Monaco)',
'fr-mg':'French (Madagascar)',
'fr-ml':'French (Mali)',
'fr-mq':'French (Martinique)',
'fr-nc':'French (New Caledonia)',
'fr-pf':'French (French Polynesia)',
'fr-pm':'French (St. Pierre and Miquelon)',
'fr-re':'French (Reunion)',
'fr-rw':'French (Rwanda)',
'fr-sc':'French (Seychelles)',
'fr-td':'French (Chad)',
'fr-tg':'French (Togo)',
'fr-vu':'French (Vanuatu)',
'fr-wf':'French (Wallis and Futuna)',
'fr-yt':'French (Mayotte)',
'hr-ba':'Croatian (Bosnia-Herzegovina)',
'hr-hr':'Croatian (Croatia)',
'hu-hu':'Hungarian (Hungary)',
'hu-si':'Hungarian (Slovenia)',
'it-ch':'Italian (Switzerland)',
'it-hr':'Italian (Croatia)',
'it-it':'Italian (Italy)',
'it-si':'Italian (Slovenia)',
'it-sm':'Italian (San Marino)',
'ko-kp':'Korean (Korea, North)',
'ko-kr':'Korean (Korea, South)',
'ln-cd':'Lingala (Democratic Republic of Congo)',
'ln-cg':'Lingala (Congo)',
'ms-bn':'Malay (Brunei)',
'ms-my':'Malay (Malaysia)',
'ms-sg':'Malay (Singapore)',
'nl-an':'Dutch (Netherlands Antilles)',
'nl-aw':'Dutch (Aruba)',
'nl-be':'Dutch (Belgium)',
'nl-nl':'Dutch (Netherlands)',
'nl-sr':'Dutch (Suriname)',
'pt-ao':'Português (Angola)',
'pt-br':'Português (Brasil)',
'pt-cv':'Português (Ilhas Cabo Verde)',
'pt-gw':'Português (Guiné-Bissau)',
'pt-mz':'Português (Moçambique)',
'pt-pt':'Português (Portugal)',
'pt-st':'Português (São Tomé e Príncipe)',
'sd-in':'Sindhi (India)',
'sd-pk':'Sindhi (Pakistan)',
'sr-ba':'Serbian (Bosnia-Herzegovina)',
'sr-yu':'Serbian (Yugoslavia)',
'ss-sz':'Swati (Swaziland)',
'ss-za':'Swati (South Africa)',
'sv-fi':'Swedish (Finland)',
'sv-se':'Swedish (Sweden)',
'sw-ke':'Swahili (Kenya)',
'sw-tz':'Swahili (Tanzania)',
'ta-in':'Tamil (India)',
'ta-sg':'Tamil (Singapore)',
'tn-bw':'Tswana (Botswana)',
'tn-za':'Tswana (South Africa)',
'tr-bg':'Turkish (Bulgaria)',
'tr-cy':'Turkish (Cyprus)',
'tr-tr':'Turkish (Turkey)',
'ur-in':'Urdu (India)',
'ur-pk':'Urdu (Pakistan)',
'zh-cn':'Mandarin+Chinese (China)',
'zh-hk':'Mandarin+Chinese (Hongkong)',
'zh-sg':'Mandarin+Chinese (Singapore)',
'zh-tw':'Mandarin+Chinese (Taiwan)',
}

# countries list from http://alioth.debian.org/projects/pkg-isocodes/
countries = {
'AD':'Andorra',
'AE':'United Arab Emirates',
'AF':'Afghanistan',
'AG':'Antigua and Barbuda',
'AI':'Anguilla',
'AL':'Albania',
'AM':'Armenia',
'AN':'Netherlands Antilles',
'AO':'Angola',
'AQ':'Antarctica',
'AR':'Argentina',
'AS':'American Samoa',
'AT':'Austria',
'AU':'Australia',
'AW':'Aruba',
'AX':'Åland Islands',
'AZ':'Azerbaijan',
'BA':'Bosnia and Herzegovina',
'BB':'Barbados',
'BD':'Bangladesh',
'BE':'Belgium',
'BF':'Burkina Faso',
'BG':'Bulgaria',
'BH':'Bahrain',
'BI':'Burundi',
'BJ':'Benin',
'BM':'Bermuda',
'BN':'Brunei Darussalam',
'BO':'Bolivia',
'BR':'Brazil',
'BS':'Bahamas',
'BT':'Bhutan',
'BV':'Bouvet Island',
'BW':'Botswana',
'BY':'Belarus',
'BZ':'Belize',
'CA':'Canada',
'CC':'Cocos (Keeling) Islands',
'CD':'Congo, The Democratic Republic of',
'CF':'Central African Republic',
'CG':'Congo',
'CH':'Switzerland',
'CI':"Cote d'Ivoire",
'CK':'Cook Islands',
'CL':'Chile',
'CM':'Cameroon',
'CN':'China',
'CO':'Colombia',
'CR':'Costa Rica',
'CS':'Serbia and Montenegro',
'CU':'Cuba',
'CV':'Cape Verde',
'CX':'Christmas Island',
'CY':'Cyprus',
'CZ':'Czech Republic',
'DE':'Germany',
'DJ':'Djibouti',
'DK':'Denmark',
'DM':'Dominica',
'DO':'Dominican Republic',
'DZ':'Algeria',
'EC':'Ecuador',
'EE':'Estonia',
'EG':'Egypt',
'EH':'Western Sahara',
'ER':'Eritrea',
'ES':'Spain',
'ET':'Ethiopia',
'FI':'Finland',
'FJ':'Fiji',
'FK':'Falkland Islands (Malvinas)',
'FM':'Micronesia, Federated States of',
'FO':'Faroe Islands',
'FR':'France',
'GA':'Gabon',
'GB':'United Kingdom',
'GD':'Grenada',
'GE':'Georgia',
'GF':'French Guiana',
'GH':'Ghana',
'GI':'Gibraltar',
'GL':'Greenland',
'GM':'Gambia',
'GN':'Guinea',
'GP':'Guadeloupe',
'GQ':'Equatorial Guinea',
'GR':'Greece',
'GS':'South Georgia and the South Sandwich Islands',
'GT':'Guatemala',
'GU':'Guam',
'GW':'Guinea-Bissau',
'GY':'Guyana',
'HK':'Hong Kong',
'HM':'Heard Island and McDonald Islands',
'HN':'Honduras',
'HR':'Croatia',
'HT':'Haiti',
'HU':'Hungary',
'ID':'Indonesia',
'IE':'Ireland',
'IL':'Israel',
'IN':'India',
'IO':'British Indian Ocean Territory',
'IQ':'Iraq',
'IR':'Iran, Islamic Republic of',
'IS':'Iceland',
'IT':'Italy',
'JM':'Jamaica',
'JO':'Jordan',
'JP':'Japan',
'KE':'Kenya',
'KG':'Kyrgyzstan',
'KH':'Cambodia',
'KI':'Kiribati',
'KM':'Comoros',
'KN':'Saint Kitts and Nevis',
'KP':"Korea, Democratic People's Republic of",
'KR':'Korea, Republic of',
'KW':'Kuwait',
'KY':'Cayman Islands',
'KZ':'Kazakhstan',
'LA':"Lao People's Democratic Republic",
'LB':'Lebanon',
'LC':'Saint Lucia',
'LI':'Liechtenstein',
'LK':'Sri Lanka',
'LR':'Liberia',
'LS':'Lesotho',
'LT':'Lithuania',
'LU':'Luxembourg',
'LV':'Latvia',
'LY':'Libyan Arab Jamahiriya',
'MA':'Morocco',
'MC':'Monaco',
'MD':'Moldova, Republic of',
'MG':'Madagascar',
'MH':'Marshall Islands',
'MK':'Macedonia, the former Yugoslavian Republic of',
'ML':'Mali',
'MM':'Myanmar',
'MN':'Mongolia',
'MO':'Macao',
'MP':'Northern Mariana Islands',
'MQ':'Martinique',
'MR':'Mauritania',
'MS':'Montserrat',
'MT':'Malta',
'MU':'Mauritius',
'MV':'Maldives',
'MW':'Malawi',
'MX':'Mexico',
'MY':'Malaysia',
'MZ':'Mozambique',
'NA':'Namibia',
'NC':'New Caledonia',
'NE':'Niger',
'NF':'Norfolk Island',
'NG':'Nigeria',
'NI':'Nicaragua',
'NL':'Netherlands',
'NO':'Norway',
'NP':'Nepal',
'NR':'Nauru',
'NU':'Niue',
'NZ':'New Zealand',
'OM':'Oman',
'PA':'Panama',
'PE':'Peru',
'PF':'French Polynesia',
'PG':'Papua New Guinea',
'PH':'Philippines',
'PK':'Pakistan',
'PL':'Poland',
'PM':'Saint Pierre and Miquelon',
'PN':'Pitcairn',
'PR':'Puerto Rico',
'PS':'Palestinian Territory, occupied',
'PT':'Portugal',
'PW':'Palau',
'PY':'Paraguay',
'QA':'Qatar',
'RE':'Reunion',
'RO':'Romania',
'RU':'Russian Federation',
'RW':'Rwanda',
'SA':'Saudi Arabia',
'SB':'Solomon Islands',
'SC':'Seychelles',
'SD':'Sudan',
'SE':'Sweden',
'SG':'Singapore',
'SH':'Saint Helena',
'SI':'Slovenia',
'SJ':'Svalbard and Jan Mayen',
'SK':'Slovakia',
'SL':'Sierra Leone',
'SM':'San Marino',
'SN':'Senegal',
'SO':'Somalia',
'SR':'Suriname',
'ST':'Sao Tome and Principe',
'SV':'El Salvador',
'SY':'Syrian Arab Republic',
'SZ':'Swaziland',
'TC':'Turks and Caicos Islands',
'TD':'Chad',
'TF':'French Southern Territories',
'TG':'Togo',
'TH':'Thailand',
'TJ':'Tajikistan',
'TK':'Tokelau',
'TL':'Timor-Leste',
'TM':'Turkmenistan',
'TN':'Tunisia',
'TO':'Tonga',
'TR':'Turkey',
'TT':'Trinidad and Tobago',
'TV':'Tuvalu',
'TW':'Taiwan, Province of China',
'TZ':'Tanzania, United Republic of',
'UA':'Ukraine',
'UG':'Uganda',
'UM':'United States Minor Outlying Islands',
'US':'United States',
'UY':'Uruguay',
'UZ':'Uzbekistan',
'VA':'Holy See (Vatican City State)',
'VC':'Saint Vincent and the Grenadines',
'VE':'Venezuela',
'VG':'Virgin Islands, British',
'VI':'Virgin Islands, U.S.',
'VN':'Viet Nam',
'VU':'Vanuatu',
'WF':'Wallis and Futuna',
'WS':'Samoa',
'YE':'Yemen',
'YT':'Mayotte',
'ZA':'South Africa',
'ZM':'Zambia',
'ZW':'Zimbabwe',
}

# build sorted language id lists
english=languages_english.keys()
native =languages.keys()
english.sort()
native.sort()

# assert the keys are in sync
try: assert(native == english)
except AssertionError:
    changed = []
    count = 0
    for c in native:
        try: e = english[count]
        except IndexError, msg: e=msg
        if c != e: changed.append('%s != %s' % (c, e))
        count=count+1

    raise AssertionError, "Native and english languaes not in sync (%s)" % ', '.join(changed)

