# -*- coding: utf-8 -*-
##Original copyright:
##Migration system for the migration from CMFDefault/Event types to archetypes
##based CMFPloneTypes (http://sf.net/projects/collective/).

##Copyright (c) 2004, Christian Heimes and contributors
##All rights reserved.

##Redistribution and use in source and binary forms, with or without modification,
##are permitted provided that the following conditions are met:

## * Redistributions of source code must retain the above copyright notice, this
##   list of conditions and the following disclaimer.
## * Redistributions in binary form must reproduce the above copyright notice,
##   this list of conditions and the following disclaimer in the documentation
##   and/or other materials provided with the distribution.
## * Neither the name of the author nor the names of its contributors may be used
##   to endorse or promote products derived from this software without specific
##   prior written permission.

## 
## Copyright (C)2005 Ingeniweb

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING. If not, write to the
## Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

"""Plone ExFile migration module
"""
__version__ = "$Revision: 1.8 $"
# $Source: /cvsroot/ingeniweb/PloneExFile/migration/Migrator.py,v $
# $Id: Migrator.py,v 1.8 2006/03/07 15:51:47 encolpe Exp $
__docformat__ = 'restructuredtext'

from copy import copy

# Python imports
from StringIO import StringIO
import sys

# Zope imports
from OFS.Image import File
from Acquisition import aq_base
from Acquisition import aq_parent
from Acquisition import aq_inner
from DateTime import DateTime
from Persistence import PersistentMapping

# Archetypes imports
from Products.Archetypes.interfaces.base import IBaseUnit

# CMF imports
from Products.CMFCore.utils import getToolByName

class ZAttachmentAttribute:
    """Fake ZAttachmentAttribute class. Used to get attachment"""
    __underlyingFile__ = None
    title = ''
    filename = ''
    content_type = ''
    
class ZDummyAttachment:
    """Fake ZDummyAttachment class. Used to get attachment data"""
    content = ''

def copyPermMap(old):
    """bullet proof copy
    """
    new = PersistentMapping()
    for k,v in old.items():
        nk = copy(k)
        nv = copy(v)
        new[k] = v
    return new

class Migrator:
    """Migration class
    """

    def migrateToPloneExFile(self, portal, file_brains, stdout, options):
        """Migrate Files to PloneExFile 3.x
        """

        dry_run = options.get('dry_run', False)
        limit = options.get('convert_limit', 0)

        if stdout is not None:
            stdout.write('Migrate File to PloneExFile v3.x.\r\n')
        
        nb_files = 0
        already = 0
        
        # If we have a 'limit' option set, we just try to convert <limit> exfiles maximum.
        # This is so just to avoid Memory Errors.
        if limit:
            limit = min(len(file_brains), limit)
        else:
            limit = len(file_brains)

        stdout.write("There are %d File objects.\r\n" % len(file_brains))
        stdout.write("Migrating at most %d files.\r\n" % limit)

        # Get all PloneExFile in v2.x
        for file_brain in file_brains:
            file = file_brain.getObject()
            # We fetch the important dates before anything else
            creation_date = DateTime(file.CreationDate())
            modification_date = DateTime(file.ModificationDate())

            # Check limit
            if nb_files >= limit:
                break

            # Check if it has not been done before
            #if not getattr(exfile, 'attach', None):
            #    already += 1
            #    continue

            # This is an exfile from v2.x
            parent = file.getParentNode()
            nb_files += 1

            # Dry run means we simulate
            if not dry_run:
                # Migrate attachment
                stdout.write('  ...migrating exfile attachment...\r\n')
                
                content_type = file.content_type
                title = file.title
                data = file.data
                new_id = file.id()[len('exfile_'):]
                
                # Remove old ExFile
                try:
                    parent.manage_delObjects([new_id])
                except:
                    stdout.write("Couldn't delete %s in %s\r\n" % (new_id, parent.absolute_url()))
                # Remove old File
                try:
                    parent.manage_delObjects([file.id()])
                except:
                    stdout.write("Couldn't delete %s in %s\r\n" % (file.id(), parent.absolute_url()))
                try:
                    parent.invokeFactory('PloneExFile', new_id, title=title)
                except:
                    stdout.write("Couldn't add %s in %s\r\n" % (new_id, parent.absolute_url()))
                    continue # No need to go on then
                newexfile = getattr(parent, new_id)
                newexfile.setTitle(title)
                newexfile.setDescription(file.Description())
                # XXX Ugly hack: Uses the files alt property to store filename
                newexfile.setFile(data, filename=file.alt)

                # We have to set the Owner
                # getWrappedOwner is not always available
                if hasattr(aq_base(file), 'getWrappedOwner'):
                    owner = file.getWrappedOwner()
                    newexfile.changeOwnership(owner)
                else:
                    newexfile._owner = file.getOwner(info = 1)

                # We have to take care of the workflow state
                wfh = getattr(file, 'workflow_history', None)
                if wfh:
                    wfh = copyPermMap(wfh)
                    newexfile.workflow_history = wfh

                # We have to keep the creation and modification date
                newexfile.creation_date = creation_date
                newexfile.setModificationDate(modification_date)

                # Try to remove the article from live memory
                exfile = None
            
        if stdout is not None:
            stdout.write('%s exfile(s) migrated.\r\n' % nb_files)
            stdout.write('%s exfile(s) were already migrated.\r\n' % already)
            stdout.write('Migration from PloneExFile v2.x to v3.x finished.\r\n')
        return stdout.getvalue()


def migrate(self):
    out = StringIO()
    migrator = Migrator()
    cat_tool = getToolByName(self, 'portal_catalog')
    file_brains = cat_tool(portal_type='File')
    result =migrator.migrateToPloneExFile(self, file_brains, out, options={})
    file_brains = None
    return result
