## Controller Python Script "plonearticle_uid_reference"
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind state=state
##bind subpath=traverse_subpath
##parameters=uid, type
##title=Add object of type to article as references

# define the charset : useful for utf-8 sites using translate.py (see for something smarter)
from Products.CMFCore.utils import getToolByName
charset = getToolByName(context, 'portal_properties')['site_properties'].default_charset
context.REQUEST.RESPONSE.setHeader('Content-Type','text/html; charset=%s'%charset)

message = ''
state.setNextAction('redirect_to_action:string:view')

if type == 'image':
    try:
        context.addImageFromUID(uid)
        message = context.translate(
              domain='plonearticle', msgid='message_image_pasted',
              mapping={}, 
              default = 'Image(s) pasted.'
            )
    except:
        message = context.translate(
            domain='plonearticle', msgid='message_paste_image_error',
            mapping={'error_count': 1, 'image_count': 1},
            default = 'You tried to paste %s image(s). Unauthorized content type used for %s image(s).'%(1, 1)
          )
    state.setNextAction('redirect_to_action:string:image')
elif type == 'attachment':
    try:
        context.addAttachmentFromUID(uid)
        message = context.translate(
              domain='plonearticle', msgid='message_attachment_pasted',
              mapping={}, 
              default = 'Attachment(s) pasted.'
            )
    except:
        message = context.translate(
            domain='plonearticle', msgid='message_paste_attachment_error',
            mapping={'error_count': 1, 'attachment_count': 1},
            default = 'You tried to paste %s attachments(s). Unauthorized content type used for %s attachment(s).'%(1, 1)
          )
    state.setNextAction('redirect_to_action:string:attach')
elif type == 'link':
    try:
        context.addLinkFromUID(uid)
        message = context.translate(
              domain='plonearticle', msgid='message_link_pasted',
              mapping={}, 
              default = 'Link(s) pasted.'
            )
    except:
        message = context.translate(
            domain='plonearticle', msgid='message_paste_link_error',
            mapping={'error_count': 1, 'link_count': 1},
            default = 'You tried to paste %s link(s). Unauthorized content type used for %s link(s).'%(1, 1)
          )
    state.setNextAction('redirect_to_action:string:link')

return state.set(status='success',\
                 context=context,\
                 portal_status_message=message)
