## Controller Python Script "plonearticle_link_delete"
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind state=state
##bind subpath=traverse_subpath
##parameters=title=None, items=[]
##title=Delete links

# define the charset : useful for utf-8 sites using translate.py (see for something smarter)
from Products.CMFCore.utils import getToolByName
charset = getToolByName(context, 'portal_properties')['site_properties'].default_charset
context.REQUEST.RESPONSE.setHeader('Content-Type','text/html; charset=%s'%charset)

message=""

context.removeLinks(items)
if len(items) > 1:
  #message="%d links deleted" % len(links)
  linkCount = len(items)
  message = context.translate(
              domain='plonearticle', msgid='message_links_deleted',
              mapping={'link_count': linkCount, }, 
              default = '%d links deleted.'%(linkCount)
            )
   
elif len(items) == 1:
  #message="Link deleted"
  message = context.translate(
                domain='plonearticle', msgid='message_link_deleted',
                mapping={}, 
                default = 'Link deleted.'
             )
   
else:
  #message="No links selected for deletion."
  message = context.translate(
               domain='plonearticle', msgid='message_delete_link_none_selected',
               mapping={}, 
               default = 'No link selected for deletion.'
            )

return state.set(status='success',\
                 context=context,\
                 portal_status_message=message)
