## Controller Python Script "plonearticle_image_paste"
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind state=state
##bind subpath=traverse_subpath
##parameters=
##title=Paste image into an article
##

# define the charset : useful for utf-8 sites using translate.py (see for something smarter)
from Products.CMFCore.utils import getToolByName
charset = getToolByName(context, 'portal_properties')['site_properties'].default_charset
context.REQUEST.RESPONSE.setHeader('Content-Type','text/html; charset=%s'%charset)

from ZODB.POSException import ConflictError

#see in OFS.CopySupport for infos about __cp
if context.cb_dataValid:
    try:
      cp_objs = context.cb_dataItems()
    except:
      # object is missing in clipboard.
        message = context.translate(
                    domain='plonearticle', msgid='message_image_clipboard_error',
                    mapping={},
                    default = 'Paste could not find clipboard content.'
        )
        return state.set(status='failure', portal_status_message=message)
    paste_type_error = 0
    
    for obj in cp_objs:
        try:
            context.addImageFromObject(obj)
        except TypeError:
            paste_type_error += 1
            
    from Products.CMFPlone import transaction_note
    transaction_note('Pasted content to %s' % (context.absolute_url()))
    
    if not paste_type_error:
      message = context.translate(
                  domain='plonearticle', msgid='message_image_pasted',
                  mapping={}, 
                  default = 'Image(s) pasted.'
                )
      return state.set(portal_status_message=message)


message = context.translate(
            domain='plonearticle', msgid='message_paste_image_error',
            mapping={'error_count': paste_type_error, 'image_count': len(cp_objs)},
            default = 'You tried to paste %s image(s). Unauthorized content type used for %s image(s).'%(len(cp_objs), str(paste_type_error))
          )
return state.set(status='failure', portal_status_message=message)

