# -*- coding: utf-8 -*-
## PloneArticle
## Copyright (C)2006 Ingeniweb

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING. If not, write to the
## Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
"""This is the CMFEditions modifier for Plone Article Version 3.

PA stands for PloneArticle
"""
__version__ = "$Revision: 1.4 $"
# $Source: /cvsroot/ingeniweb/PloneArticle/CMFEditionsModifier/PloneArticleV3CMFEModifier.py,v $
# $Id: PloneArticleV3CMFEModifier.py,v 1.4 2006/09/22 01:32:29 encolpe Exp $
__docformat__ = 'restructuredtext'


# More details in the ``LICENSE`` file included in this package.

from Globals import InitializeClass
from Acquisition import aq_base

from Products.PageTemplates.PageTemplateFile import PageTemplateFile

from Products.CMFCore.utils import getToolByName
from Products.CMFCore.CMFCorePermissions import ManagePortal

from Products.CMFEditions.interfaces.IModifier import IAttributeModifier
from Products.CMFEditions.interfaces.IModifier import ICloneModifier
from Products.CMFEditions.interfaces.IModifier import ISaveRetrieveModifier
from Products.CMFEditions.interfaces.IModifier import IConditionalTalesModifier

from Products.CMFEditions.Modifiers import ConditionalTalesModifier

from Products.CMFEditions.StandardModifiers import OMInsideChildrensModifier, OMSubObjectAdapter

from Products.PloneArticle.config import Log, LOG_DEBUG
from Products.PloneArticle.AttachmentMixin import OrderedList


ORDEREDLIST_ATTRIBUTES = (
    '__ordered_attachment_refs__',
    '__ordered_image_refs__',
    '__ordered_link_refs__',
    )

LOCK_ATTRIBUTES = (
    '_locked_by',
    '_locked_date',
    '_unlocked_by',
    '_unlocked_date',
)

def initialize(context):
    """Registers modifiers with zope (on zope startup).
    """
    for m in modifiers:
        context.registerClass(
            m['wrapper'], m['id'],
            permission = ManagePortal,
            constructors = (m['form'], m['factory']),
            icon = m['icon'],
        )

def install(portal_modifier):
    """Registers modifiers in the modifier registry (at tool install time).
    """
    for m in modifiers:
        id = m['id']
        if id in portal_modifier.objectIds():
            continue
        title = m['title']
        modifier = m['modifier']()
        wrapper = m['wrapper'](id, modifier, title)
        enabled = m['enabled']
        if IConditionalTalesModifier.isImplementedBy(wrapper):
            wrapper.edit(enabled, m['condition'])
        else:
            wrapper.edit(enabled)

        portal_modifier.register(m['id'], wrapper)

class PloneArticleV3Modifier(OMInsideChildrensModifier):
    """ObjectManager modifier treating all childrens as inside refs

    Treats all inside contents references of PA (the repository layer
    knows what to do with that fact).
    """

    __implements__ = (ICloneModifier, ISaveRetrieveModifier, IAttributeModifier)

    #
    # ICloneModifier and ISaveRetrieveModifier implemented in inherited class
    #

    #
    # IAttributeModifier implementation
    #

    def getReferencedAttributes(self, obj):
        """Returns attributes which should be passe dto the storage by reference.
        
        Returns a dict of the format ``name:attribute``. 
        """
        aq_obj = aq_base(obj)
        result = {}

        for attribute_id in ORDEREDLIST_ATTRIBUTES:
            attribute = getattr(aq_obj, attribute_id, None)
            if attribute:
                result[attribute_id] = attribute.getItems()
            else:
                result[attribute_id] = None

        for attribute_id in LOCK_ATTRIBUTES:
            result[attribute_id] = getattr(aq_obj, attribute_id, None)

        return result

    def reattachReferencedAttributes(self, obj, attrs_dict):
        """Giving an obj and and an attribute dict composed by
           attribute names and values, reattach them to the obj.
        """
        aq_obj = aq_base(obj)

        for name, attr_value in attrs_dict.items():
            if name in ORDEREDLIST_ATTRIBUTES:
                orderedlist = OrderedList()
                orderedlist.add(attr_value)
                setattr(aq_obj, name, orderedlist)
            else:
                setattr(aq_obj, name, attr_value)


InitializeClass(PloneArticleV3Modifier)


manage_PloneArticleV3ModifierAddForm = PageTemplateFile('www/PloneArticleV3ModifierAddForm.pt',
                                          globals(),
                                          __name__='manage_PloneArticleV3ModifierAddForm')

def manage_addPloneArticleV3Modifier(self, id, title=None,
                                        REQUEST=None):
    """Add an object manager modifier treating children as inside refs
    """
    modifier = PloneArticleV3Modifier()
    self._setObject(id, ConditionalTalesModifier(id, modifier, title))

    if REQUEST is not None:
        REQUEST['RESPONSE'].redirect(self.absolute_url()+'/manage_main')



#----------------------------------------------------------------------
# Standard modifier configuration
#----------------------------------------------------------------------

modifiers = (
    {
        'id': 'PloneArticleV3Modifier',
        'title': "Modifier for object managers treating children as inside objects.",
        'enabled': False,
        'condition': 'python: False',
        'wrapper': ConditionalTalesModifier,
        'modifier': PloneArticleV3Modifier,
        'form': manage_PloneArticleV3ModifierAddForm,
        'factory': manage_addPloneArticleV3Modifier,
        'icon': 'CMFEditionsModifier/www/modifier.gif',
    },
)
