##########################################################################
#                                                                        #
#           copyright (c) 2003 ITB, Humboldt-University Berlin           #
#           written by: Raphael Ritz, r.ritz@biologie.hu-berlin.de       #
#                                                                        #
##########################################################################

"""Mastersthesis reference main class"""

from AccessControl import ClassSecurityInfo
from Products.CMFCore.permissions import View
from Products.Archetypes.public import Schema
from Products.Archetypes.public import StringField, StringWidget
from Products.Archetypes.public import registerType

from Products.CMFBibliographyAT.content.base import BaseEntry
from Products.CMFBibliographyAT.content.schemata \
    import HeaderSchema, AuthorSchema, CoreSchema, TrailingSchema
from Products.CMFBibliographyAT.content.fields \
    import schoolField, addressField


SourceSchema = Schema((
    schoolField,
    addressField,
     ))

MastersthesisSchema = HeaderSchema + AuthorSchema + CoreSchema +  \
                      SourceSchema + TrailingSchema


class MastersthesisReference(BaseEntry):
    """ content type to make reference to a masters thesis.
    """
    security = ClassSecurityInfo()
    archetype_name = "Mastersthesis Reference"
    source_fields = ('school', 'address')

    schema = MastersthesisSchema

    security.declareProtected(View, 'Source')
    def Source(self):
        """ the default masters thesis source format
        """
        try:
            return self.MastersthesisSource()
        except AttributeError:
            school   = self.getSchool()
            address  = self.getAddress()
            
            source = "Masters thesis, %s, %s." % (school, address)
            
            return source.replace(', .','.')

registerType(MastersthesisReference)
