/* misc.c
 * Part of ziproxy package
 *
 * Copyright (c)2005-2010 Daniel Mealha Cabrita
 *
 * Released subject to GNU General Public License v2 or later version.
 *
 * Miscellaneous routines
 */

#include <string.h>

/* Remove heading and trailing spaces/control_chars
   Used when collecting a parameter, to avoid things like
   mismatched strings when they should match instead.
   in_str: string to be cleaned
   out_str: cleaned string (malloc at least the same as in_str)
   in_str may be the same as out_str */
void misc_cleanup_string (const char *in_str, char *out_str)
{
	char *out_pos;
	const char *in_pos;
	int out_len;

	/* skip the heading junk */
	in_pos = in_str;
	while ((*in_pos <= ' ') && (*in_pos != '\0'))
		in_pos++;

	/* copy the rest (no strcpy because they may overlap) */
	out_pos = out_str;
	while (*in_pos != '\0')
		*(out_pos++) = *(in_pos++);
	*out_pos = '\0';

	/* remove the trailing junk */
	out_len = strlen (out_str);
	out_pos = out_str + out_len - 1;
	while ((out_len-- > 0) && (*out_pos <= ' '))
		*(out_pos--) = '\0';
}

/* convert in_str uppercase characters and dump the resulting string
   to out_str.
   in_str may be the same as out_str */
void misc_convert_str_tolower (const char *in_str, char *out_str)
{
	const char *in_pos = in_str;
	char *out_pos = out_str;
	char in_char;

	in_char = *in_pos;
	while (in_char != '\0') {
		*(out_pos++) = in_char + (((in_char >= 'A') && (in_char <= 'Z')) ? 32 : 0);
		in_char = *(++in_pos);
	}
	*out_pos = '\0';
}

