#ifndef _INCLUDED_GTKALBUMLIST_H_
#define _INCLUDED_GTKALBUMLIST_H_

#include <vector>

#include <time.h>
#include <glibmm/ustring.h>
#include <gdkmm/pixbuf.h>


#include "gtklibrary.h"
#include "gtklibrarylist.h"
#include "facontext.h"
#include "playlist.h"
#include "cataloginfo.h"

class GTKLibrary::GTKAlbumList : public GTKLibraryList {
 public:
	GTKAlbumList(GTKLibrary *library);  
 
 private:
	//Internal Functions
	virtual void set_list_columns();
	virtual void set_rows_data(std::vector<Gtk::TreeModel::Path> RowPaths);
	
 	virtual void cursor_changed(Gtk::TreeModel::Path CursorPath);

 	virtual void init_row(Gtk::TreeModel::Row& new_row);
	//Possible Columns
	class AlbumsCols : public Gtk::TreeModel::ColumnRecord {
	 public:
		
		AlbumsCols()
		{ add(icon); add(album); add(last_refresh); }
			
		Gtk::TreeModelColumn< Glib::RefPtr<Gdk::Pixbuf> > icon;
		Gtk::TreeModelColumn<Glib::ustring> album;
		Gtk::TreeModelColumn<time_t> last_refresh;
	};
	
	AlbumsCols m_AlbumsCols;
};

#endif
/* arch-tag: 59500f06-b255-4794-9fbd-d76b38c55d9c */
