/*____________________________________________________________________________
	
	Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

	Portions Copyright (C) 1999 EMusic.com

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
	
	$Id: m3u.cpp,v 1.7 2003/09/16 17:35:20 kgk Exp $
____________________________________________________________________________*/

#include <assert.h>
#include <iostream>
#include <fstream>
#include <string>
#include <stdlib.h>

#ifdef __QNX__
#include <strings.h>
#endif

using namespace std;

#include "config.h"
#include "errors.h"
#include "errno.h"
#include "utility.h"
#include "Http.h"

#include "m3u.h"

typedef struct FormatInfoStruct {
    const char* extension;
    const char* description;

} FormatInfoStruct; 

static FormatInfoStruct formats[] = {
    {"m3u", "M3U Playlist Format"},
    {"gqmpeg", "M3U Playlist Format"}
};

#define kNumFormats (sizeof(formats)/sizeof(FormatInfoStruct))

extern "C"
{
   PlaylistFormat *Initialize(FAContext* context)
   {
      return new M3U(context);
   }
}

M3U::M3U(FAContext* context):PlaylistFormat(context)
{
}

M3U::~M3U()
{

}

Error M3U::GetSupportedFormats(PlaylistFormatInfo* info, uint32_t index)
{
    Error result = kError_InvalidParam;

    assert(info);

    if(info) {
        result = kError_NoMoreFormats;

        if(index < kNumFormats) {
            info->SetExtension(formats[index].extension);
            info->SetDescription(formats[index].description);
            result = kError_NoErr;
        }
    }

    return result;
}



Error 
M3U::readPlaylist(const string& url, vector<string>& list)
{
    Error result = kError_InvalidParam;
    int index;
    if(url.size() == 0) 
        return result;

    string path;
    string root;
    string entry;
    bool   removetmp = false;

    result = URLToFilePath(url, path);

    //cerr << "m3u url=" << url << " path=" << path << endl;

    if (IsError(result)) {
        // It's a url.. get the local 
        Http download(m_context);
        char buffer[TMP_MAX];
        //cout << "download " << url << endl;
        tmpnam(buffer);
        path = buffer;
        result = download.DownloadToFile (url, path);
        removetmp = true;
    }

    if(IsntError(result)) {
        root = path;
        string::size_type n = path.rfind (DIR_MARKER);
        if (n != string::npos) 
            root = root.substr(0, n+1);

        //cerr<< "m3u: root=" << root << endl;
        result = kError_FileNotFound;

        ifstream fp(path.c_str());

        if(!fp.is_open()) 
            return result;

        while (!fp.eof() ) {
            getline(fp, entry);

            //cerr << "m3u:entry=" << entry << endl;
            // is this a comment line?
            if(entry[0] == '#')
                continue;

            // if this is not a URL then let's
            // enable people with different platforms 
            // to swap files by changing the path 
            // separator as necessary
            if( entry.substr(0,7)!= "http://" &&
                entry.substr(0,6)!= "rtp://" &&
                entry.substr(0,7)!= "file://") {

                for (index = entry.size() - 1; index >=0; index--) {
                    if(entry[index] == '\\' && DIR_MARKER == '/')
                        entry[index] = DIR_MARKER;
                    else if(entry[index] == '/' && DIR_MARKER == '\\')
                        entry[index] = DIR_MARKER;
                }
            }

            // get rid of nasty trailing whitespace
            for (index = entry.size()-1 ; index >=0; index--) {
                if(!isspace(entry[index]))
                    break;
            }
            entry.resize(index+1);

            // is there anything left?
            if(entry.size()) {
                string itemurl;
                    
                // is it a url already?
                if( entry.substr(0,7)== "http://" ||
                    entry.substr(0,6)== "rtp://" ||
                    entry.substr(0,7)== "file://") {
                    itemurl = entry;
                } else {
                    // is the path relative?
                    if(entry.substr(0,2)== ".."
                       || (entry.substr(1,2) !=":\\" 
                           && entry[0]!= DIR_MARKER)) {
                        path = root;
                        path += entry;
                    }
                    else {
                        path = entry;
                    }
                    //cerr << "m3u: newpath=" << path << endl;
                    // make it a url so we can add it to the playlist
                    FilePathToURL(path,itemurl);
                }
                        
                //cerr << "m3u: newurl=" << itemurl << endl;
                list.push_back(itemurl);
            }
        }
            
        fp.close();
        result = kError_NoErr;
    }
    if (removetmp) unlink(path.c_str());

    return result;
}



Error
M3U::writePlaylist(const string& url,
                   std::vector<std::string>& items)
{
    Error result = kError_InvalidParam;

    return result;
}





Error M3U::ReadPlaylist(const char * url, 
                        vector<PlaylistItem*>* list,
                        PLMCallBackFunction function,
                        void* cookie)
{
    vector<string> items;

    Error r = readPlaylist (string(url), items);

    for (vector<string>::iterator i = items.begin();
         i != items.end(); i++) {
        PlaylistItem *item = new PlaylistItem(*i);
        list->push_back(item);
    }
    return r;
}



Error M3U::WritePlaylist(const char* url, PlaylistFormatInfo* format, 
                         vector<PlaylistItem*>* list,
                         PLMCallBackFunction function,
                         void* cookie)
{
    Error result = kError_InvalidParam;

    assert(url);
    assert(format);
    assert(list);

    if(url && format && list)
    {
        result = kError_FormatNotSupported;

        if(!strcasecmp("m3u", format->GetExtension()))
        {
            FILE* fp = NULL;
            string path;
            URLToFilePath(url, path);

            result = kError_FileNoAccess;

            fp = fopen(path.c_str(), "wb");

            if(fp)
            {
                uint32_t index;
                uint32_t count;

                count = list->size();

                for(index = 0; index < count; index++)
                {
                    PlaylistItem* item = (*list)[index];

                    if(IsError(URLToFilePath(item->URL().c_str(),path)))
                        fprintf(fp, "%s%s", item->URL().c_str(), LINE_END_MARKER_STR);
                    else
                        fprintf(fp, "%s%s", path.c_str(), LINE_END_MARKER_STR);
                }

                fclose(fp);

                result = kError_NoErr;
            }
            else
            {
                int err = errno;

                switch(err)
                {
                case EACCES:
                case EEXIST:
                case EINVAL:
                case ENOENT:
                    result = kError_FileNoAccess;
                    break;
                }
            }
        }
    }

    return result;
}

/* arch-tag: cf2b5961-b505-4a90-ba2a-8752439a75ab
   (do not change this comment) */
