/* -*- c++-mode -*-__________________________________________________________

        Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

        Portions Copyright (C) 1999 EMusic.com

        This program is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 2 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

        $Id: mkdatabase.h,v 1.1 2003/09/16 17:58:14 kgk Exp $
____________________________________________________________________________*/



#ifndef _MKDATABASE_H
#define _MKDATABASE_H 1

#include <map>
#include <string>

#include <mk4.h>
#include <mk4str.h>

#include "metadatadb.h"

class MKDatabase : public MetadataDB 
{
public:
    typedef std::map<std::string,c4_StringProp> propmap_type;

public:
    MKDatabase(const std::string&name);
    ~MKDatabase();
        

    // Low level manipulations
    virtual bool add(const url_t& url, const Metadata&);
    virtual bool remove(const url_t& url);
    virtual bool contains(const url_t&);
    virtual bool getMetadata(const url_t&url, Metadata&m);
    virtual bool setMetadata(const url_t&url, const Metadata&m);

    /** 
     *  Query the database for a target with know constraints.
     *
     * @param target: Metadata tag field that i.e. artist,album,url, etc
     * @param params: A dictionary of contrained metadata fields
     * @param results:  A list of results
     */
    virtual Error query(const std::string& target, const params_t& params, 
                        result_t& results);




    // MKDatabase 
    void  commit();

private:
    static std::vector<std::string> supported_tags;
    propmap_type m_propmap;

    c4_Storage  *m_database;
    c4_StringProp m_pUrl;
    c4_View      m_dbview;
    c4_View      m_hash;
    c4_View      m_dbhash;
};


#endif /* _MKDATABASE_H */

/* arch-tag: 36b4be2b-9c34-4af2-957f-3bcb94a86c04 */
