#include "zinfvolume.h"

#define ZINF_DEFAULT_VOLUME 85

int left  = ZINF_DEFAULT_VOLUME;
int right = ZINF_DEFAULT_VOLUME;

void ZinfGetVolume(int32_t* valLeft, int32_t* valRight)
{
  if( left>=0 )
    *valLeft = left;

  if( right>=0 )
    *valRight = right;
} 

void ZinfSetVolume(int32_t valLeft, int32_t valRight)
{
  if( valLeft>=0 && valLeft<=100 )
    left = valLeft;

  if( valRight>=0 && valRight<=100 )
    right = valRight;
}

void ZinfVolumize(short *data, int DataSize)
{
    static int vol_scale[] = {0,1,2,4,7,12,18,26,35,45,56,69,75,87,100 };
    
    int realRight;

    if( right<=0 )
      realRight = 0;
    else if( right>=100 )
      realRight = 100;
    else
      realRight = vol_scale[(int)(14.0*((double)right/100))];


    int realLeft;

    if( left<=0 )
      realLeft = 0;
    else if( left>=100 )
      realLeft = 100;
    else
      realLeft = vol_scale[(int)(14.0*((double)left/100))];

    for (int i=0; i < DataSize << 1; i+=8) {
	int v;
        v=(int) ((*(data) * realLeft) / 100);
	*(data++)=(v>32767) ? 32767 : ((v<-32768) ? -32768 : v);
	v=(int) ((*(data) * realRight) / 100);
	*(data++)=(v>32767) ? 32767 : ((v<-32768) ? -32768 : v);
    }        
}

/* arch-tag: c2f17460-b55c-45d7-9d3c-fa14809d9e43
   (do not change this comment) */
