// vi:ts=4:shiftwidth=4:expandtab
/***************************************************************************
                          inputmanager.h  -  description
                             -------------------
    begin                : Sun Sep 9 2001
    copyright            : (C) 2001 by ejoy
    email                : ejoy@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INPUTMANAGER_H
#define INPUTMANAGER_H


/**
  *@author ejoy
  */
using namespace std;
#include <cassert>
#include <vector>

#if defined(__FreeBSD__)
    #include <sys/kbio.h>
#endif

class Zhcon;
class Console;
class InputServer;
class InputClient;
class ImmInfo;
class ConfigFile;
class Window;

class InputManager {
    friend class ConfigServer;
    public:
        enum InputStyle {NativeBar,OverSpot};
        InputManager(Zhcon * pOwner, Console * pCon,InputStyle style,
            string& OverSpotColors, string& NativeBarColors);
        ~InputManager();
        void ProcessKey(char c);
        bool ProcessSysKey(char c);
        bool ProcessInputKey(char c);

        void LoadImmInfo(ConfigFile& f);
        void Show();
        void Hide();
        void Redraw();
        void PromptMode();
    private:
        void WriteClient(char c);
        void WriteClient(string & s);
        void OutChar(char c);
        void Active();
        void DisActive();
        void SetVtSize();
        void DoCtrlShift();
        bool LoadImm(ImmInfo& rInfo);
        void DoCtrlSpace();
        void MenuMode();

        void KDSysSet();
        void KDSysRestore();
        void KDInputSet();
        void KDInputRestore();
        void ChangeStyle(InputStyle style);
        void HelpShow();
        void HelpHide();
#if defined(linux)
        struct KeyMap {
            unsigned char mTable;
            unsigned char mIndex;
            unsigned short mOldValue;
            unsigned short mNewValue;
        };
        static KeyMap mKDSysMap[];
        static KeyMap mKDInputMap[];
#elif defined(__FreeBSD__)
        static keymap_t mKDSysOld, mKDSysNew;
        static keymap_t mKDInputOld, mKDInputNew;
#endif
        static bool mKDSysSaved;
        static bool mKDInputSaved;
        Zhcon *mpOwner;
        Console *mpCon;
        InputServer *mpInputServer;
        InputClient *mpInputClient;
        int mClientFd;
        bool mActive;
        bool mClientVisible;
        ImmInfo* mpCurImm;
        vector < ImmInfo > mImmTable;
        InputStyle mStyle;
        string msOverSpotColors;
        string msNativeBarColors;
        Window *mpHelpWin;
};

#endif
