/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Connection;
import Ice.LocalException;
import Ice.ObjectAdapter;
import Ice.SocketException;
import Ice.SyscallException;
import Ice.TimeoutException;
import IceInternal.Acceptor;
import IceInternal.DefaultsAndOverrides;
import IceInternal.Endpoint;
import IceInternal.EndpointHolder;
import IceInternal.Instance;
import IceInternal.Transceiver;
import java.util.Enumeration;
import java.util.Vector;

public final class IncomingConnectionFactory {
    private Thread _threadPerIncomingConnectionFactory;
    private Instance _instance;
    private Acceptor _acceptor;
    private Transceiver _transceiver;
    private Endpoint _endpoint;
    private ObjectAdapter _adapter;
    private boolean _warn;
    private Vector _connections;
    private int _state;

    public synchronized void activate() {
        this.setState(0);
    }

    public synchronized void destroy() {
        this.setState(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() {
        Vector vector;
        Thread thread = null;
        Object object = this;
        synchronized (object) {
            while (this._state != 2 || this._acceptor != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            thread = this._threadPerIncomingConnectionFactory;
            this._threadPerIncomingConnectionFactory = null;
            vector = this._connections;
            this._connections = null;
        }
        if (thread != null) {
            while (true) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            Connection connection = (Connection)object.nextElement();
            connection.waitUntilFinished();
        }
    }

    public Endpoint endpoint() {
        return this._endpoint;
    }

    public synchronized String toString() {
        if (this._transceiver != null) {
            return this._transceiver.toString();
        }
        return this._acceptor.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncomingConnectionFactory(Instance instance, Endpoint endpoint, ObjectAdapter objectAdapter) {
        block15: {
            this._connections = new Vector();
            this._instance = instance;
            this._endpoint = endpoint;
            this._adapter = objectAdapter;
            this._warn = this._instance.properties().getPropertyAsInt("Ice.Warn.Connections") > 0;
            this._state = 1;
            DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
            if (defaultsAndOverrides.overrideTimeout) {
                this._endpoint = this._endpoint.timeout(defaultsAndOverrides.overrideTimeoutValue);
            }
            EndpointHolder endpointHolder = new EndpointHolder();
            endpointHolder.value = this._endpoint;
            this._transceiver = this._endpoint.serverTransceiver(endpointHolder);
            try {
                if (this._transceiver != null) {
                    this._endpoint = endpointHolder.value;
                    Connection connection = null;
                    try {
                        connection = new Connection(this._instance, this._transceiver, this._endpoint, this._adapter);
                        connection.waitForValidation();
                    }
                    catch (LocalException localException) {
                        if (connection != null) {
                            connection.waitUntilFinished();
                        }
                        return;
                    }
                    this._connections.addElement(connection);
                    break block15;
                }
                endpointHolder.value = this._endpoint;
                this._acceptor = this._endpoint.acceptor(endpointHolder);
                this._endpoint = endpointHolder.value;
                this._acceptor.listen();
                try {
                    this._threadPerIncomingConnectionFactory = new ThreadPerIncomingConnectionFactory(this);
                    this._threadPerIncomingConnectionFactory.start();
                }
                catch (Exception exception) {
                    this.error("cannot create thread for incoming connection factory", exception);
                    throw exception;
                }
            }
            catch (Exception exception) {
                if (this._acceptor != null) {
                    try {
                        this._acceptor.close();
                    }
                    catch (LocalException localException) {
                        // empty catch block
                    }
                }
                Object object = this;
                synchronized (object) {
                    this._state = 2;
                    this._acceptor = null;
                    this._connections = null;
                    this._threadPerIncomingConnectionFactory = null;
                }
                object = new SyscallException();
                ((LocalException)object).initCause(exception);
                throw object;
            }
        }
    }

    private void setState(int n) {
        if (this._state == n) {
            return;
        }
        switch (n) {
            case 0: {
                if (this._state != 1) {
                    return;
                }
                Enumeration enumeration = this._connections.elements();
                while (enumeration.hasMoreElements()) {
                    Connection connection = (Connection)enumeration.nextElement();
                    connection.activate();
                }
                break;
            }
            case 1: {
                if (this._state != 0) {
                    return;
                }
                Enumeration enumeration = this._connections.elements();
                while (enumeration.hasMoreElements()) {
                    Connection connection = (Connection)enumeration.nextElement();
                    connection.hold();
                }
                break;
            }
            case 2: {
                if (this._acceptor != null) {
                    this._acceptor.connectToSelf();
                }
                Enumeration enumeration = this._connections.elements();
                while (enumeration.hasMoreElements()) {
                    Connection connection = (Connection)enumeration.nextElement();
                    connection.destroy(0);
                }
                break;
            }
        }
        this._state = n;
        this.notifyAll();
    }

    public void warning(LocalException localException) {
        String string = "connection exception:\n" + localException.toString() + '\n' + this._acceptor.toString();
        this._instance.logger().warning(string);
    }

    public void error(String string, Exception exception) {
        String string2 = string + ":\n" + this.toString() + exception.toString();
        this._instance.logger().error(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Transceiver transceiver;
            block21: {
                transceiver = null;
                try {
                    transceiver = this._acceptor.accept(-1);
                }
                catch (SocketException socketException) {
                    throw socketException;
                }
                catch (TimeoutException timeoutException) {
                }
                catch (LocalException localException) {
                    if (!this._warn) break block21;
                    this.warning(localException);
                }
            }
            Connection connection = null;
            IncomingConnectionFactory incomingConnectionFactory = this;
            synchronized (incomingConnectionFactory) {
                while (this._state == 1) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this._state == 2) {
                    if (transceiver != null) {
                        try {
                            transceiver.close();
                        }
                        catch (LocalException localException) {
                            // empty catch block
                        }
                    }
                    try {
                        this._acceptor.close();
                    }
                    catch (LocalException localException) {
                        this._acceptor = null;
                        this.notifyAll();
                        throw localException;
                    }
                    this._acceptor = null;
                    this.notifyAll();
                    return;
                }
                Enumeration enumeration = this._connections.elements();
                for (int i = this._connections.size(); i > 0; --i) {
                    Connection connection2 = (Connection)this._connections.elementAt(i - 1);
                    if (!connection2.isFinished()) continue;
                    this._connections.removeElementAt(i - 1);
                }
                if (transceiver != null) {
                    try {
                        connection = new Connection(this._instance, transceiver, this._endpoint, this._adapter);
                    }
                    catch (LocalException localException) {
                        return;
                    }
                    this._connections.addElement(connection);
                }
            }
        }
    }

    private class ThreadPerIncomingConnectionFactory
    extends Thread {
        IncomingConnectionFactory _factory;

        ThreadPerIncomingConnectionFactory(IncomingConnectionFactory incomingConnectionFactory2) {
            this._factory = incomingConnectionFactory2;
        }

        public void run() {
            try {
                this._factory.run();
            }
            catch (Exception exception) {
                this._factory.error("exception in thread per incoming connection factory", exception);
            }
        }
    }
}

