/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Communicator;
import Ice.CommunicatorDestroyedException;
import Ice.EndpointParseException;
import Ice.Identity;
import Ice.IllegalIdentityException;
import Ice.LocatorPrx;
import Ice.ProxyParseException;
import Ice.ProxyUnmarshalException;
import Ice.RouterPrx;
import Ice.StringHolder;
import Ice.Util;
import IceInternal.BasicStream;
import IceInternal.DirectReference;
import IceInternal.Endpoint;
import IceInternal.IndirectReference;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.Reference;
import IceInternal.RouterInfo;
import IceUtil.Debug;
import IceUtil.StringUtil;
import java.util.Hashtable;
import java.util.Vector;

public final class ReferenceFactory {
    private Instance _instance;
    private Communicator _communicator;
    private RouterPrx _defaultRouter;
    private LocatorPrx _defaultLocator;
    private int _hashUpdateCounter = 0;

    public synchronized Reference create(Identity identity, Hashtable hashtable, String string, int n, boolean bl, Endpoint[] endpointArray, RouterInfo routerInfo) {
        if (this._instance == null) {
            throw new CommunicatorDestroyedException();
        }
        if (identity.name.length() == 0 && identity.category.length() == 0) {
            return null;
        }
        return new DirectReference(this._instance, this._communicator, identity, hashtable, string, n, bl, endpointArray, routerInfo);
    }

    public synchronized Reference create(Identity identity, Hashtable hashtable, String string, int n, boolean bl, String string2, RouterInfo routerInfo, LocatorInfo locatorInfo) {
        if (this._instance == null) {
            throw new CommunicatorDestroyedException();
        }
        if (identity.name.length() == 0 && identity.category.length() == 0) {
            return null;
        }
        return new IndirectReference(this._instance, this._communicator, identity, hashtable, string, n, bl, string2, routerInfo, locatorInfo);
    }

    public synchronized Reference copy(Reference reference) {
        if (this._instance == null) {
            throw new CommunicatorDestroyedException();
        }
        Identity identity = reference.getIdentity();
        if (identity.name.length() == 0 && identity.category.length() == 0) {
            return null;
        }
        return (Reference)reference.ice_clone();
    }

    public Reference create(String string) {
        Object object;
        Object object2;
        if (string.length() == 0) {
            return null;
        }
        int n = 0;
        int n2 = StringUtil.findFirstNotOf(string, " \t\n\r", n);
        if (n2 == -1) {
            ProxyParseException proxyParseException = new ProxyParseException();
            proxyParseException.str = string;
            throw proxyParseException;
        }
        String string2 = null;
        n = StringUtil.checkQuote(string, n2);
        if (n == -1) {
            ProxyParseException proxyParseException = new ProxyParseException();
            proxyParseException.str = string;
            throw proxyParseException;
        }
        if (n == 0) {
            n = StringUtil.findFirstOf(string, " \t\n\r:@", n2);
            if (n == -1) {
                n = string.length();
            }
            string2 = string.substring(n2, n);
        } else {
            string2 = string.substring(++n2, n);
            ++n;
        }
        if (n2 == n) {
            ProxyParseException proxyParseException = new ProxyParseException();
            proxyParseException.str = string;
            throw proxyParseException;
        }
        Identity identity = Util.stringToIdentity(string2);
        Debug.Assert(identity.name != null);
        if (identity.name.length() == 0) {
            if (identity.category.length() > 0) {
                IllegalIdentityException illegalIdentityException = new IllegalIdentityException();
                illegalIdentityException.id = identity;
                throw illegalIdentityException;
            }
            if (StringUtil.findFirstNotOf(string, " \t\n\r", n) != -1) {
                ProxyParseException proxyParseException = new ProxyParseException();
                proxyParseException.str = string;
                throw proxyParseException;
            }
            return null;
        }
        String string3 = "";
        int n3 = 0;
        boolean bl = false;
        String string4 = "";
        block9: while ((n2 = StringUtil.findFirstNotOf(string, " \t\n\r", n)) != -1 && string.charAt(n2) != ':' && string.charAt(n2) != '@') {
            char c;
            n = StringUtil.findFirstOf(string, " \t\n\r:@", n2);
            if (n == -1) {
                n = string.length();
            }
            if (n2 == n) break;
            object2 = string.substring(n2, n);
            if (((String)object2).length() != 2 || ((String)object2).charAt(0) != '-') {
                object = new ProxyParseException();
                ((ProxyParseException)object).str = string;
                throw object;
            }
            object = null;
            int n4 = StringUtil.findFirstNotOf(string, " \t\n\r", n);
            if (n4 != -1 && (c = string.charAt(n4)) != '@' && c != ':' && c != '-') {
                n2 = n4;
                n = StringUtil.checkQuote(string, n2);
                if (n == -1) {
                    ProxyParseException proxyParseException = new ProxyParseException();
                    proxyParseException.str = string;
                    throw proxyParseException;
                }
                if (n == 0) {
                    n = StringUtil.findFirstOf(string, " \t\n\r:@", n2);
                    if (n == -1) {
                        n = string.length();
                    }
                    object = string.substring(n2, n);
                } else {
                    object = string.substring(++n2, n);
                    ++n;
                }
            }
            switch (((String)object2).charAt(1)) {
                case 'f': {
                    if (object == null) {
                        ProxyParseException proxyParseException = new ProxyParseException();
                        proxyParseException.str = string;
                        throw proxyParseException;
                    }
                    StringHolder stringHolder = new StringHolder();
                    if (!StringUtil.unescapeString((String)object, 0, ((String)object).length(), stringHolder)) {
                        ProxyParseException proxyParseException = new ProxyParseException();
                        proxyParseException.str = string;
                        throw proxyParseException;
                    }
                    string3 = stringHolder.value;
                    continue block9;
                }
                case 't': {
                    if (object != null) {
                        ProxyParseException proxyParseException = new ProxyParseException();
                        proxyParseException.str = string;
                        throw proxyParseException;
                    }
                    n3 = 0;
                    continue block9;
                }
                case 'o': {
                    if (object != null) {
                        ProxyParseException proxyParseException = new ProxyParseException();
                        proxyParseException.str = string;
                        throw proxyParseException;
                    }
                    n3 = 1;
                    continue block9;
                }
                case 'O': {
                    if (object != null) {
                        ProxyParseException proxyParseException = new ProxyParseException();
                        proxyParseException.str = string;
                        throw proxyParseException;
                    }
                    n3 = 2;
                    continue block9;
                }
                case 'd': {
                    if (object != null) {
                        ProxyParseException proxyParseException = new ProxyParseException();
                        proxyParseException.str = string;
                        throw proxyParseException;
                    }
                    n3 = 3;
                    continue block9;
                }
                case 'D': {
                    if (object != null) {
                        ProxyParseException proxyParseException = new ProxyParseException();
                        proxyParseException.str = string;
                        throw proxyParseException;
                    }
                    n3 = 4;
                    continue block9;
                }
                case 's': {
                    if (object != null) {
                        ProxyParseException proxyParseException = new ProxyParseException();
                        proxyParseException.str = string;
                        throw proxyParseException;
                    }
                    bl = true;
                    continue block9;
                }
            }
            ProxyParseException proxyParseException = new ProxyParseException();
            proxyParseException.str = string;
            throw proxyParseException;
        }
        object2 = this._instance.routerManager().get(this.getDefaultRouter());
        object = this._instance.locatorManager().get(this.getDefaultLocator());
        if (n2 == -1) {
            return this.create(identity, this._instance.getDefaultContext(), string3, n3, bl, "", (RouterInfo)object2, (LocatorInfo)object);
        }
        Vector<Object> vector = new Vector<Object>();
        if (string.charAt(n2) == ':') {
            Object object3;
            Object object4;
            Vector<Object[]> vector2 = new Vector<Object[]>();
            n = n2;
            while (n < string.length() && string.charAt(n) == ':') {
                n2 = n + 1;
                if ((n = string.indexOf(58, n2)) == -1) {
                    n = string.length();
                }
                object4 = string.substring(n2, n);
                object3 = this._instance.endpointFactory().create((String)object4);
                if (object3 != null) {
                    vector.addElement(object3);
                    continue;
                }
                vector2.addElement((Object[])object4);
            }
            if (vector.size() == 0) {
                object4 = new EndpointParseException();
                object4.str = (String)vector2.elementAt(0);
                throw object4;
            }
            if (vector2.size() != 0 && this._instance.properties().getPropertyAsIntWithDefault("Ice.Warn.Endpoints", 1) > 0) {
                object4 = "Proxy contains unknown endpoints:";
                object3 = vector2.elements();
                while (object3.hasMoreElements()) {
                    object4 = (String)object4 + " `" + (String)object3.nextElement() + "'";
                }
                this._instance.logger().warning((String)object4);
            }
            object4 = new Endpoint[vector.size()];
            vector.copyInto((Object[])object4);
            return this.create(identity, this._instance.getDefaultContext(), string3, n3, bl, (Endpoint[])object4, (RouterInfo)object2);
        }
        if (string.charAt(n2) == '@') {
            StringHolder stringHolder;
            if ((n2 = StringUtil.findFirstNotOf(string, " \t\n\r", n2 + 1)) == -1) {
                ProxyParseException proxyParseException = new ProxyParseException();
                proxyParseException.str = string;
                throw proxyParseException;
            }
            n = StringUtil.checkQuote(string, n2);
            if (n == -1) {
                ProxyParseException proxyParseException = new ProxyParseException();
                proxyParseException.str = string;
                throw proxyParseException;
            }
            if (n == 0) {
                n = StringUtil.findFirstOf(string, " \t\n\r", n2);
                if (n == -1) {
                    n = string.length();
                }
            } else {
                ++n2;
            }
            if (!StringUtil.unescapeString(string, n2, n, stringHolder = new StringHolder()) || stringHolder.value.length() == 0) {
                ProxyParseException proxyParseException = new ProxyParseException();
                proxyParseException.str = string;
                throw proxyParseException;
            }
            string4 = stringHolder.value;
            return this.create(identity, this._instance.getDefaultContext(), string3, n3, bl, string4, (RouterInfo)object2, (LocatorInfo)object);
        }
        ProxyParseException proxyParseException = new ProxyParseException();
        proxyParseException.str = string;
        throw proxyParseException;
    }

    public Reference create(Identity identity, BasicStream basicStream) {
        String string;
        if (identity.name.length() == 0 && identity.category.length() == 0) {
            return null;
        }
        String[] stringArray = basicStream.readStringSeq();
        if (stringArray.length > 0) {
            if (stringArray.length > 1) {
                throw new ProxyUnmarshalException();
            }
            string = stringArray[0];
        } else {
            string = "";
        }
        byte by = basicStream.readByte();
        if (by < 0 || by > 4) {
            throw new ProxyUnmarshalException();
        }
        boolean bl = basicStream.readBool();
        String string2 = "";
        RouterInfo routerInfo = this._instance.routerManager().get(this.getDefaultRouter());
        LocatorInfo locatorInfo = this._instance.locatorManager().get(this.getDefaultLocator());
        int n = basicStream.readSize();
        if (n > 0) {
            Endpoint[] endpointArray = new Endpoint[n];
            for (int i = 0; i < n; ++i) {
                endpointArray[i] = this._instance.endpointFactory().read(basicStream);
            }
            return this.create(identity, this._instance.getDefaultContext(), string, by, bl, endpointArray, routerInfo);
        }
        Endpoint[] endpointArray = new Endpoint[]{};
        string2 = basicStream.readString();
        return this.create(identity, this._instance.getDefaultContext(), string, by, bl, string2, routerInfo, locatorInfo);
    }

    public synchronized void setDefaultRouter(RouterPrx routerPrx) {
        this._defaultRouter = routerPrx;
    }

    public synchronized RouterPrx getDefaultRouter() {
        return this._defaultRouter;
    }

    public synchronized void setDefaultLocator(LocatorPrx locatorPrx) {
        this._defaultLocator = locatorPrx;
    }

    public synchronized LocatorPrx getDefaultLocator() {
        return this._defaultLocator;
    }

    ReferenceFactory(Instance instance, Communicator communicator) {
        this._instance = instance;
        this._communicator = communicator;
    }

    synchronized void destroy() {
        if (this._instance == null) {
            throw new CommunicatorDestroyedException();
        }
        this._instance = null;
        this._communicator = null;
        this._defaultRouter = null;
        this._defaultLocator = null;
    }
}

