/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import Ice.Util;
import IceGrid.AdapterDescriptor;
import IceGrid.ObjectDescriptor;
import IceGrid.PropertyDescriptor;
import IceGridGUI.Application.Editor;
import IceGridGUI.Utils;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class PropertiesField
extends JTable {
    private DefaultTableModel _model;
    private Vector _columnNames;
    private boolean _editable = false;
    private LinkedList _hiddenProperties = new LinkedList();
    private Editor _editor;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PropertiesField(Editor editor) {
        this._columnNames = new Vector(2);
        this._columnNames.add("Name");
        this._columnNames.add("Value");
        this._editor = editor;
        AbstractAction deleteRow = new AbstractAction("Delete selected row(s)"){

            public void actionPerformed(ActionEvent e) {
                if (PropertiesField.this._editable) {
                    int selectedRow;
                    if (PropertiesField.this.isEditing()) {
                        PropertiesField.this.getCellEditor().stopCellEditing();
                    }
                    while ((selectedRow = PropertiesField.this.getSelectedRow()) != -1) {
                        PropertiesField.this._model.removeRow(selectedRow);
                    }
                }
            }
        };
        this.getActionMap().put("delete", deleteRow);
        this.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "delete");
    }

    public void setProperties(List properties, List adapters, String[] logs, Utils.Resolver resolver, boolean editable) {
        this._editable = editable;
        HashSet<String> hiddenPropertyNames = new HashSet<String>();
        HashSet<String> hiddenPropertyValues = new HashSet<String>();
        this._hiddenProperties.clear();
        if (adapters != null) {
            Iterator p = adapters.iterator();
            while (p.hasNext()) {
                ObjectDescriptor od;
                AdapterDescriptor ad = (AdapterDescriptor)p.next();
                hiddenPropertyNames.add(ad.name + ".Endpoints");
                hiddenPropertyNames.add(ad.name + ".PublishedEndpoints");
                Iterator q = ad.objects.iterator();
                while (q.hasNext()) {
                    od = (ObjectDescriptor)q.next();
                    hiddenPropertyValues.add(Util.identityToString(od.id));
                }
                q = ad.allocatables.iterator();
                while (q.hasNext()) {
                    od = (ObjectDescriptor)q.next();
                    hiddenPropertyValues.add(Util.identityToString(od.id));
                }
            }
        }
        if (logs != null) {
            for (int i = 0; i < logs.length; ++i) {
                hiddenPropertyValues.add(logs[i]);
            }
        }
        Vector vector = new Vector(properties.size());
        Iterator p = properties.iterator();
        while (p.hasNext()) {
            PropertyDescriptor pd = (PropertyDescriptor)p.next();
            if (hiddenPropertyNames.contains(pd.name)) {
                if (this._editable) {
                    this._hiddenProperties.add(pd);
                }
                hiddenPropertyNames.remove(pd.name);
                continue;
            }
            if (hiddenPropertyValues.contains(pd.value)) {
                if (this._editable) {
                    this._hiddenProperties.add(pd);
                }
                hiddenPropertyValues.remove(pd.value);
                continue;
            }
            Vector<String> row = new Vector<String>(2);
            row.add(Utils.substitute(pd.name, resolver));
            row.add(Utils.substitute(pd.value, resolver));
            vector.add(row);
        }
        if (this._editable) {
            Vector<String> newRow = new Vector<String>(2);
            newRow.add("");
            newRow.add("");
            vector.add(newRow);
        }
        this._model = new DefaultTableModel(vector, this._columnNames){

            public boolean isCellEditable(int row, int column) {
                return PropertiesField.this._editable;
            }
        };
        this._model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                if (PropertiesField.this._editable) {
                    Object lastKey = PropertiesField.this._model.getValueAt(PropertiesField.this._model.getRowCount() - 1, 0);
                    if (lastKey != null && !lastKey.equals("")) {
                        PropertiesField.this._model.addRow(new Object[]{"", ""});
                    }
                    PropertiesField.this._editor.updated();
                }
            }
        });
        this.setModel(this._model);
        this.setCellSelectionEnabled(this._editable);
        this.setOpaque(this._editable);
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
        DefaultTableCellRenderer cr = (DefaultTableCellRenderer)this.getDefaultRenderer(String.class);
        cr.setOpaque(this._editable);
    }

    public LinkedList getProperties() {
        if (!$assertionsDisabled && !this._editable) {
            throw new AssertionError();
        }
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        Vector<Vector> vector = this._model.getDataVector();
        LinkedList<PropertyDescriptor> result = new LinkedList<PropertyDescriptor>(this._hiddenProperties);
        Iterator<Vector> p = vector.iterator();
        while (p.hasNext()) {
            Vector row = p.next();
            String key = (String)row.elementAt(0);
            if (key == null || (key = key.trim()).equals("")) continue;
            String val = (String)row.elementAt(1);
            if (val == null) {
                val = "";
            }
            result.add(new PropertyDescriptor(key, val));
        }
        return result;
    }

    static {
        $assertionsDisabled = !PropertiesField.class.desiredAssertionStatus();
    }
}

