/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGrid.DbEnvDescriptor;
import IceGrid.PropertyDescriptor;
import IceGridGUI.Application.Adapter;
import IceGridGUI.Application.Communicator;
import IceGridGUI.Application.DbEnvEditor;
import IceGridGUI.Application.DescriptorHolder;
import IceGridGUI.Application.Editor;
import IceGridGUI.Application.TreeNode;
import IceGridGUI.Utils;
import IceGridGUI.XMLWriter;
import java.awt.Component;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class DbEnv
extends TreeNode
implements DescriptorHolder {
    private DbEnvDescriptor _descriptor;
    private final boolean _ephemeral;
    private DbEnvEditor _editor;
    private static DefaultTreeCellRenderer _cellRenderer;

    public static DbEnvDescriptor copyDescriptor(DbEnvDescriptor d) {
        return (DbEnvDescriptor)d.clone();
    }

    public static List copyDescriptors(List list) {
        LinkedList<DbEnvDescriptor> copy = new LinkedList<DbEnvDescriptor>();
        Iterator p = list.iterator();
        while (p.hasNext()) {
            copy.add(DbEnv.copyDescriptor((DbEnvDescriptor)p.next()));
        }
        return copy;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _cellRenderer.setLeafIcon(Utils.getIcon("/icons/16x16/database.png"));
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        actions[13] = !this._ephemeral;
        Object clipboard = this.getCoordinator().getClipboard();
        actions[14] = clipboard != null && (clipboard instanceof Adapter.AdapterCopy || clipboard instanceof DbEnvDescriptor);
        actions[15] = true;
        if (!this._ephemeral) {
            boolean[] parentActions = ((TreeNode)this._parent).getAvailableActions();
            actions[16] = parentActions[16];
            actions[17] = parentActions[17];
        }
        return actions;
    }

    public void copy() {
        this.getCoordinator().setClipboard(DbEnv.copyDescriptor(this._descriptor));
        this.getCoordinator().getActionsForMenu().get(14).setEnabled(true);
    }

    public void paste() {
        ((TreeNode)this._parent).paste();
    }

    public Editor getEditor() {
        if (this._editor == null) {
            this._editor = (DbEnvEditor)this.getRoot().getEditor(DbEnvEditor.class, this);
        }
        this._editor.show(this);
        return this._editor;
    }

    protected Editor createEditor() {
        return new DbEnvEditor();
    }

    public Object getDescriptor() {
        return this._descriptor;
    }

    public Object saveDescriptor() {
        return DbEnv.copyDescriptor(this._descriptor);
    }

    public void restoreDescriptor(Object savedDescriptor) {
        DbEnvDescriptor clone = (DbEnvDescriptor)savedDescriptor;
        this._descriptor.name = clone.name;
        this._descriptor.dbHome = clone.dbHome;
        this._descriptor.description = clone.description;
        this._descriptor.properties = clone.properties;
    }

    public void destroy() {
        ((Communicator)this._parent).getDbEnvs().destroyChild(this);
    }

    public boolean isEphemeral() {
        return this._ephemeral;
    }

    DbEnv(Communicator parent, String dbEnvName, DbEnvDescriptor descriptor, boolean ephemeral) {
        super(parent, dbEnvName);
        this._descriptor = descriptor;
        this._ephemeral = ephemeral;
    }

    static void writeDbProperties(XMLWriter writer, List properties) throws IOException {
        Iterator p = properties.iterator();
        while (p.hasNext()) {
            PropertyDescriptor pd = (PropertyDescriptor)p.next();
            LinkedList<String[]> attributes = new LinkedList<String[]>();
            attributes.add(DbEnv.createAttribute("name", pd.name));
            attributes.add(DbEnv.createAttribute("value", pd.value));
            writer.writeElement("dbproperty", attributes);
        }
    }

    void write(XMLWriter writer) throws IOException {
        if (!this._ephemeral) {
            LinkedList<String[]> attributes = new LinkedList<String[]>();
            attributes.add(DbEnv.createAttribute("name", this._descriptor.name));
            if (this._descriptor.dbHome.length() > 0) {
                attributes.add(DbEnv.createAttribute("home", this._descriptor.dbHome));
            }
            if (this._descriptor.description.length() == 0 && this._descriptor.properties.isEmpty()) {
                writer.writeElement("dbenv", attributes);
            } else {
                writer.writeStartTag("dbenv", attributes);
                if (this._descriptor.description.length() > 0) {
                    writer.writeElement("description", this._descriptor.description);
                }
                DbEnv.writeDbProperties(writer, this._descriptor.properties);
                writer.writeEndTag("dbenv");
            }
        }
    }
}

