/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI;

import Glacier2.RouterPrx;
import Glacier2.RouterPrxHelper;
import Ice.Endpoint;
import Ice.Identity;
import Ice.LocalException;
import Ice.NotRegisteredException;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import Ice.Properties;
import IceGrid.AdminPrx;
import IceGrid.AdminPrxHelper;
import IceGrid.AdminSessionPrx;
import IceGrid.NodeObserverPrx;
import IceGrid.NodeObserverPrxHelper;
import IceGrid.RegistryObserverPrx;
import IceGrid.RegistryObserverPrxHelper;
import IceGrid.RegistryPrx;
import IceGrid.RegistryPrxHelper;
import IceGridGUI.AdminRouter;
import IceGridGUI.Coordinator;
import IceGridGUI.NodeObserverI;
import IceGridGUI.RegistryObserverI;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.util.LayoutStyle;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.Enumeration;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class SessionKeeper {
    private LoginDialog _loginDialog;
    private LoginInfo _loginInfo;
    private Coordinator _coordinator;
    private Preferences _loginPrefs;
    private Session _session;
    static final /* synthetic */ boolean $assertionsDisabled;

    SessionKeeper(Coordinator coordinator) {
        this._coordinator = coordinator;
        this._loginDialog = new LoginDialog();
        this._loginPrefs = coordinator.getPrefs().node("Connection");
    }

    void createSession() {
        this._loginInfo = new LoginInfo(this._loginPrefs, this._coordinator);
        this._loginDialog.showDialog();
    }

    void relog(boolean showDialog) {
        if (this._loginInfo == null) {
            this.createSession();
        } else if (showDialog || !this.login(this._coordinator.getMainFrame())) {
            this._loginDialog.showDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean login(Component parent) {
        if (this._session != null) {
            this.logout(true);
        }
        if (!$assertionsDisabled && this._session != null) {
            throw new AssertionError();
        }
        Cursor oldCursor = parent.getCursor();
        try {
            parent.setCursor(Cursor.getPredefinedCursor(3));
            AdminSessionPrx session = this._coordinator.login(this._loginInfo, parent);
            if (session == null) {
                boolean bl = false;
                return bl;
            }
            this._coordinator.getStatusBar().setConnected(true);
            try {
                this._session = new Session(session, parent);
            }
            catch (LocalException e) {
                boolean bl = false;
                parent.setCursor(oldCursor);
                return bl;
            }
            this._loginInfo.save();
        }
        finally {
            parent.setCursor(oldCursor);
        }
        return true;
    }

    void sessionLost(String message) {
        JOptionPane.showMessageDialog(this._coordinator.getMainFrame(), message, "Session lost", 0);
        this.logout(false);
    }

    void logout(boolean destroySession) {
        if (this._session != null) {
            this._session.close(destroySession);
            this._coordinator.sessionLost();
            this._session = null;
        }
    }

    AdminSessionPrx getSession() {
        return this._session == null ? null : this._session.getSession();
    }

    AdminPrx getAdmin() {
        return this._session == null ? null : this._session.getAdmin();
    }

    AdminPrx getRoutedAdmin() {
        return this._session == null ? null : this._session.getRoutedAdmin();
    }

    static /* synthetic */ boolean access$300(SessionKeeper x0, Component x1) {
        return x0.login(x1);
    }

    static {
        $assertionsDisabled = !SessionKeeper.class.desiredAssertionStatus();
    }

    class Pinger
    extends Thread {
        private AdminSessionPrx _session;
        private long _period;
        private boolean _done = false;

        Pinger(AdminSessionPrx session, long period) {
            this._session = session;
            this._period = period;
        }

        public synchronized void run() {
            do {
                try {
                    this._session.keepAlive();
                }
                catch (LocalException e) {
                    this._done = true;
                    SwingUtilities.invokeLater(new Runnable(this, e){
                        private final /* synthetic */ LocalException val$e;
                        private final /* synthetic */ Pinger this$1;
                        {
                            this.this$1 = this$1;
                            this.val$e = val$e;
                        }

                        public void run() {
                            Pinger.access$2000(this.this$1).sessionLost("Failed to contact the IceGrid registry: " + this.val$e.toString());
                        }
                    });
                }
                if (this._done) continue;
                try {
                    this.wait(this._period);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!this._done);
        }

        public synchronized void done() {
            if (!this._done) {
                this._done = true;
                this.notify();
            }
        }

        static /* synthetic */ SessionKeeper access$2000(Pinger x0) {
            return x0.SessionKeeper.this;
        }
    }

    private class LoginDialog
    extends JDialog {
        private JTabbedPane _mainPane;
        private JTextField _registryUsername;
        private JLabel _registryUsernameLabel;
        private JPasswordField _registryPassword;
        private JLabel _registryPasswordLabel;
        private JCheckBox _registryUseSSL;
        private JCheckBox _registrySSLEnabled;
        private JTextField _registryInstanceName;
        private JTextField _registryEndpoints;
        private JTextField _routerUsername;
        private JLabel _routerUsernameLabel;
        private JPasswordField _routerPassword;
        private JLabel _routerPasswordLabel;
        private JCheckBox _routerUseSSL;
        private JCheckBox _routerSSLEnabled;
        private JTextField _routerInstanceName;
        private JTextField _routerEndpoints;
        private JTabbedPane _sslPane;
        private JTextField _keystore;
        private JPasswordField _keyPassword;
        private JTextField _advancedKeystore;
        private JPasswordField _advancedKeyPassword;
        private JPasswordField _keystorePassword;
        private JComboBox _alias;
        private JTextField _truststore;
        private JPasswordField _truststorePassword;
        private String _keystoreType;

        LoginDialog() {
            super(SessionKeeper.this._coordinator.getMainFrame(), "Login - IceGrid Admin", true);
            this._mainPane = new JTabbedPane();
            this._registryUsername = new JTextField(30);
            this._registryPassword = new JPasswordField(30);
            this._registryInstanceName = new JTextField(30);
            this._registryEndpoints = new JTextField(30);
            this._routerUsername = new JTextField(30);
            this._routerPassword = new JPasswordField(30);
            this._routerInstanceName = new JTextField(30);
            this._routerEndpoints = new JTextField(30);
            this._sslPane = new JTabbedPane();
            this._keystore = new JTextField(30);
            this._keyPassword = new JPasswordField(30);
            this._advancedKeystore = new JTextField(this._keystore.getDocument(), null, 30);
            this._advancedKeyPassword = new JPasswordField(this._keyPassword.getDocument(), null, 30);
            this._keystorePassword = new JPasswordField(30);
            this._alias = new JComboBox();
            this._truststore = new JTextField(30);
            this._truststorePassword = new JPasswordField(30);
            this.setDefaultCloseOperation(1);
            File defaultDir = new File(SessionKeeper.this._coordinator.getProperties().getProperty("IceSSL.DefaultDir"));
            this._keystoreType = SessionKeeper.this._coordinator.getProperties().getPropertyWithDefault("IceSSL.KeystoreType", KeyStore.getDefaultType());
            JButton okButton = new JButton("OK");
            ActionListener okListener = new ActionListener(this, SessionKeeper.this){
                private final /* synthetic */ SessionKeeper val$this$0;
                private final /* synthetic */ LoginDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                }

                public void actionPerformed(ActionEvent e) {
                    LoginDialog.access$100(this.this$1);
                    if (SessionKeeper.access$300(LoginDialog.access$200(this.this$1), this.this$1)) {
                        this.this$1.setVisible(false);
                    }
                }
            };
            okButton.addActionListener(okListener);
            this.getRootPane().setDefaultButton(okButton);
            JButton cancelButton = new JButton("Cancel");
            ActionListener cancelListener = new ActionListener(this){
                private final /* synthetic */ LoginDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.setVisible(false);
                }
            };
            cancelButton.addActionListener(cancelListener);
            AbstractAction registryUseSSL = new AbstractAction(this, "Use SSL for authentication"){
                private final /* synthetic */ LoginDialog this$1;
                {
                    this.this$1 = this$1;
                    super(x0);
                }

                public void actionPerformed(ActionEvent e) {
                    LoginDialog.access$500(this.this$1, LoginDialog.access$400(this.this$1).isSelected());
                }
            };
            this._registryUseSSL = new JCheckBox(registryUseSSL);
            AbstractAction routerUseSSL = new AbstractAction(this, "Use SSL for authentication"){
                private final /* synthetic */ LoginDialog this$1;
                {
                    this.this$1 = this$1;
                    super(x0);
                }

                public void actionPerformed(ActionEvent e) {
                    LoginDialog.access$700(this.this$1, LoginDialog.access$600(this.this$1).isSelected());
                }
            };
            this._routerUseSSL = new JCheckBox(routerUseSSL);
            AbstractAction registrySSLEnabled = new AbstractAction(this, "Enable IceSSL"){
                private final /* synthetic */ LoginDialog this$1;
                {
                    this.this$1 = this$1;
                    super(x0);
                }

                public void actionPerformed(ActionEvent e) {
                    LoginDialog.access$900(this.this$1, LoginDialog.access$800(this.this$1).isSelected());
                }
            };
            this._registrySSLEnabled = new JCheckBox(registrySSLEnabled);
            AbstractAction routerSSLEnabled = new AbstractAction(this, "Enable IceSSL"){
                private final /* synthetic */ LoginDialog this$1;
                {
                    this.this$1 = this$1;
                    super(x0);
                }

                public void actionPerformed(ActionEvent e) {
                    LoginDialog.access$1100(this.this$1, LoginDialog.access$1000(this.this$1).isSelected());
                }
            };
            this._routerSSLEnabled = new JCheckBox(routerSSLEnabled);
            this._keystore.setEditable(false);
            this._advancedKeystore.setEditable(false);
            AbstractAction chooseKeystore = new AbstractAction(this, "...", defaultDir, SessionKeeper.this){
                private JFileChooser _fileChooser;
                private final /* synthetic */ File val$defaultDir;
                private final /* synthetic */ SessionKeeper val$this$0;
                private final /* synthetic */ LoginDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$defaultDir = val$defaultDir;
                    this.val$this$0 = val$this$0;
                    super(x0);
                    this._fileChooser = new JFileChooser();
                }

                public void actionPerformed(ActionEvent e) {
                    String store = LoginDialog.access$1200(this.this$1).getText();
                    if (store == null || store.length() == 0) {
                        this._fileChooser.setCurrentDirectory(this.val$defaultDir);
                    } else {
                        File file = new File(store);
                        if (file.isAbsolute()) {
                            this._fileChooser.setSelectedFile(file);
                        } else {
                            this._fileChooser.setSelectedFile(new File(this.val$defaultDir, store));
                        }
                    }
                    int result = this._fileChooser.showOpenDialog(this.this$1);
                    if (result == 0) {
                        File file = this._fileChooser.getSelectedFile();
                        LoginDialog.access$1200(this.this$1).setText(file.getAbsolutePath());
                        LoginDialog.access$1400(this.this$1, file, LoginDialog.access$1300(this.this$1).getSelectedItem());
                    }
                }
            };
            this._truststore.setEditable(false);
            AbstractAction chooseTruststore = new AbstractAction(this, "...", defaultDir, SessionKeeper.this){
                private JFileChooser _fileChooser;
                private final /* synthetic */ File val$defaultDir;
                private final /* synthetic */ SessionKeeper val$this$0;
                private final /* synthetic */ LoginDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$defaultDir = val$defaultDir;
                    this.val$this$0 = val$this$0;
                    super(x0);
                    this._fileChooser = new JFileChooser();
                }

                public void actionPerformed(ActionEvent e) {
                    String store = LoginDialog.access$1500(this.this$1).getText();
                    if (store == null || store.length() == 0) {
                        this._fileChooser.setCurrentDirectory(this.val$defaultDir);
                    } else {
                        File file = new File(store);
                        if (file.isAbsolute()) {
                            this._fileChooser.setSelectedFile(file);
                        } else {
                            this._fileChooser.setSelectedFile(new File(this.val$defaultDir, store));
                        }
                    }
                    int result = this._fileChooser.showOpenDialog(this.this$1);
                    if (result == 0) {
                        File file = this._fileChooser.getSelectedFile();
                        LoginDialog.access$1500(this.this$1).setText(file.getAbsolutePath());
                    }
                }
            };
            this._registryUsername.setToolTipText("Your username");
            this._registryPassword.setToolTipText("Your password in this IceGrid registry");
            this._registryUseSSL.setToolTipText("Do you want to use SSL instead of username/password for authentication?");
            this._registryInstanceName.setToolTipText("The instance name of your IceGrid registry. For example: DemoIceGrid");
            this._registryEndpoints.setToolTipText("<html>Corresponds to the client endpoints of this IceGrid registry.<br>For example: tcp -h registry.domain.com -p 12000</html>");
            this._routerUsername.setToolTipText("Your username");
            this._routerPassword.setToolTipText("Your password in this Glacier2 router");
            this._routerUseSSL.setToolTipText("Do you want to use SSL instead of username/password for authentication?");
            this._routerInstanceName.setToolTipText("The instance name of your Glacier2 router. For example: DemoGlacier2");
            this._routerEndpoints.setToolTipText("<html>Corresponds to client endpoints of this Glacier2 router.<br>For example: ssl -h glacier2router.domain.com -p 11000</html>");
            this._keystore.setToolTipText("SSL keystore file");
            this._keyPassword.setToolTipText("Password for keys in the selected keystore file");
            this._advancedKeystore.setToolTipText("SSL keystore file");
            this._advancedKeyPassword.setToolTipText("Password for keys in the selected keystore file");
            this._keystorePassword.setToolTipText("Password used to check the integrity of the keystore");
            this._alias.setToolTipText("Use this alias when authenticating IceGrid Admin with the IceGrid registry or Glacier2 router");
            this._truststore.setToolTipText("SSL truststore file");
            this._truststorePassword.setToolTipText("Password used to check the integrity of the truststore");
            JPanel directPanel = null;
            FormLayout layout = new FormLayout("right:pref, 3dlu, pref", "");
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            builder.setDefaultDialogBorder();
            builder.setRowGroupingEnabled(true);
            builder.setLineGapSize(LayoutStyle.getCurrent().getLinePad());
            this._registryUsernameLabel = builder.append("Username", (Component)this._registryUsername);
            builder.nextLine();
            this._registryPasswordLabel = builder.append("Password", (Component)this._registryPassword);
            builder.nextLine();
            builder.append("", (Component)this._registryUseSSL);
            builder.nextLine();
            builder.append("", (Component)this._registrySSLEnabled);
            builder.nextLine();
            builder.append("IceGrid Instance Name", (Component)this._registryInstanceName);
            builder.nextLine();
            builder.append("IceGrid Registry Endpoint(s)", (Component)this._registryEndpoints);
            builder.nextLine();
            directPanel = builder.getPanel();
            JPanel routedPanel = null;
            FormLayout layout2 = new FormLayout("right:pref, 3dlu, pref", "");
            DefaultFormBuilder builder2 = new DefaultFormBuilder(layout2);
            builder2.setDefaultDialogBorder();
            builder2.setRowGroupingEnabled(true);
            builder2.setLineGapSize(LayoutStyle.getCurrent().getLinePad());
            this._routerUsernameLabel = builder2.append("Username", (Component)this._routerUsername);
            builder2.nextLine();
            this._routerPasswordLabel = builder2.append("Password", (Component)this._routerPassword);
            builder2.nextLine();
            builder2.append("", (Component)this._routerUseSSL);
            builder2.nextLine();
            builder2.append("", (Component)this._routerSSLEnabled);
            builder2.nextLine();
            builder2.append("Glacier2 Instance Name", (Component)this._routerInstanceName);
            builder2.nextLine();
            builder2.append("Glacier2 Router Endpoint(s)", (Component)this._routerEndpoints);
            builder2.nextLine();
            routedPanel = builder2.getPanel();
            this._mainPane.addTab("Direct", null, directPanel, "Log directly into the IceGrid registry");
            this._mainPane.addTab("Routed", null, routedPanel, "Log into the IceGrid registry through a Glacier2 router");
            this._mainPane.setBorder(Borders.DIALOG_BORDER);
            this._mainPane.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ LoginDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void stateChanged(ChangeEvent e) {
                    if (LoginDialog.access$1600(this.this$1).getSelectedIndex() == 0) {
                        LoginDialog.access$1700(this.this$1);
                    } else {
                        LoginDialog.access$1800(this.this$1);
                    }
                }
            });
            JPanel basicSSLPanel = null;
            FormLayout layout3 = new FormLayout("right:pref, 3dlu, fill:pref:grow, 3dlu, pref", "");
            DefaultFormBuilder builder3 = new DefaultFormBuilder(layout3);
            builder3.setDefaultDialogBorder();
            builder3.setRowGroupingEnabled(true);
            builder3.setLineGapSize(LayoutStyle.getCurrent().getLinePad());
            builder3.appendSeparator("Keystore");
            builder3.append("File", (Component)this._keystore);
            builder3.append(new JButton(chooseKeystore));
            builder3.nextLine();
            builder3.append("Key Password");
            builder3.append((Component)this._keyPassword, 3);
            builder3.nextLine();
            basicSSLPanel = builder3.getPanel();
            JPanel advancedSSLPanel = null;
            FormLayout layout4 = new FormLayout("right:pref, 3dlu, fill:pref:grow, 3dlu, pref", "");
            DefaultFormBuilder builder4 = new DefaultFormBuilder(layout4);
            builder4.setDefaultDialogBorder();
            builder4.setRowGroupingEnabled(true);
            builder4.setLineGapSize(LayoutStyle.getCurrent().getLinePad());
            builder4.appendSeparator("Keystore");
            builder4.append("File", (Component)this._advancedKeystore);
            builder4.append(new JButton(chooseKeystore));
            builder4.nextLine();
            builder4.append("Key Password");
            builder4.append((Component)this._advancedKeyPassword, 3);
            builder4.nextLine();
            builder4.append("Integrity Password");
            builder4.append((Component)this._keystorePassword, 3);
            builder4.nextLine();
            builder4.append("Alias");
            builder4.append((Component)this._alias, 3);
            builder4.nextLine();
            builder4.appendSeparator("Truststore");
            builder4.append("File", (Component)this._truststore);
            builder4.append(new JButton(chooseTruststore));
            builder4.nextLine();
            builder4.append("Integrity Password");
            builder4.append((Component)this._truststorePassword, 3);
            builder4.nextLine();
            advancedSSLPanel = builder4.getPanel();
            this._sslPane.addTab("Basic", basicSSLPanel);
            this._sslPane.addTab("Advanced", advancedSSLPanel);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(Borders.DIALOG_BORDER, "SSL Configuration");
            this._sslPane.setBorder(titledBorder);
            JPanel buttonBar = ButtonBarFactory.buildOKCancelBar(okButton, cancelButton);
            buttonBar.setBorder(Borders.DIALOG_BORDER);
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new BoxLayout(contentPane, 1));
            contentPane.add(this._mainPane);
            contentPane.add(this._sslPane);
            contentPane.add(buttonBar);
            this.pack();
            this.setResizable(false);
        }

        void showDialog() {
            if (!this.isVisible()) {
                this._mainPane.setSelectedIndex(((SessionKeeper)SessionKeeper.this)._loginInfo.routed ? 1 : 0);
                this._registryUsername.setText(((SessionKeeper)SessionKeeper.this)._loginInfo.registryUsername);
                this.selectRegistryUseSSL(((SessionKeeper)SessionKeeper.this)._loginInfo.registryUseSSL);
                this._registryInstanceName.setText(((SessionKeeper)SessionKeeper.this)._loginInfo.registryInstanceName);
                this._registryEndpoints.setText(((SessionKeeper)SessionKeeper.this)._loginInfo.registryEndpoints);
                this._registrySSLEnabled.setSelected(((SessionKeeper)SessionKeeper.this)._loginInfo.routerSSLEnabled);
                this._routerUsername.setText(((SessionKeeper)SessionKeeper.this)._loginInfo.routerUsername);
                this.selectRouterUseSSL(((SessionKeeper)SessionKeeper.this)._loginInfo.routerUseSSL);
                this._routerInstanceName.setText(((SessionKeeper)SessionKeeper.this)._loginInfo.routerInstanceName);
                this._routerEndpoints.setText(((SessionKeeper)SessionKeeper.this)._loginInfo.routerEndpoints);
                this._routerSSLEnabled.setSelected(((SessionKeeper)SessionKeeper.this)._loginInfo.routerSSLEnabled);
                this._keystore.setText(((SessionKeeper)SessionKeeper.this)._loginInfo.keystore);
                if (((SessionKeeper)SessionKeeper.this)._loginInfo.keystore == null) {
                    this.clearAlias();
                } else {
                    this.updateAlias(new File(((SessionKeeper)SessionKeeper.this)._loginInfo.keystore), ((SessionKeeper)SessionKeeper.this)._loginInfo.alias);
                }
                this._truststore.setText(((SessionKeeper)SessionKeeper.this)._loginInfo.truststore);
                if (((SessionKeeper)SessionKeeper.this)._loginInfo.routed) {
                    this.routedTabSelected();
                } else {
                    this.directTabSelected();
                }
                this.setLocationRelativeTo(SessionKeeper.this._coordinator.getMainFrame());
                this.setVisible(true);
            }
        }

        private void writeInfo() {
            ((SessionKeeper)SessionKeeper.this)._loginInfo.routed = this._mainPane.getSelectedIndex() == 1;
            ((SessionKeeper)SessionKeeper.this)._loginInfo.registryUsername = this._registryUsername.getText();
            ((SessionKeeper)SessionKeeper.this)._loginInfo.registryPassword = this._registryPassword.getPassword();
            ((SessionKeeper)SessionKeeper.this)._loginInfo.registryUseSSL = this._registryUseSSL.isSelected();
            ((SessionKeeper)SessionKeeper.this)._loginInfo.registrySSLEnabled = this._registrySSLEnabled.isSelected();
            ((SessionKeeper)SessionKeeper.this)._loginInfo.registryInstanceName = this._registryInstanceName.getText();
            ((SessionKeeper)SessionKeeper.this)._loginInfo.registryEndpoints = this._registryEndpoints.getText();
            ((SessionKeeper)SessionKeeper.this)._loginInfo.routerUsername = this._routerUsername.getText();
            ((SessionKeeper)SessionKeeper.this)._loginInfo.routerPassword = this._routerPassword.getPassword();
            ((SessionKeeper)SessionKeeper.this)._loginInfo.routerUseSSL = this._routerUseSSL.isSelected();
            ((SessionKeeper)SessionKeeper.this)._loginInfo.routerSSLEnabled = this._routerSSLEnabled.isSelected();
            ((SessionKeeper)SessionKeeper.this)._loginInfo.routerInstanceName = this._routerInstanceName.getText();
            ((SessionKeeper)SessionKeeper.this)._loginInfo.routerEndpoints = this._routerEndpoints.getText();
            ((SessionKeeper)SessionKeeper.this)._loginInfo.keystore = this._keystore.getText();
            ((SessionKeeper)SessionKeeper.this)._loginInfo.keyPassword = this._keyPassword.getPassword();
            ((SessionKeeper)SessionKeeper.this)._loginInfo.keystorePassword = this._keystorePassword.getPassword();
            ((SessionKeeper)SessionKeeper.this)._loginInfo.alias = this._alias.getSelectedItem() == null ? "" : this._alias.getSelectedItem().toString();
            ((SessionKeeper)SessionKeeper.this)._loginInfo.truststore = this._truststore.getText();
            ((SessionKeeper)SessionKeeper.this)._loginInfo.truststorePassword = this._truststorePassword.getPassword();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateAlias(File file, Object selectedAlias) {
            if (file.isFile()) {
                FileInputStream is = null;
                try {
                    is = new FileInputStream(file);
                }
                catch (IOException e) {
                    this.clearAlias();
                    return;
                }
                Vector<String> aliasVector = new Vector<String>();
                try {
                    KeyStore ks = KeyStore.getInstance(this._keystoreType);
                    ks.load(is, null);
                    Enumeration<String> p = ks.aliases();
                    while (p.hasMoreElements()) {
                        aliasVector.add(p.nextElement());
                    }
                }
                catch (Exception e) {
                    this.clearAlias();
                    return;
                }
                finally {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {}
                }
                this._alias.setModel(new DefaultComboBoxModel(aliasVector));
                if (selectedAlias != null) {
                    this._alias.setSelectedItem(selectedAlias);
                }
            } else {
                this.clearAlias();
            }
        }

        private void clearAlias() {
            this._alias.setModel(new DefaultComboBoxModel());
        }

        private void selectRegistryUseSSL(boolean selected) {
            this._registryUseSSL.setSelected(selected);
            this._registryUsername.setEnabled(!selected);
            this._registryUsernameLabel.setEnabled(!selected);
            this._registryPassword.setEnabled(!selected);
            this._registryPasswordLabel.setEnabled(!selected);
            if (selected && !this._registrySSLEnabled.isSelected()) {
                this.selectRegistrySSLEnabled(selected);
            }
        }

        private void selectRouterUseSSL(boolean selected) {
            this._routerUseSSL.setSelected(selected);
            this._routerUsername.setEnabled(!selected);
            this._routerUsernameLabel.setEnabled(!selected);
            this._routerPassword.setEnabled(!selected);
            this._routerPasswordLabel.setEnabled(!selected);
            if (selected && !this._routerSSLEnabled.isSelected()) {
                this.selectRouterSSLEnabled(selected);
            }
        }

        private void selectRegistrySSLEnabled(boolean selected) {
            this._registrySSLEnabled.setSelected(selected);
            this.recursiveSetEnabled(this._sslPane, selected);
            if (!selected && this._registryUseSSL.isSelected()) {
                this.selectRegistryUseSSL(selected);
            }
        }

        private void selectRouterSSLEnabled(boolean selected) {
            this._routerSSLEnabled.setSelected(selected);
            this.recursiveSetEnabled(this._sslPane, selected);
            if (!selected && this._routerUseSSL.isSelected()) {
                this.selectRouterUseSSL(selected);
            }
        }

        private void recursiveSetEnabled(Container c, boolean enabled) {
            for (int i = 0; i < c.getComponentCount(); ++i) {
                Component comp = c.getComponent(i);
                if (comp instanceof Container) {
                    this.recursiveSetEnabled((Container)comp, enabled);
                }
                comp.setEnabled(enabled);
            }
            c.setEnabled(enabled);
        }

        private void directTabSelected() {
            this.recursiveSetEnabled(this._sslPane, this._registrySSLEnabled.isSelected());
        }

        private void routedTabSelected() {
            this.recursiveSetEnabled(this._sslPane, this._routerSSLEnabled.isSelected());
        }

        static /* synthetic */ void access$100(LoginDialog x0) {
            x0.writeInfo();
        }

        static /* synthetic */ SessionKeeper access$200(LoginDialog x0) {
            return x0.SessionKeeper.this;
        }

        static /* synthetic */ JCheckBox access$400(LoginDialog x0) {
            return x0._registryUseSSL;
        }

        static /* synthetic */ void access$500(LoginDialog x0, boolean x1) {
            x0.selectRegistryUseSSL(x1);
        }

        static /* synthetic */ JCheckBox access$600(LoginDialog x0) {
            return x0._routerUseSSL;
        }

        static /* synthetic */ void access$700(LoginDialog x0, boolean x1) {
            x0.selectRouterUseSSL(x1);
        }

        static /* synthetic */ JCheckBox access$800(LoginDialog x0) {
            return x0._registrySSLEnabled;
        }

        static /* synthetic */ void access$900(LoginDialog x0, boolean x1) {
            x0.selectRegistrySSLEnabled(x1);
        }

        static /* synthetic */ JCheckBox access$1000(LoginDialog x0) {
            return x0._routerSSLEnabled;
        }

        static /* synthetic */ void access$1100(LoginDialog x0, boolean x1) {
            x0.selectRouterSSLEnabled(x1);
        }

        static /* synthetic */ JTextField access$1200(LoginDialog x0) {
            return x0._keystore;
        }

        static /* synthetic */ JComboBox access$1300(LoginDialog x0) {
            return x0._alias;
        }

        static /* synthetic */ void access$1400(LoginDialog x0, File x1, Object x2) {
            x0.updateAlias(x1, x2);
        }

        static /* synthetic */ JTextField access$1500(LoginDialog x0) {
            return x0._truststore;
        }

        static /* synthetic */ JTabbedPane access$1600(LoginDialog x0) {
            return x0._mainPane;
        }

        static /* synthetic */ void access$1700(LoginDialog x0) {
            x0.directTabSelected();
        }

        static /* synthetic */ void access$1800(LoginDialog x0) {
            x0.routedTabSelected();
        }
    }

    public static class LoginInfo {
        boolean routed = false;
        String registryUsername = System.getProperty("user.name");
        char[] registryPassword;
        boolean registryUseSSL = false;
        boolean registrySSLEnabled = false;
        String registryInstanceName = "IceGrid";
        String registryEndpoints = "";
        String routerUsername = System.getProperty("user.name");
        char[] routerPassword;
        boolean routerUseSSL = false;
        boolean routerSSLEnabled = false;
        String routerInstanceName = "Glacier2";
        String routerEndpoints = "";
        String keystore = System.getProperty("java.net.ssl.keyStore");
        char[] keyPassword;
        char[] keystorePassword;
        String alias;
        String truststore = System.getProperty("java.net.ssl.trustStore");
        char[] truststorePassword;
        private Preferences _connectionPrefs;

        LoginInfo(Preferences connectionPrefs, Coordinator coordinator) {
            this._connectionPrefs = connectionPrefs;
            String prop = System.getProperty("java.net.ssl.keyStorePassword");
            if (prop != null) {
                this.keystorePassword = prop.toCharArray();
            }
            if ((prop = System.getProperty("java.net.ssl.trustStorePassword")) != null) {
                this.truststorePassword = prop.toCharArray();
            }
            Properties properties = coordinator.getProperties();
            String defaultLocator = properties.getProperty("Ice.Default.Locator");
            ObjectPrx defaultLocatorProxy = null;
            if (!defaultLocator.equals("")) {
                try {
                    defaultLocatorProxy = coordinator.getCommunicator().stringToProxy(defaultLocator);
                }
                catch (LocalException e) {
                    // empty catch block
                }
            }
            if (defaultLocatorProxy != null) {
                this.registryInstanceName = defaultLocatorProxy.ice_getIdentity().category;
                this.registryEndpoints = "";
                Endpoint[] endpoints = defaultLocatorProxy.ice_getEndpoints();
                for (int i = 0; i < endpoints.length; ++i) {
                    if (i > 0) {
                        this.registryEndpoints = this.registryEndpoints + ":";
                    }
                    this.registryEndpoints = this.registryEndpoints + endpoints[i].toString();
                }
            } else {
                this.registryInstanceName = this._connectionPrefs.get("registry.instanceName", this.registryInstanceName);
                this.registryEndpoints = this._connectionPrefs.get("registry.endpoints", this.registryEndpoints);
            }
            String defaultRouter = properties.getProperty("Ice.Default.Router");
            ObjectPrx defaultRouterProxy = null;
            if (!defaultRouter.equals("")) {
                try {
                    defaultRouterProxy = coordinator.getCommunicator().stringToProxy(defaultRouter);
                }
                catch (LocalException e) {
                    // empty catch block
                }
            }
            if (defaultRouterProxy != null) {
                this.routerInstanceName = defaultRouterProxy.ice_getIdentity().category;
                this.routerEndpoints = "";
                Endpoint[] endpoints = defaultRouterProxy.ice_getEndpoints();
                for (int i = 0; i < endpoints.length; ++i) {
                    if (i > 0) {
                        this.routerEndpoints = this.routerEndpoints + ":";
                    }
                    this.routerEndpoints = this.routerEndpoints + endpoints[i].toString();
                }
            } else {
                this.routerInstanceName = this._connectionPrefs.get("router.instanceName", this.routerInstanceName);
                this.routerEndpoints = this._connectionPrefs.get("router.endpoints", this.routerEndpoints);
            }
            this.registrySSLEnabled = this._connectionPrefs.getBoolean("routerSSLEnabled", this.registrySSLEnabled);
            this.registryUsername = this._connectionPrefs.get("registry.username", this.registryUsername);
            this.registryUseSSL = this._connectionPrefs.getBoolean("registry.useSSL", this.registryUseSSL);
            this.registrySSLEnabled = this._connectionPrefs.getBoolean("registry.sslEnabled", this.registryUseSSL);
            this.routerUsername = this._connectionPrefs.get("router.username", this.routerUsername);
            this.routerUseSSL = this._connectionPrefs.getBoolean("router.useSSL", this.routerUseSSL);
            this.routerSSLEnabled = this._connectionPrefs.getBoolean("router.sslEnabled", this.routerUseSSL);
            this.routed = this._connectionPrefs.getBoolean("routed", this.routed);
            String val = properties.getProperty("IceSSL.Keystore");
            this.keystore = val.length() > 0 ? val : this._connectionPrefs.get("keystore", this.keystore);
            val = properties.getProperty("IceSSL.Alias");
            this.alias = val.length() > 0 ? val : this._connectionPrefs.get("alias", "");
            val = properties.getProperty("IceSSL.Truststore");
            this.truststore = val.length() > 0 ? val : this._connectionPrefs.get("truststore", this.keystore);
        }

        void save() {
            this._connectionPrefs.putBoolean("routed", this.routed);
            if (this.routed) {
                this._connectionPrefs.put("router.username", this.routerUsername);
                this._connectionPrefs.putBoolean("router.useSSL", this.routerUseSSL);
                this._connectionPrefs.putBoolean("router.sslEnabled", this.routerSSLEnabled);
                this._connectionPrefs.put("router.instanceName", this.routerInstanceName);
                this._connectionPrefs.put("router.endpoints", this.routerEndpoints);
            } else {
                this._connectionPrefs.put("registry.username", this.registryUsername);
                this._connectionPrefs.putBoolean("registry.useSSL", this.registryUseSSL);
                this._connectionPrefs.putBoolean("registry.sslEnabled", this.registrySSLEnabled);
                this._connectionPrefs.put("registry.instanceName", this.registryInstanceName);
                this._connectionPrefs.put("registry.endpoints", this.registryEndpoints);
            }
            this._connectionPrefs.put("keystore", this.keystore);
            this._connectionPrefs.put("alias", this.alias);
            this._connectionPrefs.put("truststore", this.truststore);
        }
    }

    private class Session {
        private final AdminSessionPrx _session;
        private Pinger _thread;
        private ObjectAdapter _adapter;
        private AdminPrx _admin;
        private AdminPrx _routedAdmin;
        private Identity _registryObserverIdentity = new Identity();
        private Identity _nodeObserverIdentity = new Identity();
        static final /* synthetic */ boolean $assertionsDisabled;

        Session(AdminSessionPrx session, Component parent) {
            this._session = session;
            try {
                this._admin = session.getAdmin();
            }
            catch (LocalException e) {
                SessionKeeper.this.logout(true);
                JOptionPane.showMessageDialog(parent, "Could not retrieve Admin proxy: " + e.toString(), "Login failed", 0);
                throw e;
            }
            long period = 0L;
            RouterPrx router = RouterPrxHelper.uncheckedCast(SessionKeeper.this._coordinator.getCommunicator().getDefaultRouter());
            if (router != null) {
                period = router.getSessionTimeout() * 1000L / 2L;
            } else {
                String str = this._admin.ice_getIdentity().category + "/Registry";
                RegistryPrx registry = RegistryPrxHelper.uncheckedCast(SessionKeeper.this._coordinator.getCommunicator().stringToProxy(str));
                period = registry.getSessionTimeout() * 1000 / 2;
            }
            this._thread = new Pinger(this._session, period);
            this._thread.start();
            try {
                this.registerObservers();
            }
            catch (LocalException e) {
                SessionKeeper.this.logout(true);
                JOptionPane.showMessageDialog(parent, "Could not register observers: " + e.toString(), "Login failed", 0);
                throw e;
            }
        }

        AdminSessionPrx getSession() {
            return this._session;
        }

        AdminPrx getAdmin() {
            return this._admin;
        }

        AdminPrx getRoutedAdmin() {
            if (!$assertionsDisabled && this._admin == null) {
                throw new AssertionError();
            }
            if (this._routedAdmin == null) {
                ObjectAdapter adminRouterAdapter = SessionKeeper.this._coordinator.getCommunicator().createObjectAdapterWithEndpoints("IceGrid.AdminRouter", "tcp -h localhost");
                this._routedAdmin = AdminPrxHelper.uncheckedCast(adminRouterAdapter.addWithUUID(new AdminRouter(this._admin)));
                adminRouterAdapter.activate();
            }
            return this._routedAdmin;
        }

        void close(boolean destroySession) {
            if (this._thread != null) {
                this._thread.done();
                while (true) {
                    try {
                        this._thread.join();
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
            }
            if (this._adapter != null) {
                try {
                    this._adapter.remove(this._registryObserverIdentity);
                }
                catch (NotRegisteredException e) {
                    // empty catch block
                }
                try {
                    this._adapter.remove(this._nodeObserverIdentity);
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
            }
            if (destroySession) {
                SessionKeeper.this._coordinator.destroySession(this._session);
            }
            SessionKeeper.this._coordinator.getStatusBar().setConnected(false);
        }

        private void registerObservers() {
            String category;
            RouterPrx router = RouterPrxHelper.uncheckedCast(SessionKeeper.this._coordinator.getCommunicator().getDefaultRouter());
            if (router == null) {
                category = "observer";
                this._adapter = SessionKeeper.this._coordinator.getCommunicator().createObjectAdapter("IceGrid.AdminGUI");
                this._adapter.activate();
                this._session.ice_getConnection().setAdapter(this._adapter);
            } else {
                category = router.getCategoryForClient();
                this._adapter = SessionKeeper.this._coordinator.getCommunicator().createObjectAdapterWithRouter("RoutedAdapter", router);
                this._adapter.activate();
            }
            this._registryObserverIdentity.name = "registry";
            this._registryObserverIdentity.category = category;
            this._nodeObserverIdentity.name = "node";
            this._nodeObserverIdentity.category = category;
            RegistryObserverI registryObserverServant = new RegistryObserverI(this._admin.ice_getIdentity().category, SessionKeeper.this._coordinator);
            RegistryObserverPrx registryObserver = RegistryObserverPrxHelper.uncheckedCast(this._adapter.add(registryObserverServant, this._registryObserverIdentity));
            NodeObserverPrx nodeObserver = NodeObserverPrxHelper.uncheckedCast(this._adapter.add(new NodeObserverI(SessionKeeper.this._coordinator), this._nodeObserverIdentity));
            if (router != null) {
                this._session.setObservers(registryObserver, nodeObserver);
            } else {
                this._session.setObserversByIdentity(this._registryObserverIdentity, this._nodeObserverIdentity);
            }
            registryObserverServant.waitForInit();
        }

        static {
            $assertionsDisabled = !(class$IceGridGUI$SessionKeeper == null ? (class$IceGridGUI$SessionKeeper = SessionKeeper.class$("IceGridGUI.SessionKeeper")) : class$IceGridGUI$SessionKeeper).desiredAssertionStatus();
        }
    }
}

