/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.BooleanHolder;
import Ice.Communicator;
import Ice.ConnectionI;
import Ice.Identity;
import Ice.LocalException;
import Ice.LocatorPrx;
import Ice.MarshalException;
import Ice.NoEndpointException;
import IceInternal.BasicStream;
import IceInternal.EndpointI;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.Reference;
import IceInternal.RoutableReference;
import IceInternal.RouterInfo;
import IceInternal.TraceLevels;
import IceUtil.StringUtil;
import java.util.Map;

public class IndirectReference
extends RoutableReference {
    private String _adapterId;
    private LocatorInfo _locatorInfo;
    private int _locatorCacheTimeout;
    static final /* synthetic */ boolean $assertionsDisabled;

    public IndirectReference(Instance inst, Communicator com, Identity ident, Map ctx, String fs, int md, boolean sec, String adptid, RouterInfo rtrInfo, LocatorInfo locInfo, boolean collocationOpt, int locatorCacheTimeout) {
        super(inst, com, ident, ctx, fs, md, sec, rtrInfo, collocationOpt);
        this._adapterId = adptid;
        this._locatorInfo = locInfo;
        this._locatorCacheTimeout = locatorCacheTimeout;
    }

    public final LocatorInfo getLocatorInfo() {
        return this._locatorInfo;
    }

    public final String getAdapterId() {
        return this._adapterId;
    }

    public EndpointI[] getEndpoints() {
        return new EndpointI[0];
    }

    public int getLocatorCacheTimeout() {
        return this._locatorCacheTimeout;
    }

    public Reference changeLocator(LocatorPrx newLocator) {
        LocatorInfo newLocatorInfo = this.getInstance().locatorManager().get(newLocator);
        if (this._locatorInfo != null && newLocatorInfo != null && newLocatorInfo.equals(this._locatorInfo)) {
            return this;
        }
        IndirectReference r = (IndirectReference)this.getInstance().referenceFactory().copy(this);
        r._locatorInfo = newLocatorInfo;
        return r;
    }

    public Reference changeAdapterId(String newAdapterId) {
        if (this._adapterId.equals(newAdapterId)) {
            return this;
        }
        IndirectReference r = (IndirectReference)this.getInstance().referenceFactory().copy(this);
        r._adapterId = newAdapterId;
        return r;
    }

    public Reference changeEndpoints(EndpointI[] newEndpoints) {
        if (newEndpoints == null || newEndpoints.length == 0) {
            return this;
        }
        return this.getInstance().referenceFactory().create(this.getIdentity(), this.getContext(), this.getFacet(), this.getMode(), this.getSecure(), newEndpoints, this.getRouterInfo(), this.getCollocationOptimization());
    }

    public Reference changeLocatorCacheTimeout(int newTimeout) {
        if (this._locatorCacheTimeout == newTimeout) {
            return this;
        }
        IndirectReference r = (IndirectReference)this.getInstance().referenceFactory().copy(this);
        r._locatorCacheTimeout = newTimeout;
        return r;
    }

    public void streamWrite(BasicStream s) throws MarshalException {
        super.streamWrite(s);
        s.writeSize(0);
        s.writeString(this._adapterId);
    }

    public String toString() {
        String result = super.toString();
        if (this._adapterId.length() == 0) {
            return result;
        }
        StringBuffer s = new StringBuffer();
        s.append(result);
        s.append(" @ ");
        String a = StringUtil.escapeString(this._adapterId, null);
        if (StringUtil.findFirstOf(a, " \t\n\r") != -1) {
            s.append('\"');
            s.append(a);
            s.append('\"');
        } else {
            s.append(a);
        }
        return s.toString();
    }

    public ConnectionI getConnection(BooleanHolder comp) {
        ConnectionI connection;
        while (true) {
            EndpointI[] endpts = super.getRoutedEndpoints();
            BooleanHolder cached = new BooleanHolder(false);
            if (endpts.length == 0 && this._locatorInfo != null) {
                endpts = this._locatorInfo.getEndpoints(this, this._locatorCacheTimeout, cached);
            }
            this.applyOverrides(endpts);
            try {
                connection = this.createConnection(endpts, comp);
                if (!$assertionsDisabled && connection == null) {
                    throw new AssertionError();
                }
            }
            catch (NoEndpointException ex) {
                throw ex;
            }
            catch (LocalException ex) {
                if (this.getRouterInfo() == null) {
                    if (!$assertionsDisabled && this._locatorInfo == null) {
                        throw new AssertionError();
                    }
                    this._locatorInfo.clearCache(this);
                    if (cached.value) {
                        TraceLevels traceLevels = this.getInstance().traceLevels();
                        if (traceLevels.retry < 2) continue;
                        String s = "connection to cached endpoints failed\nremoving endpoints from cache and trying one more time\n" + ex;
                        this.getInstance().initializationData().logger.trace(traceLevels.retryCat, s);
                        continue;
                    }
                }
                throw ex;
            }
            break;
        }
        if (this.getRouterInfo() != null) {
            connection.setAdapter(this.getRouterInfo().getAdapter());
        }
        if (!$assertionsDisabled && connection == null) {
            throw new AssertionError();
        }
        return connection;
    }

    public synchronized int hashCode() {
        if (this._hashInitialized) {
            return this._hashValue;
        }
        super.hashCode();
        int sz = this._adapterId.length();
        for (int i = 0; i < sz; ++i) {
            this._hashValue = 5 * this._hashValue + this._adapterId.charAt(i);
        }
        return this._hashValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IndirectReference)) {
            return false;
        }
        IndirectReference rhs = (IndirectReference)obj;
        if (!super.equals(rhs)) {
            return false;
        }
        if (!this._adapterId.equals(rhs._adapterId)) {
            return false;
        }
        if (this._locatorInfo == null ? rhs._locatorInfo != null : !this._locatorInfo.equals(rhs._locatorInfo)) {
            return false;
        }
        return this._locatorCacheTimeout == rhs._locatorCacheTimeout;
    }

    static {
        $assertionsDisabled = !IndirectReference.class.desiredAssertionStatus();
    }
}

