/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 2002  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2001  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2000  Gaspar Sinai <gsinai@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef STextView_h
#define STextView_h

#include "stoolkit/STextIndex.h"
#include "stoolkit/STextData.h"
#include "stoolkit/STypes.h"
#include "swidget/SComponent.h"
#include "swindow/SFont.h"
#include "swindow/SWindow.h"

typedef SBinHashtable<SS_UINT> SH_UINT;

/**
 * Provide a widget view to STextData
 */
class STextView : public SComponent, STextDataListener
{
public:

  STextView (void);
  STextView (const SString& utf8);
  virtual ~STextView ();

  /* Every component has this. */
  virtual void redraw (SCanvas *canvas, int x, int y, 
        unsigned int width, unsigned int height);

  virtual void redraw (SWindow *canvas, int x, int y, 
        unsigned int width, unsigned int height);

  void setFont (const SString& font, double fontSize=0.0);
  void setFontSize (double fontSize);

  void setForeground (const SColor& lrfg, const SColor& rlfg);
  virtual void setBackground (const SColor& bg);

  const SColor& getBackground ();
  const SColor& getForeground (bool lr);

  void setAlignment (bool align);
  void setMultiline (bool multiline);
  bool isMultiline () const;

  void setViewPort (const SLocation& viewPort);
  const SLocation& getViewPort();

  virtual void resize (const SDimension& d);

  STextIndex getTextIndex (const SLocation& l);
  SLocation  getTextLocation (const STextIndex& textIndex);

  void setLineEndMark (bool lineend);
  bool getLineEndMark () const;

  unsigned int getDocumentHeight () const;

  STextData textData;
  unsigned int lineHeight;
  unsigned int lineAscent;

  void setUnderlineColor (const SColor& c);
  void setClippingArea (int x, int y, 
          unsigned int width, unsigned int height);

private:
  void setPen();
  /* STextDataListener */
  void textChanged (void* src, const STextDataEvent& event);
  unsigned int drawGlyphLine (SCanvas* c, unsigned int line, 
       const SLocation& l, const SLocation& lb, const SLocation& le, bool iswindow=false);
  void drawGlyph (SCanvas* c, const SGlyph& g, const SLocation& l,
      unsigned int ext);

  SS_UINT*    getExtent (unsigned int line);
  SS_UINT*    getExtent (unsigned int line, SH_UINT* cache);
  SV_UINT     breakExtent (unsigned int line) const;

  unsigned int getExtent (const SGlyph& g);
  unsigned int getExtent (unsigned int line, unsigned int index) const;

  void       recalc ();
  void       recalc (unsigned int from, unsigned int until, int addcount);

  void       recalcBreaks ();
  void       clearExtents();

  SFont                font;
  double               fontSize;
  bool                 alignment;
  bool                 multiline;
  SPen                 lrpen;
  SPen                 rlpen;
  SLocation            viewPort;
  bool                 lineend;
  SColor               underlineColor;

  SV_UINT              lineSpan;

  /* This cacheing is in order to get SPEED */
  SBinVector<SS_UINT*> extents;
  SVector<SV_UINT>     breaks;
  int clipx; int clipy;
  int clipw; int cliph;
};

#endif /* STextView_h */
