/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 2002  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2001  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2000  Gaspar Sinai <gsinai@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#ifndef STypes_h
#define STypes_h

#define SD_YUDIT_VERSION "2.5.4"

// Get the SS_WORD16_t and u_int_32
#include <sys/types.h>
#include "stoolkit/SBinVector.h"
#include "stoolkit/SStringVector.h"

#ifdef HAVE_UTYPES
 typedef u_int8_t SS_WORD8;
 typedef u_int16_t SS_WORD16;
 typedef u_int32_t SS_WORD32;

#ifdef HAVE_LONG_LONG
  typedef u_int64_t SS_WORD64;
#else /* HAVE_LONG_LONG */
  typedef u_int32_t SS_WORD64;
#endif /* HAVE_LONG_LONG */

#else /* HAVE_UTYPES */
 typedef unsigned char SS_WORD8;
 typedef unsigned short SS_WORD16;
 typedef unsigned int SS_WORD32;

#ifdef HAVE_LONG_LONG
  typedef unsigned long long  SS_WORD64;
#else /* HAVE_LONG_LONG */
  typedef unsigned long  SS_WORD64;
#endif /* HAVE_LONG_LONG */

#endif /* HAVE_UTYPES */

typedef SS_WORD16 SS_UCS2;
typedef SS_WORD32 SS_UCS4;

typedef SBinVector<SS_UCS2> SV_UCS2;
typedef SBinVector<SS_UCS4> SV_UCS4;

/* processors calcualte with intergers fast */
typedef unsigned int SS_UINT;
typedef int SS_INT;

typedef SBinVector<SS_UINT> SV_UINT;
typedef SBinVector<SS_INT> SV_INT;

/*
 * SStringVector column0 = SStringTable[0];
 */
typedef SVector<SStringVector> SStringTable;

typedef int SAlignment;

#define SD_Left ((SAlignment)-1)
#define SD_Right ((SAlignment)1)
#define SD_Center ((SAlignment)0)


#endif /* STypes_h */
