#!/usr/bin/perl

#  Yudit Unicode Editor Source File
#
#  Copyright (C) 2000  Gaspar Sinai <gsinai@yudit.org>  
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#
# This script make shaping maps
# isolated
# final
# medial
# initial 
#

@full_date = localtime(time);
$year = $full_date[5] + 1900;
$mon = $full_date[4] + 1;
$mday = $full_date[3];
$date = sprintf ("%4d-%02d-%02d", $year, $mon, $mday);
$name="precompose.my";

%STUFF = ();
%KVLE = ();
%DECODER=();

while (<>)
{
  next if (split (';')) < 6;
  $present = $_[0];
  $present = hex $present;
  next if ($present > 0xffff);


  if ($_[5] =~ /<(isolated)> ([0-9A-Fa-f ]+)/
    || $_[5] =~ /<(medial)> ([0-9A-Fa-f ]+)/
    || $_[5] =~ /<(final)> ([0-9A-Fa-f ]+)/
    || $_[5] =~ /<(initial)> ([0-9A-Fa-f ]+)/)
  {
    $present = sprintf ("%04X", $present);
    $position = $1;
    @keys = split (' ', $2);
    $plain = "";
    for ($i=0; $i<=$#keys; $i++)
    {
      $plain .= sprintf ("%04X ", hex ($keys[$i]));
    }
    $DECODER{$present} = $plain;
    $STUFF{$plain} = "found";
    $KVLE{$plain . $position} =  $present;
  }
}

print <<EOD;
#
# Auto-generated by $0 $date
# $type map for Yudit.
# This file does not contain ligatures - STExtData need to be changed
# for that.
# Gapsar Sinai <gsinai\@yudit.org>
NAME=shape.my
TYPE=0
COMM=ftp://ftp.unicode.org/Public/UNIDATA/UnicodeData.txt
COMM=shapein -> isolated initial medial inal
COMM=Test A-> A i m f
SECTION=shapeout
ENCODE=1
KEY_WIDTH=1
VALUE_WIDTH=1
KEY_LENGTH=0
VALUE_LENGTH=0
#
EOD
$tashkeelin = 0;
for (sort (keys(%STUFF)))
{
  $key = $_;
  $isolated = $KVLE {$key . "isolated" };
  $final = $KVLE {$key . "final" };
  $initial = $KVLE {$key . "initial" };
  $medial = $KVLE {$key . "medial" };
  $isolated = "0000" if (!defined ($isolated));
  $initial = "0000" if (!defined ($initial));
  $medial = "0000" if (!defined ($medial));
  $final = "0000" if (!defined ($final));
  # Lam-Alef
  if ($key eq "0644 0622 "
   || $key eq "0644 0623 "
   || $key eq "0644 0625 "
   || $key eq "0644 0627 ")
  {
    print STDERR "forcing Lam-Alef in.\n";
  }
  elsif (length ($key) > 5)
  {
    # print STDERR "ignoring multiple $key keys - till STextData changed\n"; 
     next;
  }
  elsif ($tashkeelin == 0 && hex ($key) > 0x064B)
  {
#
# Concerning tashkeel: I would like text with it to not look garbled.
# Using shaped tashkeel would is nicer.
#
    print <<EOD;
#
# From: Karl Koehler <koehler\@or.uni-bonn.de>
# Concerning tashkeel: I would like text with it to not look garbled.
# Using shaped tashkeel would is nicer.
#
064B  -> FE70 FE70 FE71 FE70
064E  -> FE76 FE76 FE77 FE76
064F  -> FE78 FE78 FE79 FE78
0650  -> FE7A FE7A FE7B FE7A
0651  -> FE7C FE7C FE7D FE7C
0652  -> FE7E FE7E FE7F FE7E
# END
#
EOD

    $tashkeelin = 1;
  }
  print $key . " -> " .  "$isolated $initial $medial $final\n";
}
print <<EOD;
#
# This  decoder can be used to convert data from presentation form
#
COMM=ftp://ftp.unicode.org/Public/UNIDATA/UnicodeData.txt
# This file does not contain ligatures - STExtData need to be changed
# for that.
COMM=shapein -> isolated initial medial inal
COMM=Test A-> A i m f
SECTION=shapein
ENCODE=0
KEY_WIDTH=1
VALUE_WIDTH=1
KEY_LENGTH=0
VALUE_LENGTH=0
#
EOD
$tashkeelout = 0;
for (sort (keys(%DECODER)))
{
  $plain = $DECODER{$_};
  if ($tashkeelout == 0 && hex ($_) > 0xFE70)
  {
    print <<EOD;
#
# From: Karl Koehler <koehler\@or.uni-bonn.de>
# Concerning tashkeel: I would like text with it to not look garbled.
# Using shaped tashkeel would is nicer.
# Commented by gaspar - duplicate
# FE70 -> 064B
# FE71 -> 064B
# FE72 -> 064C
# FE74 -> 064D
# FE76 -> 064E
# FE77 -> 064E
# FE78 -> 064F
# FE79 -> 064F
# FE7A -> 0650
# FE7B -> 0650
# FE7C -> 0651
# FE7D -> 0651
# FE7E -> 0652
# FE7F -> 0652
# END
#
EOD
     $tashkeelout = 1;
  }
  print "$_ -> $plain\n";
}

print "# End\n";
exit (0);
