#!/usr/bin/perl -w 

%consonants = (
	"k" => "0x0a95",
	"kh" => "0x0a96",
	"g" => "0x0a97",
	"gh" => "0x0a98",
	"N^" => "0x0a99",
	"~N" => "0x0a99",
	"c" => "0x0a9a",
	"ch" => "0x0a9a",
	"chh" => "0x0a9b",
	"Ch" => "0x0a9b",
	"j" => "0x0a9c",
	"jh" => "0x0a9d",
	"~n" => "0x0a9e",
	"JN" => "0x0a9e",
	"T" => "0x0a9f",
	"Th" => "0x0aa0",
	"D" => "0x0aa1",
	"Dh" => "0x0aa2",
	"N" => "0x0aa3",
	"t" => "0x0aa4",
	"th" => "0x0aa5",
	"d" => "0x0aa6",
	"dh" => "0x0aa7",
	"n" => "0x0aa8",
	"p" => "0x0aaa",
	"ph" => "0x0aab",
	"b" => "0x0aac",
	"bh" => "0x0aad",
	"m" => "0x0aae",
	"y" => "0x0aaf",
	"r" => "0x0ab0",
	"l" => "0x0ab2",
	"L" => "0x0ab3",
	"ld" => "0x0ab3",
	"v" => "0x0ab5",
	"w" => "0x0ab5",
	"sh" => "0x0ab6",
	"shh" => "0x0ab7",
	"Sh" => "0x0ab7",
	"s" => "0x0ab8",
	"h" => "0x0ab9",
	"x" => "0x0a95 0x0acd 0x0ab7",
	"GY" => "0x0a9c 0x0acd 0x0a9e",
	"dny" => "0x0a9c 0x0acd 0x0a9e",
);

%vowels = (
	"" => " 0x0acd",
	"a" => "",
	"A" => " 0x0abe",
	"aa" => " 0x0abe",
	"i" => " 0x0abf",
	"I" => " 0x0ac0",
	"ii" => " 0x0ac0",
	"u" => " 0x0ac1",
	"U" => " 0x0ac2",
	"uu" => " 0x0ac2",
	"R^i" => " 0x0ac3",
	"RRi" => " 0x0ac3",
	"R^I" => " 0x0ac4",
	"RRI" => " 0x0ac4",
	"e" => " 0x0ac7",
	"ai" => " 0x0ac8",
	"A.c" => " 0x0ac9",
	"aa.c" => " 0x0ac9",
	"o" => " 0x0acb",
	"au" => " 0x0acc",
	".h" => " 0x0acd 0x200c",
);

print "// Gujarati kmap according to Itrans transliteration\n";
print "// by Miikka-Markus Alhonen 2002-01-26\n\n";
print "// Consonant + vowel/virama\n";

foreach $cons (sort keys %consonants) {
  foreach $vowel (sort keys %vowels) {
    printf ("\"%s%s=%s%s\",\n",$cons,$vowel,$consonants{$cons},$vowels{$vowel});
  }
}

print <<EOF;

// Independent vowels

"a=0x0a85",
"A=0x0a86",
"aa=0x0a86",
"i=0x0a87",
"I=0x0a88",
"ii=0x0a88",
"u=0x0a89",
"U=0x0a8a",
"uu=0x0a8a",
"R^i=0x0a8b",
"RRi=0x0a8b",
"e.c=0x0a8d",
"e=0x0a8f",
"ai=0x0a90",
"A.c=0x0a91",
"aa.c=0x0a91",
"o=0x0a93",
"au=0x0a94",
"R^I=0x0ae0",
"RRI=0x0ae0",

// Numbers

"0x30=0x0ae6",
"0x31=0x0ae7",
"0x32=0x0ae8",
"0x33=0x0ae9",
"0x34=0x0aea",
"0x35=0x0aeb",
"0x36=0x0aec",
"0x37=0x0aed",
"0x38=0x0aee",
"0x39=0x0aef",

// Other marks

".N=0x0a81",
".n=0x0a82",
"M=0x0a82",
"H=0x0a83",
".a=0x0abd",
".c=0x0ac5",
".h=0x0acd 0x200c",
"AUM=0x0ad0",
"OM=0x0ad0",
".=0x0964",
"..=0x0965",
"|=0x0964",
"||=0x0965",
";=0x0965",
"{\\\\rm 0x20 .}=0x002e",
"{}=0x200d",
EOF
