/*
 * qvwei.c
 *
 * The qvwei input method 
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "../im/impi.h"

char	imname[] = "λ";
char	imdscrpt[] = "λ뷨";

static void	reset();
static void	append(int ch);
static void	comp_appe(int prevch, int ch);

int	IMInit()
{
	maxeclen = 5;
	reset();
	return	0;
}

int	IMClearup()
{
	return	0;
}

int	IMSelect(select)
int	select;
{
	return	0;
}

int	IMFilter(ch)
int	ch;
{
	candstr[0] = '\0';
	result[0] = '\0';

	/* process currnet keystroke */
	if (isdigit(ch))
	{
		if ((eclen == 1) || (eclen == 3))
			comp_appe(extcode[eclen - 1], ch);
		else
			append(ch);

		if (eclen == 4)
		{
			int	qv, wei;

			qv = (extcode[0] - '0') * 10 + (extcode[1] - '0');
			wei = (extcode[2] - '0') * 10 + (extcode[3] - '0');

			reset();

                        if( qv >= 95 )  /* Process extend Qu 95 and 96 */
                        {
			    result[0] = qv - 95 + 0xA8;
			    result[1] = wei + 0x40;
                            /* skip 0xa87f and 0xa97f */
                            if ( (unsigned char)result[1] >= 0x7f ) result[1]++;
                        }
                        else
                        {
			    result[0] = qv + 0xa0;
			    result[1] = wei + 0xa0;
                        }
			result[2] = '\0';
		}
	}
	else
	{
		if ((ch == KEY_BACKSPACE) && (eclen > 0))
			extcode[--eclen] = '\0'; 
		else
		{
			result[0] = ch;
			result[1] = '\0';
		}
	}

	/* generate candinates */
	if ((eclen > 0) && (eclen < 4))
	{
		int		qv, wei, i, w;
		unsigned char	buf[3];
		char	*p;

		if (eclen > 1)
			qv = (extcode[0] - '0') * 10 + (extcode[1] - '0');
		else if (extcode[0] == '0')
			qv = 1;
		else
			qv = (extcode[0] - '0') * 10;
		
		wei = (eclen < 3) ? 0 : (extcode[2] - '0') * 10;

		p = candstr;

		for (i = 0; i <= 9; i++)
		{
                     if ( qv >= 95 )  /* Process extend Qu 95 and 96 */
                     {
                          if (( wei + i ) > 95 ) break;
                          buf[0] = qv - 95 + 0xA8;
                          buf[1] = wei + 0x40 + i;
                          if ( buf[1] >= 0x7f)  buf[1]++;
		       	  buf[2] = '\0';
			  p += sprintf(p, " %d:%s", i, buf);
                     }
                     else
                     {
			w = wei + i;
			if ((w > 0) && (w <= 94))
			{
				buf[0] = qv + 0xa0;
				buf[1] = wei + i + 0xa0;
				buf[2] = '\0';
				p += sprintf(p, " %d:%s", i, buf);
			}
                     }
		}
	}

	return	0;
}

static void	reset(void)
{
	eclen = 0;
	extcode[0] = '\0';
	candstr[0] = '\0';
	result[0] = '\0';
}

static void	append(ch)
int	ch;
{
	extcode[eclen++] = ch; 
	extcode[eclen] = '\0'; 
}

static void	comp_appe(prevch, ch)
int	prevch;
int	ch;
{
	if (prevch == '0')
	{
		if (ch != '0')
			append(ch);
	}
	else if (prevch == '9') 
	{
		if (ch <= '6')               /* expand to 96 from 94 */
			append(ch);
	}
	else
		append(ch);
}

