#include <stdio.h>
#include <string.h>
#include <sys/shm.h> 
static char version[] = "bxm.c 1.4 5/19/98";
#include "const_bxm.h"
#include "type_com.h"

#ifndef min
#define min(x,y) ((x)<(y)?(x):(y))
#define max(x,y) ((x)>(y)?(x):(y))
#endif

#include "../im/impi.h"

char    imname[] = "";
char    imdscrpt[] = "뷨";
#define SHMSZ (NUM_BXM*sizeof(ULONG) + NUM_DESC*sizeof(PhrDescriptor) + NUM_PHRSTR)

static void bxm_reset();
static ULONG encode();
static void OnNotHandle(int ch);
static USHORT ord2gbk(USHORT ord);
static USHORT ord2gb(USHORT ord);
static SHORT translate(SHORT ch);
static LONG filesize(FILE *stream);
static void add(USHORT pos_code, ULONG cur_code);
static void print();
static void get_str(char *dst, long pos, int n);
static void next_srch();
static void set_srchdir(SHORT direct);
static void save_cur_status();
static void restore_old_status();

static USHORT m_state, m_kb_code;
static int m_auto_select; 
static USHORT m_cur_pos, m_old_cur_pos;
static ULONG m_srch_code;
static ULONG m_code_mask = BASE_MASK;
static SHORT m_step_len, m_old_step_len;
static SHORT m_pos_out_buff, m_old_pos_out_buff;
static USHORT m_out_buff[10];
static ULONG m_out_code[10];
static SHORT m_last_pos, m_old_last_pos, m_cur_dir, m_old_cur_dir; 
							  
static ULONG *buff_bxm; /* ֵ仺 */   

static unsigned char *phr_buff; /* 黺 */

/* 鳤ȷ */
typedef struct tagPhrDescritor
{
	unsigned long  int s_bxm; /* ʼλãڴphrbxm.mb*/
	unsigned long  int s_phr; /* ʼλãڴ鴮phrstr.mb*/
	unsigned short int numPhr; /*  */
	unsigned short int numChar; /* ÿĳ */
}PhrDescriptor;
PhrDescriptor *pDesc;

/* 
m_last_pos --- ϴεĲλ
m_cur_dir --- ǰĲҷ(
*/

static FILE *fpBXM;

int m_shmid;
int IMInit()
{                         
	static int init_flg = 0;
	size_t n;
	key_t key;
	ULONG dwFileSize, dwFileSize_Str;   
	FILE *fpDesc;
DebugCode(
    FILE *fpLog;
    const CHAR *fnLog = "/tmp/yh_imp_log.log";
)
	const char *fnBXM = "/usr/local/yh/lib/bxm_gb.mb";        
	if (init_flg) return(0);
	eclen = 0;
	extcode[eclen] = '\0';
	maxeclen = 5;
DebugCode(
    fpLog = fopen(fnLog, "a+");
    if (fpLog == NULL) return(-1);
)
#if 0
	key = ftok("/usr/local/yh/lib/bxm_gb.mb", '&');
	if ((m_shmid = shmget(key, SHMSZ, 0644)) < 0)
	{
		m_shmid = shmget(key, SHMSZ, IPC_CREAT | IPC_EXCL | 0644);
		if (m_shmid < 0) return(-1);
		buff_bxm = shmat(m_shmid, NULL, 0);
		if (buff_bxm == NULL)
		{
			perror("No enough memory!\n");
			return(-1);
		}
DebugCode(
        fprintf(fpLog, "Share memory for %s create!\n", imname);
)
		fpBXM = fopen(fnBXM, "rb");
		if (fpBXM == NULL) return(-1); /* error occur */
		fseek(fpBXM, 0,SEEK_SET);
		if (fread(buff_bxm, 1, SHMSZ, fpBXM) != SHMSZ)
		{
			perror(" Error reading data!\n");
			return(-1);
		}
		fclose(fpBXM);
	}
	else
	{
		buff_bxm = shmat(m_shmid, NULL, 0);
		if (buff_bxm == NULL)
		{
			perror("Failed to get share memory!\n");
			return(-1);
		}
DebugCode(
    fprintf(fpLog, "Share memory for %s got!\n", imname);
    fclose(fpLog);
)
	}
#else
	{
		fpBXM = fopen(fnBXM, "r");
		if (fpBXM == NULL) return(-1); /* error occur */
		buff_bxm = (ULONG *) malloc(SHMSZ);
		if (fread(buff_bxm, 1, SHMSZ, fpBXM) != SHMSZ)
		{
			perror(" Error reading data!\n");
			return(-1);
		}
	}
#endif
	pDesc = (PhrDescriptor *)&buff_bxm[NUM_BXM];
	phr_buff = (unsigned char *)&pDesc[NUM_DESC];
	
	m_pos_out_buff = 0;
	bxm_reset();
	init_flg = 1;
	return(0);
}

int IMSelect(int select)
{
	bxm_reset();
	/*song free(buff_bxm);*/
    return  0;
}

int IMClearup()
{  
	bxm_reset();
	/*song shmdt(buff_bxm);*/
        free(buff_bxm);
    return  0;
}

int IMFilter(int asc_code)
{
	SHORT pos, event;
	
	int old;        

	ULONG code=0;
	if(IMInit() == -1) 
	{       		
		OnNotHandle(asc_code);
		return(0);
	}
	result[0] = '\0';
	if (asc_code & (~0x28ff))
	{
		OnNotHandle(asc_code);
		return(0);
	}

	m_kb_code = asc_code & 0x08ff;

	if (m_kb_code == ascCR)
	{
		if (eclen == 0) 
		{
			OnNotHandle(asc_code);
			return(0);
		}
		event = NEW_SRCH;
	}
	else event = translate(m_kb_code);
	switch(event) 
	{                 
		int n;
		case SELECT :

			if (m_kb_code == ' ') n = 1;
			else if (m_kb_code>=ALT_0 && m_kb_code<=ALT_9)
			{ /* alt + 0 -- alt + 9 */
					n = m_kb_code - ALT_0;
			}
			else if (m_kb_code>='0' && m_kb_code<='9')
			{
				n = m_kb_code - '0';
			}
			else 
			{
				OnNotHandle(asc_code);
				break; 
			}
			if (n == 0) n = 10;                     
			if (n<=m_pos_out_buff) 
			{
				int i;
				i = get_IM_str(result, n);
				result[i] = '\0';
				m_state = S_SELECTED;
				break;
			}
			OnNotHandle(asc_code);
			break;
		case FORWARD :
		case BACKWARD :
			save_cur_status();
			set_srchdir(event);
			m_pos_out_buff = 0;
			next_srch();
			if (m_pos_out_buff>0) 
			{
				print();
			}
			else
				restore_old_status();
			break;
		case NEW_CHAR :                 
            if (m_auto_select > 0)
            { /* try auto select */
                int i;
                i = get_IM_str(result, 1);
                result[i] = '\0';
            }
			code = encode();
			m_srch_code = code;
			m_cur_dir = FORWARD; /* ѯǰ */
			m_step_len = 1; /* ѭΪ 1 */
			m_cur_pos = 0;  /* ± 0 */
			m_last_pos = 0;  
			m_pos_out_buff = 0;

			next_srch();
            if (m_auto_select == 2 && m_pos_out_buff == 0)
            {
                ULONG old_mask, old_srch_code;
                /* try to see if there is any string match the prefix  */
                old_mask = m_code_mask; old_srch_code = m_srch_code;
                m_code_mask &= (0xfffffffful << (32-eclen * 5));
                m_srch_code &= m_code_mask;
                m_cur_pos = 0;  /* ± 0 */
                m_last_pos = 0;
                m_pos_out_buff = 0;
                next_srch();
                if (m_pos_out_buff > 0)
                {
                    m_code_mask = old_mask;
                    m_srch_code = old_srch_code;
                    result[0] = '\0';
                    m_pos_out_buff = 0;
                }
                else
                {
                    unsigned char ch;
                    /* ch = extcode[eclen-1]; */
                    extcode[0] = extcode[eclen-1];
                    eclen = 1; extcode[1] = '\0';
                    code = encode();
                    m_srch_code = code;
                    m_cur_pos = 0;  /* ± 0 */
                    m_last_pos = 0;
                    m_pos_out_buff = 0;
                    next_srch();
                }
            }
            else
            {
                if (m_auto_select == 2) result[0] = '\0';
            }
			print();
			break;
		case NEW_SRCH:
			bxm_reset();
			break;
		default:
			OnNotHandle(asc_code);
	}
	return(0);
}

static SHORT translate(SHORT ch)
/* תΪ¼ĺ */
{       
	m_auto_select = 0;
	switch(m_state)
	{
	case S_START:
		if (ch >= 'a' && ch <= 'z')
		{
			m_state = S_IN_SRCH;
			extcode[eclen++] = ch;			
			extcode[eclen] = '\0';			
			return(NEW_CHAR);
		}
		break;
	case S_IN_SRCH:
		if (ch >= 'a' && ch <= 'z') 
		{
            if ((eclen>=LEN_ENCODE) || ((eclen >= 2) &&
                    (m_pos_out_buff == 1)) )
            {
                if (m_pos_out_buff == 1)
                {
                    if (eclen >= LEN_ENCODE)
                    {
                        m_auto_select = 1;
                        eclen = 0;
                    }
                    else m_auto_select = 2;
                }
                else eclen = 0;
            }
            extcode[eclen++] = ch;
            extcode[eclen] = '\0';
            return(NEW_CHAR);
		}
		if (ch >= '0' && ch <= '9')
		{
			return(SELECT);        
		}
		if (ch >= ALT_0 && ch <= ALT_9)
		{
			return(SELECT);
		}
		if (ch == ' ')
		{
			return(SELECT);
		}
		
		if (ch == ascDEL || ch == ascBS)
		{
			eclen--;
			extcode[eclen] = '\0';			
			if (eclen>0)
			{
				return(NEW_CHAR);
			}
			m_state = S_START;
			return(NEW_SRCH);
		}
		if (ch == '+' || ch == '=' || ch == '>' || ch == '.')
		{
			return(FORWARD);
		}
		if (ch == '-' || ch == '_' || ch == '<' || ch == ',')
		{
			return(BACKWARD);
		}
		break;
	case S_SELECTED:
		if (ch >= ALT_0 && ch <= ALT_9)
		{
			return(SELECT);
		}
		if (ch >= 'a' && ch <= 'z') 
		{
			m_state = S_IN_SRCH;
			eclen = 0;
			extcode[eclen++] = ch;
			extcode[eclen] = '\0';			
			return(NEW_CHAR);
		}
		break;
	}
	return(UNKNOWN_CHAR);
}


static ULONG encode()
{
	ULONG code;
	SHORT i;
	code = 0;
	i = 0;
	while(i<eclen) {
		code <<=5;
		code |= extcode[i] - 'a' + 1;
		i++;
	}
	code <<= ((4-i)*5 + 12);
	if (eclen == 1)
	{
		m_code_mask = 0xf8000800; 
		code |= 0x0800;
	}
	else if (eclen == 2)
	{
		m_code_mask = 0xffc00400;       
		code |= 0x0400;
	}
	else if (eclen == 3)
	{
		m_code_mask = 0xfffe0200;   
		code |= 0x0200;
	}
	else
	{
		m_code_mask = 0xfffff000;       
	}
	return(code);
}

static void add(USHORT pos_code, ULONG cur_code)
{
	int freq;
	if (m_pos_out_buff == 0) {
		m_last_pos = pos_code;
	}
	m_out_code[m_pos_out_buff] = cur_code;
	m_out_buff[m_pos_out_buff++] = pos_code;
	if (pos_code > NUM_WORD) return;

	if (m_cur_dir == FORWARD)
	{ 
		int i;
		i = m_pos_out_buff-1;
		while(i>0)
		{
			if ((m_out_code[i] & 0x0fff) > (m_out_code[i-1] & 0x0fff))
			{
				unsigned long tmp;
				tmp = m_out_buff[i]; 
				m_out_buff[i] = m_out_buff[i-1];
				m_out_buff[i-1] = tmp;
				tmp = m_out_code[i]; 
				m_out_code[i] = m_out_code[i-1];
				m_out_code[i-1] = tmp;
				i--;
				continue;
			}
			break;
		}
	}
	else
	{
		int i;
		i = m_pos_out_buff-1;
		while(i>0)
		{
			if (m_out_buff[i-1] > NUM_WORD) break;
			if ((m_out_code[i] & 0x0f) < (m_out_code[i-1] & 0x0f))
			{
				unsigned long tmp;
				tmp = m_out_buff[i]; 
				m_out_buff[i] = m_out_buff[i-1];
				m_out_buff[i-1] = tmp;
				tmp = m_out_code[i]; 
				m_out_code[i] = m_out_code[i-1];
				m_out_code[i-1] = tmp;
				i--;
				continue;
			}
			break;
		}
	}
}

static void print()
{
	USHORT ch, wGbkCode;
	char phr_str[80];
	int col, i, j, n;
	col = 0;
	candstr[0] = '\0';
	if (m_pos_out_buff>0) 
	{
		if (m_cur_dir == FORWARD) 
		{
			for(i=0;i<m_pos_out_buff;i++) 
			{
				ch = '0' + i + 1;
				if (i == 9) ch = '0';
				candstr[col++] = ' '; 
				candstr[col++] = ch;
				candstr[col++] = ':';
				if (m_out_buff[i] <= NUM_WORD)
				{
					wGbkCode = ord2gb(m_out_buff[i]-1);
					candstr[col++] = wGbkCode>>8;
					candstr[col++] = wGbkCode & 0x0ff;
   				}
				else
				{ /* phrase string */ 
					n = m_out_buff[i] - NUM_WORD - 1;                       					
					for(j=0;j<NUM_DESC;j++)
					{
						if ((n >= pDesc[j].s_bxm) && 
								(n<(pDesc[j].s_bxm + pDesc[j].numPhr)))
						{
							long i;
							i = pDesc[j].s_phr + (n-pDesc[j].s_bxm)*pDesc[j].numChar;
							get_str((char *)&phr_str[0], i, pDesc[j].numChar);
							strncpy(&candstr[col], phr_str, pDesc[j].numChar);
							col += pDesc[j].numChar;
							break;
						}
					}
				}
			}
		}
		else 
		{                   
			for(i=m_pos_out_buff-1;i>=0;i--) 
			{
				ch = '0' + m_pos_out_buff - i;
				if (m_pos_out_buff-i == 10) ch = '0';
				candstr[col++] = ' ';
				candstr[col++] = ch;
				candstr[col++] = '.';
				if (m_out_buff[i] <= NUM_WORD)
				{
					wGbkCode = ord2gb(m_out_buff[i]-1);
					candstr[col++] = wGbkCode>>8;
					candstr[col++] = wGbkCode & 0x0ff;
				}
				else
				{ /* phrase string */ 
					n = m_out_buff[i] - NUM_WORD - 1;                       
					for(j=0;j<NUM_DESC;j++)
					{
						if (n >= pDesc[j].s_bxm && 
								n < (pDesc[j].s_bxm + pDesc[j].numPhr))
						{
							long i;
							
							i = pDesc[j].s_phr + (n-pDesc[j].s_bxm)*pDesc[j].numChar;

							get_str(phr_str, i, pDesc[j].numChar);
							strncpy(&candstr[col], phr_str, pDesc[j].numChar);
							col += pDesc[j].numChar;
							break;
						}
					}
				}
			}
		}
	}
	candstr[col] = '\0';
}

static void get_str(char *dst, long pos, int n)
/*  DOS ֵ䳬һ(64k), ƴ˺ pos λõƴ,
 Unix  32 λϵͳ, ֻҪűڴ, ȡӦ±
Ԫؼ */
{
	static long start_pos = 0; /* ǰ鴮ڴļеʼλ */
	strncpy(dst, (char *)&phr_buff[pos], n);
}

void bxm_reset()
{
	m_state = S_START;
	m_cur_dir = FORWARD; /* ѯǰ */
	m_step_len = 1; /* ѭΪ 1 */
	m_cur_pos = 0;  /* ± 0 */
	m_last_pos = 0;  
	m_pos_out_buff = 0;
	eclen = 0;
	candstr[0] ='\0';
	extcode[0] = '\0';
	result[0] = '\0';	
}

static void next_srch()
{
	ULONG cur_code;
	while(1) 
	{
		m_cur_pos+=m_step_len;
		if ((m_cur_pos > NUM_BXM)||(m_cur_pos <= 0)) 
		{
			/* Խ, δҵƥ,  */
			break;
		}
		cur_code = buff_bxm[m_cur_pos-1]; /* ȡֵ䵱ǰλõ */
		if ((cur_code & m_code_mask) == m_srch_code)
		/* ҪλĨ, Ȼ m_srch_code Ƚ */           
		{   
		
			if (is_full(m_cur_pos, cur_code)) 
			{
				m_cur_pos -= m_step_len;
				break;
			}

			add(m_cur_pos, cur_code);           
			if (m_pos_out_buff>=10) break;
			/* if is full , m_cur_pos -= m_step_len; back a step */
		}               
	}
}


static void set_srchdir(SHORT direct)
{
	SHORT tmp;
	if (direct == m_cur_dir) return;
	if (direct == FORWARD) 
	{
		/*  */
		m_cur_pos = m_last_pos;
		m_cur_dir = FORWARD;
		m_step_len = 1;
	}
	else
	{
		m_cur_pos = m_last_pos;
		m_cur_dir = BACKWARD;
		m_step_len = -1;
	}
}

static LONG filesize(FILE *stream)
/* ļС */
{
   LONG curpos, length;

   curpos = ftell(stream);
   fseek(stream, 0L, SEEK_END);
   length = ftell(stream);
   fseek(stream, curpos, SEEK_SET);
   return length;
}

static void save_cur_status()
{
	m_old_cur_pos = m_cur_pos;
	m_old_cur_dir = m_cur_dir;
	m_old_step_len = m_step_len;
	m_old_pos_out_buff = m_pos_out_buff;
	m_old_last_pos = m_last_pos;
}
static void restore_old_status()
{
	m_cur_pos = m_old_cur_pos;
	m_cur_dir = m_old_cur_dir;
	m_step_len = m_old_step_len;
	m_pos_out_buff = m_old_pos_out_buff;
	m_last_pos = m_old_last_pos;
}

int is_full(USHORT pos, ULONG cur_code)
{
	int i, len;

	i = 0; len = 0;
	while(i<m_pos_out_buff)
	{
		if (m_out_buff[i] <= NUM_WORD) len += 5;
		else 
		{
			int j;
			j = m_out_code[i] & 0x0f;           
			len += (pDesc[j].numChar+3);
		}           
		i++;
	}
	if (pos <= NUM_WORD) len += 5;
	else 
	{
		int j;
		j = cur_code & 0x0f;            
		len += (pDesc[j].numChar+3);
	}           
	if (len <= 59) return 0;
	return 1;
}

int get_IM_str(unsigned char *code_buf, int n)
{
	int i;                 
	unsigned short int wGbkCode;
	if (m_cur_dir == FORWARD)
	{
		i = n - 1;
	}
	else
	{
		i = m_pos_out_buff - n;
	}

	if (m_out_buff[i] <= NUM_WORD)
	{
			wGbkCode = ord2gb(m_out_buff[i]-1);
			code_buf[0] = wGbkCode>>8;
			code_buf[1] = wGbkCode & 0x0ff;
			return 2;
	}   
	else
	{                
		int j;
		long k;
		j = m_out_code[i] & 0x0f;   
		k = pDesc[j].s_phr + (m_out_buff[i] - NUM_WORD - 1 - pDesc[j].s_bxm)*pDesc[j].numChar;
		get_str((char *)&code_buf[0], k, pDesc[j].numChar);
		/*      c_display_string(col, pDesc[j].numChar, phr_str); */
		return pDesc[j].numChar;
	}
}

void OnNotHandle(int ch)
{
	result[0] = ch;
	result[1] = '\0';
}

USHORT ord2gb(USHORT ord)
{
    USHORT low, hig;
    low = (ord % 94) + 0xa1;
    hig =  ord / 94 + 0xb0;
	return((hig<<8) | low);
}
USHORT ord2gbk(USHORT ord)
{
    USHORT low, hig;
    low = (ord % 190) + 0x40;
    if (low >= 0x7f) low++;
    hig =  ord / 190 + 0x81;
	return((hig<<8) | low);
}

