#include "guile-script.h"

namespace uC
{

namespace Script
{

guileObjectFactory::guileObjectFactory()
{
  memchunk_ = g_mem_chunk_new("uC++ guile object mem chunks",
                              sizeof(guileObject),
                              sizeof(guileObject) * 256,
                              G_ALLOC_AND_FREE);
  
  gpointer mem = g_mem_chunk_alloc(memchunk_);
  null_obj_ = (new (mem) guileObject(*this));
}

guileObjectFactory::~guileObjectFactory()
{
  g_mem_chunk_destroy(memchunk_);
}


Object& guileObjectFactory::create_value(const Any& v)
{
  SCM scmobj;

  switch (v.typecode())
  {
    case TC_LONG:
    {
      long l;
      v >>= l;
      scmobj = gh_long2scm(l);
      break;
    }
    case TC_ULONG:
    {
      long ul;
      v >>= ul;
      scmobj = gh_ulong2scm(ul);
      break;
    }
    case TC_STRING:
    {
      const char *s;
      v >>= s;
      scmobj = gh_str02scm((char *)s);
      break;
    }
    case TC_NULL:
    default:
      return null_object();
  }

  return create_object(scmobj);
}

Object& guileObjectFactory::create_method(const Slot& str,
					  const Signature& sig)
{
  return null_object();
}

Object& guileObjectFactory::create_class(const ClassObject& c,
					 const Signature& supers)
{
  return null_object();
}

Object& guileObjectFactory::create_namespace()
{
  return null_object();
}

Object& guileObjectFactory::wrap_instance(const Object& klass,
                                           SigC::Object& obj)
{
  return null_object();
}

guileObject& guileObjectFactory::create_object(SCM sobj)
{
  if (sobj == SCM_UNSPECIFIED)
    throw Exception("SCM object creation error");

  gpointer mem = g_mem_chunk_alloc(memchunk_);
  return *(new (mem) guileObject(*this, sobj));
}

Object& guileObjectFactory::null_object()
{
  return *null_obj_;
}

void guileObjectFactory::destroy(Object& obj)
{
  guileObject& sobj = dynamic_cast<guileObject&>(obj);
  sobj.~guileObject();
  g_mem_chunk_free(memchunk_, &sobj);
}

guileObject::guileObject(guileObjectFactory& factory, SCM sobj)
    : Script::Object(factory)
{
  //Py_XINCREF(pyobj);
  
  sobj_ = sobj;
}

guileObject::~guileObject()
{
  //Py_XDECREF(pyobj_);
}

inline SCM guileObject::sobj()
{
  if (sobj_ == SCM_UNSPECIFIED)
    throw Exception("oops");

  return sobj_;
}

inline bool guileObject::is_null()
{
  return (sobj_ == SCM_UNSPECIFIED);
}

inline guileObject& guileObject::operator=(SCM sobj)
{
  sobj_ = sobj;
  return *this;
}

inline void guileObject::ensure(bool cond)
{
  if (!cond) throw Exception("hooo");
}

Namespace& guileObject::namespace_interface()
{
  return(*this);
}

Callable& guileObject::callable_interface()
{
  //ensure(PyCallable_Check(pyobj()));
  return(*this);
}

Instance& guileObject::instance_interface()
{
  //ensure(PyClass_Check(pyobj()));
  return(*this);
}

Any guileObject::value() const
{
  Any retval;
  
  // FIXME
  
  return retval;
}

SigC::Object& guileObject::object()
{
  throw 0;
}

Object& guileObject::get_attribute(const std::string& name)
{
#if 0
  PyObject *attr = PyObject_GetAttrString(pyobj(), (char *)name.c_str());
  
  if (attr)
  {
    return factory().create_object(attr);
  }
#endif
  throw 0;
}

void guileObject::set_attribute(const std::string& name, Object& value)
{
}

Object& guileObject::call(const ObjectContainer& args)
{
  throw 0;
}

Object& guileObject::member(const std::string& name)
{
#if 0  
  if (ptr() == Py_None)
  {
    Py::Mapping modules(Py::Module("sys").getAttr("modules").ptr());
    pyobj = modules.getItem("name").ptr();
  }
  else
    pyobj = getAttr(name).ptr();

#endif
  return factory().null_object();
}

void guileObject::insert(const std::string& name, uC::Script::Object& object)
{
}

}

}

