#include <iostream>
#include <string>

#include <uc++/plugin.h>
#include <uc++/script.h>

using namespace uC;
using namespace uC::Script;

bool print_error(const string& err)
{
  cout << "ERROR " << err << endl;
  
  return true;
}

bool logger(int level, const string& msg)
{
  cout << "LOG[" << level << "] " << msg << endl;
  return true;
}

class MyWrappedObject : public SigC::Object
{
  public:
    MyWrappedObject() {
      cout << "A new wrapped object has been created!!" << endl;
      set_sink();
    }
    virtual ~MyWrappedObject() {
      cout << "A wrapped object has been destroyed!!" << endl;
    }
};

class MyClassObject : public Script::ClassObject
{
  public:
    MyClassObject(Script::ObjectFactory& fact) : Script::ClassObject(fact) {
    }
    virtual SigC::Object& instantiate(const Script::ObjectContainer& args) {
      return *SigC::manage(new MyWrappedObject);
    }
};

void inject_mymodule(Script::Language *lang)
{
  cout << "registering extensions for language " << &lang << endl;
  
  try
  {
    Any value;
    
    Namespace& root_ns = lang->root_namespace();
    ObjectFactory& fact = lang->factory();
    
    Script::Object& obj = fact.create_namespace();
    root_ns.insert("mymodule", obj);

    Script::Namespace& myns = obj.namespace_interface();

    value <<= "Hi, this is a test";
    myns.insert("a_string", fact.create_value(value));
    myns.insert("A", 
		fact.create_class(*(SigC::manage(new MyClassObject(fact)))));
  }
  catch (Script::Exception& e)
  {
    cout << "exception while registering: " << e.what() << endl;
  }
}

PluginManager manager;

void language_registered(const string& name)
{
  Language *lang = manager.language(name);
  
  if (lang)
    SigC::pack(SigC::slot(inject_mymodule), 
	       lang)->tunnel(lang->tunnel());
}
  

int main()
{
  manager.error.connect(SigC::slot(print_error));
  manager.log.connect(SigC::slot(logger));

  manager.language_registered.connect(SigC::slot(language_registered));
  
  // load python support
  manager.load_plugin("python");

  manager.load_plugin("python.example1");
  manager.release_plugin("python.example1");

  //manager.load_plugin("guile");
}
