// $Id: UserDefaults.cc,v 1.2 2002/10/01 18:04:31 flaterco Exp $
/*  UserDefaults  Interface to ~/.xtide.xml

    Copyright (C) 1998  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "common.hh"

UserDefaults::UserDefaults () {
  // (homedir is later set in TideContext)
  xmlfilename = getenv ("HOME");
  if (xmlfilename.isNull())
    barf (NOHOMEDIR);
  xmlfilename += "/.xtide.xml";

  xmlparsetree = NULL;
  if ((xmlin = fopen (xmlfilename.aschar(), "r"))) {
    xmlparse();
    fclose (xmlin);
    struct xmltag *tag = xmlparsetree;
    while (tag) {
      if ((*(tag->name)) == "xtideoptions") {
        struct xmlattribute *a = tag->attributes;
        while (a) {

	  {
	    int b;
	    for (b=0; b<numcolors; b++) {
              if ((*(a->name)) == colorarg[b]) {
                colors[b] = (*(a->value));
                goto harmful;
              }
	    }
	  }

          if ((*(a->name)) == "el")
            el = (*(a->value));
          else if ((*(a->name)) == "fe")
            fe = (*(a->value));
          else if ((*(a->name)) == "u")
            u = (*(a->value));
          else if ((*(a->name)) == "z")
            z = (*(a->value));
          else if ((*(a->name)) == "df")
            df = (*(a->value));
          else if ((*(a->name)) == "hf")
            hf = (*(a->value));
          else if ((*(a->name)) == "tf")
            tf = (*(a->value));
          else if ((*(a->name)) == "tl")
            tl = (*(a->value));
          else if ((*(a->name)) == "nf")
            nf = (*(a->value));
          else if ((*(a->name)) == "ns")
            ns = (*(a->value));
          else if ((*(a->name)) == "in")
            in = (*(a->value));
          else if ((*(a->name)) == "ga") {
            ga_isnull = 0;
            ga = getposdouble (*(a->value));
          } else if ((*(a->name)) == "gl") {
            gl_isnull = 0;
            gl = getgldouble (*(a->value));
          } else if ((*(a->name)) == "lw") {
            lw_isnull = 0;
            lw = getposdouble (*(a->value));
          } else if ((*(a->name)) == "gw") {
            gw_isnull = 0;
            gw = max (mingwidth, getposint (*(a->value)));
          } else if ((*(a->name)) == "gh") {
            gh_isnull = 0;
            gh = max (mingheight, getposint (*(a->value)));
          } else if ((*(a->name)) == "tw") {
            tw_isnull = 0;
            tw = max (minttywidth, getposint (*(a->value)));
          } else if ((*(a->name)) == "th") {
            th_isnull = 0;
            th = max (minttyheight, getposint (*(a->value)));
          } else if ((*(a->name)) == "cw") {
            cw_isnull = 0;
            cw = max (mingwidth, getposint (*(a->value)));
          }
	harmful:
          a = a->next;
        }
      }
      tag = tag->next;
    }
  }
  freexml (xmlparsetree);
  xmlparsetree = NULL;
}

char
*UserDefaults::settingsid() {
  return "~/.xtide.xml";
}
