/* some routines here are taken from write(1), hence the following 
copyright  */

/*
 * Copyright (c) 1989, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Jef Poskanzer and Craig Leres of the Lawrence Berkeley Laboratory.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */



#include "xtelld.h"
#include <sys/param.h>
#include <sys/stat.h>
#include <ctype.h>
#include <pwd.h>
#include <time.h>
#include <utmp.h>

#ifndef UT_LINESIZE
struct utmp utmp_entry;
#define UT_LINESIZE sizeof(utmp_entry.ut_line)
#endif

/*
 * term_chk - check that a terminal exists, and get the message bit
 *     and the access time
 */


int term_chk(char *tty, int *msgsokP, time_t * atimeP)
{
    struct stat s;
    char *path;
    int fd;

/*    if ((strncmp("tty", tty, 3) != 0) && (strncmp("pts/", tty, 4) != 0))
	return 1; */
    path = malloc(strlen(tty) + sizeof(TTYDIR) + 1);
    if (path == NULL)
	return 1;
    strcpy(path, TTYDIR);
    strcat(path, tty);
    if (stat(path, &s) < 0) {
	free(path);
	return (1);
    }
    if (!S_ISCHR(s.st_mode)) {	/* check if it is really a character device */
        free(path);
	return 1;
    }
    fd = open(path, O_WRONLY);
    free(path);
    if (fd==-1)
        return 1;
    if (!isatty(fd)) {
        close(fd);
        return 1;
    };
    close(fd);
    *msgsokP = (s.st_mode & (S_IWRITE >> 3)) != 0;	/* group write bit */
    *atimeP = s.st_atime;
    return (0);
}


/*
 * search_utmp - search utmp for the "best" terminal to write to
 *
 * Ignores terminals with messages disabled, and of the rest, returns
 * the one with the most recent access time.  Returns as value the number
 * of the user's terminals with messages enabled, or -1 if the user is
 * not logged in at all.
 *
 */
#ifdef CYGWIN
short int search_utmp(user, tty)
char *user, *tty;
{
    strcpy(tty, "conin");
    return 1;
}
#else

#ifdef HAVE_GETUTENT
short int search_utmp(user, tty)
char *user, *tty;
{
    struct utmp *u;
    time_t bestatime, atime;
    int msgsok;
    short int nloggedttys, nttys;

    char atty[UT_LINESIZE + 1];

    setutent();
    nloggedttys = nttys = 0;
    bestatime = 0;
    while ((u = getutent()) != NULL)
	if (u->ut_type == USER_PROCESS &&
	    strncmp(user, u->ut_name, sizeof(u->ut_name)) == 0) {
	    ++nloggedttys;
	    (void) strncpy(atty, u->ut_line, UT_LINESIZE);
	    atty[UT_LINESIZE] = '\0';
	    if (term_chk(atty, &msgsok, &atime))
		continue;	/* bad term? skip */
	    if (!msgsok)
		continue;	/* skip ttys with msgs off */
	    ++nttys;
	    /* if this is a newly created tty (eg fresh
	     * xterm), then user will not have typed at
	     * it, and the atime will be way in the
	     * past. So, if the atime is < utmp creation
	     * time, use the utmp time. */
	    if (atime < u->ut_time)
		atime = u->ut_time;
	    if (atime > bestatime) {
		bestatime = atime;
		(void) strcpy(tty, atty);
	    }
	}

    endutent();
    if (nloggedttys == 0) {
	return (-1);
    }
/*        if (nttys == 0) {
                return(-1);
        } 
	*/
    return (nttys);
}

#else

short int search_utmp(user, tty)
char *user, *tty;
{
    struct utmp u;
    time_t bestatime, atime;
    int ufd, msgsok;
    short int nloggedttys, nttys;
    char atty[UT_LINESIZE + 1];

    if ((ufd = open(_PATH_UTMP, O_RDONLY)) < 0) {
	return (0);
    }
    nloggedttys = nttys = 0;
    bestatime = 0;
    while (read(ufd, (char *) &u, sizeof(u)) == sizeof(u))
	if (			/* u.ut_type == USER_PROCESS && */
	       strncmp(user, u.ut_name, sizeof(u.ut_name)) == 0) {
	    ++nloggedttys;
	    (void) strncpy(atty, u.ut_line, UT_LINESIZE);
	    atty[UT_LINESIZE] = '\0';
	    if (term_chk(atty, &msgsok, &atime))
		continue;	/* bad term? skip */
	    if (!msgsok)
		continue;	/* skip ttys with msgs off */
	    ++nttys;
	    /* if this is a newly created tty (eg fresh
	     * xterm), then user will not have typed at
	     * it, and the atime will be way in the
	     * past. So, if the atime is < utmp creation
	     * time, use the utmp time. */
	    if (atime < u.ut_time)
		atime = u.ut_time;
	    if (atime > bestatime) {
		bestatime = atime;
		(void) strcpy(tty, atty);
	    }
	}

    (void) close(ufd);
    if (nloggedttys == 0) {
	return (-1);
    }
/*        if (nttys == 0) {
                return(-1);
        } 
	*/
    return (nttys);
}

#endif				/* HAVE_GETUTENT */

#endif /* CYGWIN */

/*
 * do_write - actually write it to tty
 */
int do_write(tty, buff)
char *tty, *buff;
{
    FILE *file;
    char path[20];

    strcpy(path, TTYDIR);
    strncat(path, tty, sizeof(path) - 1 - sizeof(TTYDIR));
    if (!(file = fopen(path, "w"))) {
	return (-1);
    }
    fprintf(file, "%s", buff);
    fclose(file);
    return (0);
}

/*
 * log_write - write log if you can
 */
short int log_write(const char *toluser, const char *buff)
{   
    int filedes;
    FILE *file;
    if ((filedes = logFILE(toluser)) != -1) {
        file = fdopen(filedes, "w");
        if (!file)
            return 0;
	fprintf(file, "%s", buff);
	fclose(file);
    }
    return 0;
}


int
parse_and_write(char *s, char *identity, char *addr, unsigned int msgcount)
{
    char fromluser[MAX_LUSERNAME_LENGTH], toluser[MAX_LUSERNAME_LENGTH],
	totty[MAX_TTY_LENGTH];
    char *firstcolon, *secondcolon, *thirdcolon;
    char foundtty[MAX_TTY_LENGTH+1];
    char buffer[14 + MAX_LUSERNAME_LENGTH*3 + MAX_MSG_LENGTH + MAX_TIME_LENGTH + MAX_HOSTNAME];
    unsigned int fromlusernamelength, tolusernamelength, tottylength;
    short search_result;
    char *poi;
    int msgok;    
    time_t atime;

    fromluser[0] = toluser[0] = totty[0] = '\0';

    firstcolon = strchr(s, ':');
    if (!firstcolon)
	return -4;
    secondcolon = strchr(firstcolon + 1, ':');
    if (!secondcolon)
	return -4;
    thirdcolon = strchr(secondcolon + 1, ':');
    if (!thirdcolon)
	return -4;

/* strictly speaking, this is incorrect, but we 
need to be able to send 8-bit characters... */
    for (poi = s; (*poi) != '\0'; poi++)
	if ((unsigned int) (*poi) < 32)
	    (*poi) = '?';


    fromlusernamelength = firstcolon - s;
    if (fromlusernamelength > MAX_LUSERNAME_LENGTH)
	fromlusernamelength = MAX_LUSERNAME_LENGTH;

    tolusernamelength = secondcolon - firstcolon - 1;
    if (tolusernamelength > MAX_LUSERNAME_LENGTH)
	tolusernamelength = MAX_LUSERNAME_LENGTH;

    tottylength = thirdcolon - secondcolon - 1;
    if (tottylength > MAX_TTY_LENGTH)
	tottylength = MAX_TTY_LENGTH;

    strncat(fromluser, s, fromlusernamelength);
    strncat(toluser, firstcolon + 1, tolusernamelength);
    strncat(totty, secondcolon + 1, tottylength);
    if (tottylength == 0) {
	search_result = search_utmp(toluser, foundtty);
	if (search_result == -1)
	    return -1;		/* not logged in */
	else if (search_result == 0)
	    return -2;		/* disabled messages */
    } else {
        if (term_chk(totty, &msgok, &atime))
            return -3;
        strncpy(foundtty, totty, sizeof(foundtty)-1);
        foundtty[sizeof(foundtty)-1]='\0';
    }




    if (msgcount == 1) {
	time_t tim = time(NULL);
	char bleah[MAX_TIME_LENGTH];
	strftime(bleah, sizeof(bleah), "%R %d-%b-%y", localtime(&tim));
	if (identity == NULL) {
	    strcpy(buffer, "\n\007~");
	    strcat(buffer, fromluser);
	    strcat(buffer, "@");
	    strcat(buffer, addr);
	    strcat(buffer, "[");
	    strcat(buffer, bleah);
	    strcat(buffer, "]:\n");
	    strcat(buffer, fromluser);
	    strcat(buffer, ": ");
	    strcat(buffer, thirdcolon + 1);
	    strcat(buffer, "\n");
	    //snprintf(buffer, sizeof(buffer), "\n\007~%s@%s[%s]:\n%s: %s\n",fromluser, addr, bleah, fromluser, thirdcolon+1);                      
	} else if (fromlusernamelength!=0 && !strncmp(fromluser, identity, fromlusernamelength)) {
	    strcpy(buffer, "\n\007");
	    strcat(buffer, fromluser);
	    strcat(buffer, "@");
	    strcat(buffer, addr);
	    strcat(buffer, "[");
	    strcat(buffer, bleah);
	    strcat(buffer, "]:\n");
	    strcat(buffer, fromluser);
	    strcat(buffer, ": ");
	    strcat(buffer, thirdcolon + 1);
	    strcat(buffer, "\n");
	    //snprintf(buffer, sizeof(buffer), "\n\007%s@%s[%s]:\n%s: %s\n", fromluser, addr, bleah, fromluser, thirdcolon+1);  
	} else {
	    strcpy(buffer, "\n\007");
	    strcat(buffer, fromluser);
	    strcat(buffer, "(");
	    strncat(buffer, identity, MAX_LUSERNAME_LENGTH);
	    strcat(buffer, ")@");
	    strcat(buffer, addr);
	    strcat(buffer, "[");
	    strcat(buffer, bleah);
	    strcat(buffer, "]:\n");
	    strcat(buffer, fromluser);
	    strcat(buffer, ": ");
	    strcat(buffer, thirdcolon + 1);
	    strcat(buffer, "\n");
	    //snprintf(buffer, sizeof(buffer), "\n\007%s(%s)@%s[%s]:\n%s: %s\n", fromluser, identity, addr, bleah, fromluser, thirdcolon+1);
	}
    } else {
	strcpy(buffer, "\007");
	strcat(buffer, fromluser);
	strcat(buffer, ": ");
	strcat(buffer, thirdcolon + 1);
	strcat(buffer, "\n");
//      snprintf(buffer, sizeof(buffer), "\007%s: %s\n", fromluser, thirdcolon+1);    
    }
    log_write(toluser, buffer);
    if (do_write(foundtty, buffer) == -1)
	return -3;		/* cannot write */

    return 0;
}
