/*******************************************************************
 *
 * Licensed under a dual GPL/BSD license.   (See LICENSE file for more info.)
 *
 * File: ipc_callout.h
 *
 * Authors: Chris.Hessing@utah.edu
 *
 *******************************************************************/

#ifndef _IPC_CALLOUT_H_
#define _IPC_CALLOUT_H_

#include <sys/socket.h>

// Username and password values.
#define USERNAME         1
#define PASSWORD         2

// Certificate related items.
#define USER_CERT        3
#define USER_KEY         4
#define ROOT_CERT        5
#define ROOT_DIR         6
#define CRL_DIR          7
#define CHUNK_SIZE       8
#define RANDOM_FILE      9

// Allowed types
#define ALLOWED_PHASE1  10
#define ALLOWED_PHASE2  11

// SIM/AKA Values
#define AUTO_REALM      12

// Global values to set.  (These will be processed by non-eap specific
// handlers.)
#define CONN_TYPE       13
#define DEST_MAC        14

#define NET_LIST        15
#define STARTUP_CMD     16
#define FIRST_AUTH_CMD  17
#define REAUTH_CMD      18
#define AUTH_PERIOD     19
#define HELD_PERIOD     20
#define MAX_STARTS      21
#define ALLOW_INTS      22
#define DENY_INTS       23


struct ipc_set_config
{
  char phase1type;     // EAP type for phase 1.
  char phase2type;     // EAP type for phase 2 (0 if there isn't one, 1-4
                       // for TTLS phase 2 types.)
  char setting;        // 0 to 255, tags the value to set.
  char length;         // Length of the string to follow.

  // The following (length) bytes are a string value to be set.  The values
  // will always be strings, so the command inteperator should know which ones
  // need to be converted to other values.
};


void ipc_callout_auth_state(struct interface_data *, int *, char *, int,
			    char *, int *);

void ipc_callout_process_conf(struct interface_data *, int *, char *, int,
			      char *, int *);

void ipc_callout_get_ints(struct interface_data *, struct interface_data *, 
			  int *, char *, int, char *, int *);

void ipc_callout_send_error(struct interface_data *, int *, char *, int, 
			    char *);

void ipc_callout_getset_profile(struct interface_data *, int *, char *, int,
				char *, int *);

void ipc_callout_set_password(struct interface_data *, int *, char *, int, 
			      char *, int *);

void ipc_callout_request_password(int, int *, char *, int, char *, char *);
#endif
