/* --------------------------------------------------------------------------
 * ``aRts Sound Server'' specific audio driver interface.
 * --------------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef XSID_ARTSC_DEBUG
#include <iostream>
#include <iomanip>
using namespace std;
#endif

#include <artsc.h>

#include "AudioDriverARTSC.h"

const char* AudioDriverARTSC::STREAMNAME = "XSIDPLAY audio stream";

AudioDriverARTSC::AudioDriverARTSC()
{
#ifdef XSID_ARTSC_DEBUG
    cout << "AudioDriverARTSC::AudioDriverARTSC" << endl;
#endif
	outOfOrder();
	swapEndian = false;
}

AudioDriverARTSC::~AudioDriverARTSC()
{
#ifdef XSID_ARTSC_DEBUG
    cout << "AudioDriverARTSC::~AudioDriverARTSC" << endl;
#endif
	reset();
	unload();
}

void AudioDriverARTSC::outOfOrder()
{
#ifdef XSID_ARTSC_DEBUG
    cout << "AudioDriverARTSC::outOfOrder" << endl;
#endif
	// Reset everything.
	errorString = "None";
	haveStream = false;
}

bool AudioDriverARTSC::isThere()
{
#ifdef XSID_ARTSC_DEBUG
    cout << "AudioDriverARTSC::isThere" << endl;
#endif
    int ret = arts_init();
    if ( ret==0 )
        arts_free();
    return ( ret==0 );
}

bool AudioDriverARTSC::reset()
{
#ifdef XSID_ARTSC_DEBUG
    cout << "AudioDriverARTSC::reset" << endl;
#endif
    return false;  // not possible
}

bool AudioDriverARTSC::open( const AudioConfig& inConfig )
{
#ifdef XSID_ARTSC_DEBUG
    cout << "AudioDriverARTSC::open" << endl;
#endif
    
    static AudioConfig lastConfig;
	
    if ( haveStream && inConfig==config && inConfig==lastConfig )
        return true;
    else
        unload();
    
    // Copy input parameters. May later be replaced with driver defaults.
	config = inConfig;

    // Init C API here.
    int ret = arts_init();
#ifdef XSID_ARTSC_DEBUG
    cout << "arts_init() done." << endl;
#endif
    if ( ret!=0 )
    {
        errorString = arts_error_text( ret );
#ifdef XSID_ARTSC_DEBUG
        std::cerr << errorString << endl;
#endif
        return false;
    }
    arts_free();
#ifdef XSID_ARTSC_DEBUG
    cout << "arts_free() done." << endl;
#endif
    ret = arts_init();
#ifdef XSID_ARTSC_DEBUG
    cout << "arts_init() done." << endl;
#endif
    if ( ret!=0 )
    {
        errorString = arts_error_text( ret );
#ifdef XSID_ARTSC_DEBUG
        std::cerr << errorString << endl;
#endif
        return false;
    }

#ifdef XSID_ARTSC_DEBUG
    cout << config.frequency << endl;
    cout << config.precision << endl;
    cout << config.channels << endl;
#endif
    stream = arts_play_stream( config.frequency, config.precision, config.channels,
                               STREAMNAME );
    haveStream = true;
	if (config.precision == AudioConfig::BITS_16)
        config.encoding = AudioConfig::SIGNED_PCM;
    else
        config.encoding = AudioConfig::UNSIGNED_PCM;
    
	// Assume CPU and soundcard have same endianess.
	swapEndian = false;
/*
    int blocking = arts_stream_set( stream, ARTS_P_BLOCKING, 1 );
    if ( blocking!=1 )
    {
        errorString = arts_error_text( blocking );
        std::cerr << errorString << endl;
        return false;
    }
*/	errorString = "OK";
#ifdef XSID_ARTSC_DEBUG
    cout << "return" << endl;
#endif
	return true;
}

void AudioDriverARTSC::unload()
{
#ifdef XSID_ARTSC_DEBUG
    cout << "AudioDriverARTSC::unload" << endl;
#endif
	if ( !haveStream )
        return;
#ifdef XSID_ARTSC_DEBUG
    cout << " - arts_close_stream" << endl;
    cout << " - arts_free" << endl;
#endif
    arts_close_stream( stream );
    arts_free();
    outOfOrder();
}

void AudioDriverARTSC::close()
{
#ifdef XSID_ARTSC_DEBUG
    cout << "AudioDriverARTSC::close" << endl;
#endif
}

void AudioDriverARTSC::play(void* buffer, unsigned long int bufferSize)
{
#ifdef XSID_ARTSC_DEBUG
    cout << "AudioDriverARTSC::play" << endl;
#endif
	if ( !haveStream )
        return;
    if (swapEndian)
    {
        unsigned char* pBuffer = (unsigned char*)buffer;
        for (unsigned long int n=0; n<bufferSize; n+=2)
        {
            unsigned char tmp = pBuffer[n+0];
            pBuffer[n+0] = pBuffer[n+1];
            pBuffer[n+1] = tmp;
        }
    }
    int ret = arts_write ( stream, buffer, bufferSize );
}
