/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef TSID2DIALOG_H
#define TSID2DIALOG_H

#include <qlist.h>
#include <qstring.h>

#ifdef XSID_HAVE_TSID2
#include <tsid2/tblist.h>
#endif

#include "TSID2DialogData.h"
#include "TSID2Config.h"

class TSID2Dialog : public TSID2DialogData
{
   Q_OBJECT

public:

    TSID2Dialog(QWidget* parent=0, const char* name=0);
    ~TSID2Dialog();

    void setConfig(const TSID2Config&);
    const TSID2Config& getConfig() const;

#ifdef XSID_HAVE_TSID2
    void update(TBLIST* list);
#endif
    
 protected slots:

    void okButtonClicked();
    void cancelButtonClicked();
    void browseButtonClicked();
    void rebuildButtonClicked();
    void CheckBoxPath_stateChanged( int );   

 protected:

    TSID2Config config;
    TSID2Config backupConfig;

    void setButtons();

#ifdef XSID_HAVE_TSID2 
    TBLIST* tblist;
#endif
};

#endif  /* TSID2DIALOG_H */
