/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef HISTORYFILE_H
#define HISTORYFILE_H

#include <qstring.h>

#include "HistoryItem.h"
#include "HistoryDialog.h"
#include "tools/TextFile.h"

class HistoryFile : private TextFile
{
 public:

    HistoryFile(const char*);

    bool load(class HistoryDialog& dialog);
    bool save(class HistoryDialog& dialog);

 private:

    QString fileName;
    int version;
    
    static const char key_Version[];
    static const char key_MaxItems[];
};

#endif  /* HISTORYFILE_H */
