.\" $XFree86$
.\" $XdotOrg$
.\" shorthand for double quote that works everywhere.
.ds q \N'34'
#ifdef __xservername__
#define __myservername__ __xservername__
#else
#define __myservername__ XFree86
#endif
#ifdef __xconfigfile__
#define __myxconfigfile__ __xconfigfile__
#else
#define __myxconfigfile__ XF86Config
#endif
.TH SISUSB __drivermansuffix__ __vendorversion__
.SH NAME
sisusb \- SiS USB video driver
.SH SYNOPSIS
.nf
.B "Section \*qDevice\*q"
.BI "  Identifier \*q"  devname \*q
.B  "  Driver \*qsisusb\*q"
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B sisusb
is an __myservername__ driver for SiS (Silicon Integrated Systems) video chips that
are connected via a Net2280-based USB dongle. The driver is not accelerated, but
provides support for colordepths of 8, 16 and 24 bpp as well as Render and other
extensions.
.SH SUPPORTED HARDWARE
The
.B sisusb
driver supports USB video cards based on the following chipsets:
.PP
.B SiS315E/PRO
.PP
The SiS315E/PRO features two CRT controllers. However, in its USB version, only
the first output, referred to as "CRT1", is being used.
.SH CONFIGURATION DETAILS
Please refer to __myxconfigfile__(__filemansuffix__) for general configuration
details and to sis(__drivermansuffix__) for more information. This manpage only
covers a subset of the supported options.
.PP
Detailed information on all supported options can be obtained at
http://www.winischhofer.at/linuxsisusbvga.shtml
.PP
Please note that this driver requires a Linux kernel driver as well which is
included in Linux 2.6.12 and later, as well as available at the aforementioned
website.
.PP
The following driver
.B Options
are supported:
.TP
.BI "Option \*qHWCursor\*q \*q" boolean \*q
Enable or disable the hardware cursor. It is not recommended to disable
the hardware cursor as this will increase the amount of data transferred
over the USB. Default: HWCursor is on.
.TP
.BI "Option \*qSWCursor\*q \*q" boolean \*q
The opposite of HWCursor. This enables or disables the software
cursor. This sort of cursor is slower because the pointer must
be painted into the graphics display. This increases the amount of data
transferred over the USB significantly. Default: SWCursor is off.
.TP
.BI "Option \*qCRT1Gamma\*q \*q" boolean \*q
Enable or disable gamma correction.
Default: Gamma correction is on.
.TP
.BI "Option \*qDisconnectTimeout\*q \*q" integer \*q
This option determines how the driver will react to a disconnection of the
USB device. If the integer supplied is -1, the driver will abort the X server
immediately upon disconnection. If the value given is 0, the driver will
probe for a re-connection every 2 seconds and in case the device is detected,
re-establish the display. If the value is greater than 0, the driver will do
this re-probing within the given number of seconds and abort the server if
it does not detect the device within this time-out. Default: 0 (probe forever
for device reconnection).
.SH "KNOWN BUGS"
none.
.SH "SEE ALSO"
#ifdef __xservername__
__xservername__(__appmansuffix__), __xconfigfile__(__filemansuffix__), xorgconfig(__appmansuffix__), Xserver(__appmansuffix__), X(__miscmansuffix__), sis(__drivermansuffix__)
#else
XFree86(1), XF86Config(__filemansuffix__), xf86config(1), Xserver(1), X(__miscmansuffix__), sis(__drivermansuffix__)
#endif
.PP
.B "http://www.winischhofer.at/linuxsisvga.shtml"
for more information and updates
.SH AUTHORS
Author: Thomas Winischhofer
