// file      : xsde/cxx/parser/validating/parser.ixx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

namespace xsde
{
  namespace cxx
  {
    namespace parser
    {
      namespace validating
      {
        // all_stack
        //

        inline all_stack::
        all_stack (size_t n, unsigned char* first)
            : stack_ (n, first)
        {
        }

        inline stack::error all_stack::
        push ()
        {
          if (stack::error e = stack_.push ())
            return e;

          unsigned char* p = static_cast<unsigned char*> (stack_.top ());

          for (size_t i = 0; i < stack_.element_size (); ++i)
            p[i] = 0;

          return stack::error_none;
        }

        inline void all_stack::
        pop ()
        {
          stack_.pop ();
        }

        inline unsigned char* all_stack::
        top ()
        {
          return static_cast<unsigned char*> (stack_.top ());
        }
      }
    }
  }
}

