// file      : xsde/cxx/parser/non-validating/xml-schema-pskel.hxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#ifndef XSDE_CXX_PARSER_NON_VALIDATING_XML_SCHEMA_PSKEL_HXX
#define XSDE_CXX_PARSER_NON_VALIDATING_XML_SCHEMA_PSKEL_HXX

#include <xsde/cxx/config.hxx>

#ifdef XSDE_STL
#  include <string>
#endif

#include <xsde/cxx/parser/xml-schema.hxx>

#include <xsde/cxx/parser/non-validating/parser.hxx>

namespace xsde
{
  namespace cxx
  {
    namespace parser
    {
      namespace non_validating
      {
        // anyType and anySimpleType. All events are routed to the
        // _any_* callbacks.
        //
        struct any_type_pskel: virtual complex_content
        {
          virtual bool
          _start_element_impl (const ro_string&, const ro_string&);

          virtual bool
          _end_element_impl (const ro_string&, const ro_string&);

          virtual bool
          _attribute_impl (const ro_string&,
                           const ro_string&,
                           const ro_string&);

          virtual bool
          _characters_impl (const ro_string&);

          virtual void
          post_any_type () = 0;
        };

        struct any_simple_type_pskel: virtual simple_content
        {
          virtual bool
          _characters_impl (const ro_string&);

          virtual void
          post_any_simple_type () = 0;
        };

        // Boolean.
        //
        struct boolean_pskel: virtual simple_content
        {
          virtual bool
          post_boolean () = 0;
        };


        // 8-bit
        //

        struct byte_pskel: virtual simple_content
        {
          virtual signed char
          post_byte () = 0;
        };

        struct unsigned_byte_pskel: virtual simple_content
        {
          virtual unsigned char
          post_unsigned_byte () = 0;
        };


        // 16-bit
        //

        struct short_pskel: virtual simple_content
        {
          virtual short
          post_short () = 0;
        };

        struct unsigned_short_pskel: virtual simple_content
        {
          virtual unsigned short
          post_unsigned_short () = 0;
        };


        // 32-bit
        //

        struct int_pskel: virtual simple_content
        {
          virtual int
          post_int () = 0;
        };

        struct unsigned_int_pskel: virtual simple_content
        {
          virtual unsigned int
          post_unsigned_int () = 0;
        };


        // 64-bit
        //
#ifdef XSDE_LONGLONG
        struct long_pskel: virtual simple_content
        {
          virtual long long
          post_long () = 0;
        };

        struct unsigned_long_pskel: virtual simple_content
        {
          virtual unsigned long long
          post_unsigned_long () = 0;
        };
#else
        struct long_pskel: virtual simple_content
        {
          virtual long
          post_long () = 0;
        };

        struct unsigned_long_pskel: virtual simple_content
        {
          virtual unsigned long
          post_unsigned_long () = 0;
        };
#endif


        // Arbitrary-length integers.
        //

        struct integer_pskel: virtual simple_content
        {
          virtual long
          post_integer () = 0;
        };

        struct negative_integer_pskel: virtual simple_content
        {
          virtual long
          post_negative_integer () = 0;
        };

        struct non_positive_integer_pskel: virtual simple_content
        {
          virtual long
          post_non_positive_integer () = 0;
        };

        struct positive_integer_pskel: virtual simple_content
        {
          virtual unsigned long
          post_positive_integer () = 0;
        };

        struct non_negative_integer_pskel: virtual simple_content
        {
          virtual unsigned long
          post_non_negative_integer () = 0;
        };


        // Floats.
        //

        struct float_pskel: virtual simple_content
        {
          virtual float
          post_float () = 0;
        };

        struct double_pskel: virtual simple_content
        {
          virtual double
          post_double () = 0;
        };

        struct decimal_pskel: virtual simple_content
        {
          virtual double
          post_decimal () = 0;
        };


        // String-based types.
        //
#ifdef XSDE_STL

        struct string_pskel: virtual simple_content
        {
          virtual std::string
          post_string () = 0;
        };

        struct normalized_string_pskel: virtual simple_content
        {
          virtual std::string
          post_normalized_string () = 0;
        };

        struct token_pskel: virtual simple_content
        {
          virtual std::string
          post_token () = 0;
        };

        struct name_pskel: virtual simple_content
        {
          virtual std::string
          post_name () = 0;
        };

        struct nmtoken_pskel: virtual simple_content
        {
          virtual std::string
          post_nmtoken () = 0;
        };

        struct nmtokens_pskel: list_base
        {
          virtual string_sequence
          post_nmtokens () = 0;
        };

        struct ncname_pskel: virtual simple_content
        {
          virtual std::string
          post_ncname () = 0;
        };

        struct id_pskel: virtual simple_content
        {
          virtual std::string
          post_id () = 0;
        };

        struct idref_pskel: virtual simple_content
        {
          virtual std::string
          post_idref () = 0;
        };

        struct idrefs_pskel: list_base
        {
          virtual string_sequence
          post_idrefs () = 0;
        };

        struct language_pskel: virtual simple_content
        {
          virtual std::string
          post_language () = 0;
        };

        struct uri_pskel: virtual simple_content
        {
          virtual std::string
          post_uri () = 0;
        };

        struct qname_pskel: virtual simple_content
        {
          virtual qname
          post_qname () = 0;
        };

#else // XSDE_STL

        // Note that in this case you are getting a C string that you
        // have to delete with delete[].
        //
        struct string_pskel: virtual simple_content
        {
          virtual char*
          post_string () = 0;
        };

        struct normalized_string_pskel: virtual simple_content
        {
          virtual char*
          post_normalized_string () = 0;
        };

        struct token_pskel: virtual simple_content
        {
          virtual char*
          post_token () = 0;
        };

        struct name_pskel: virtual simple_content
        {
          virtual char*
          post_name () = 0;
        };

        struct nmtoken_pskel: virtual simple_content
        {
          virtual char*
          post_nmtoken () = 0;
        };

        struct nmtokens_pskel: list_base
        {
          virtual string_sequence*
          post_nmtokens () = 0;
        };

        struct ncname_pskel: virtual simple_content
        {
          virtual char*
          post_ncname () = 0;
        };

        struct id_pskel: virtual simple_content
        {
          virtual char*
          post_id () = 0;
        };

        struct idref_pskel: virtual simple_content
        {
          virtual char*
          post_idref () = 0;
        };

        struct idrefs_pskel: list_base
        {
          virtual string_sequence*
          post_idrefs () = 0;
        };

        struct language_pskel: virtual simple_content
        {
          virtual char*
          post_language () = 0;
        };

        struct uri_pskel: virtual simple_content
        {
          virtual char*
          post_uri () = 0;
        };

        struct qname_pskel: virtual simple_content
        {
          virtual qname*
          post_qname () = 0;
        };
#endif // XSDE_STL

        // base64Binary
        //
        struct base64_binary_pskel: virtual simple_content
        {
          virtual buffer*
          post_base64_binary () = 0;
        };

        // hexBinary
        //
        struct hex_binary_pskel: virtual simple_content
        {
          virtual buffer*
          post_hex_binary () = 0;
        };

        // Time and date types.
        //
        struct gday_pskel: virtual simple_content
        {
          virtual gday
          post_gday () = 0;
        };

        struct gmonth_pskel: virtual simple_content
        {
          virtual gmonth
          post_gmonth () = 0;
        };

        struct gyear_pskel: virtual simple_content
        {
          virtual gyear
          post_gyear () = 0;
        };

        struct gmonth_day_pskel: virtual simple_content
        {
          virtual gmonth_day
          post_gmonth_day () = 0;
        };

        struct gyear_month_pskel: virtual simple_content
        {
          virtual gyear_month
          post_gyear_month () = 0;
        };

        struct date_pskel: virtual simple_content
        {
          virtual date
          post_date () = 0;
        };

        struct time_pskel: virtual simple_content
        {
          virtual time
          post_time () = 0;
        };

        struct date_time_pskel: virtual simple_content
        {
          virtual date_time
          post_date_time () = 0;
        };

        struct duration_pskel: virtual simple_content
        {
          virtual duration
          post_duration () = 0;
        };
      }
    }
  }
}

#endif  // XSDE_CXX_PARSER_NON_VALIDATING_XML_SCHEMA_PSKEL_HXX
