// file      : xsde/cxx/parser/elements.ixx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

namespace xsde
{
  namespace cxx
  {
    namespace parser
    {
#ifndef XSDE_EXCEPTIONS
      inline error parser_base::
      _error () const
      {
        switch (error_type_)
        {
        case error_sys:
          {
            return error (error_code_.sys);
          }
        case error_app:
          {
            return error (error_code_.app, 0, 0);
          }
        default:
          {
            return error ();
          }
        }
      }

      inline void parser_base::
      _app_error (int e)
      {
        error_type_ = error_app;
        error_code_.app = e;
      }

      inline int parser_base::
      _app_error () const
      {
        return error_code_.app;
      }

      inline parser_base::sys_error_t parser_base::
      _sys_error () const
      {
        return error_code_.sys;
      }

      inline void parser_base::
      _sys_error (sys_error_t e)
      {
        error_type_ = error_sys;
        error_code_.sys = e;
      }
#endif // XSDE_EXCEPTIONS

#ifdef XSDE_VALIDATION_PARSER
      inline parser_base::schema_error_t parser_base::
      _schema_error () const
      {
        return error_code_.schema;
      }

      inline void parser_base::
      _schema_error (schema_error_t e)
      {
        error_type_ = error_schema;
        error_code_.schema = e;
      }
#endif

#if defined(XSDE_VALIDATION_PARSER) || !defined(XSDE_EXCEPTIONS)
      inline parser_base::
      parser_base ()
          : error_type_ (error_none)
      {
      }

      inline parser_base::error_type_t parser_base::
      _error_type () const
      {
        return error_type_;
      }

      inline bool parser_base::
      _error_p () const
      {
        return error_type_ != error_none;
      }

      inline void parser_base::
      _copy_error (const parser_base* src)
      {
        error_type_ = src->error_type_;
        error_code_ = src->error_code_;
      }
#endif
    }
  }
}
