/* $Header: /fridge/cvs/xscorch/snet/tcpnet/tcpnet.h,v 1.6 2003/02/25 04:11:32 jacob Exp $
 *
 * tcpnet.h
 * File revision 3.xscorch
 * Externally available declarations for tcp net.
 * (c) 2001-2003 Jacob Lundberg, jacob@chaos2.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


/*
 * 2001.07.14	initial revision
 * 2001.07.24	changed pointless void**
 * 2001.07.25	added tn_error_string
 * 		added GPL notice
 * 2003.02.24	signedness junk for C99
 * 2003.02.24	branch for xscorch
 */


#ifndef  __TCPNET_H__
#define  __TCPNET_H__


/*
 * Acquire local definitions.
 * When using tcp net in an integrated package, replace this
 * with a header generated by configure so these values are
 * correct for the local system (and thus portable).
 */
/* #include "tn_local.h" */
#define  MSG_FLAGS     0
#include <xscorch.h>


/* Forward declaration for struct timeval. */
struct timeval;


/* Connection state flags. */
#define  TN_STATE_DEFAULT       0x00000000      /* Default state. */
#define  TN_STATE_CONNECTED     0x00000001      /* Connection has been made. */

#define  TN_STATE_ERROR         0xff000000      /* Connection error flags. */
#define  TN_STATE_ERR_CONNLOST  0x01000000      /* Connection has been lost. */
#define  TN_STATE_ERR_MALLOC    0x02000000      /* Malloc failure! */
#define  TN_STATE_ERR_MISALIGN  0x04000000      /* Packet misalignment. */
#define  TN_STATE_ERR_MISORDER  0x08000000      /* Packet out of order. */
#define  TN_STATE_ERR_SELECT    0x10000000      /* Something wrong in select. */
#define  TN_STATE_ERR_UNKNOWN   0x80000000      /* Something undexpected happened. */


/* Connection state information. */
#define  TN_CONNECTION_IS_UP(tnc)  (((tnc)->state & TN_STATE_CONNECTED) && \
                                   !((tnc)->state & TN_STATE_ERR_CONNLOST) && \
                                    ((tnc)->socket >= 0))
#define  TN_STATE_IS_ERROR(tnc)    ((tnc)->state & TN_STATE_ERROR)


/* The definition of a packet. */
#define  TN_HEADER_SIZE         (3 * sizeof(dword))
typedef struct _tn_packet {
   dword bop;                   /* Packet divider / marker. */
   dword size;                  /* The size of the data payload. */
   dword id;                    /* The packet's reference ID. */
   byte *payload;               /* The packet's data payload. */
} tn_packet;


/* Lists of packets. */
typedef struct _tn_packet_list {
   struct _tn_packet_list *next;/* The next packet in the list. */
   tn_packet *packet;           /* The packet in question. */
   size_t size;                 /* The amount of data written to the packet. */
   bool complete;               /* Is the packet completed? */
} tn_packet_list;


/* The basic IO struct for tcp net. */
typedef struct _tn_connection {
   int state;                   /* The connection status. */
   int socket;                  /* The socket we're connecting on. */
   dword inc_id;                /* The last incoming packet ID queued. */
   dword out_id;                /* The last outgoing packet ID queued. */
   tn_packet_list *incoming;    /* The incoming packet chain. */
   tn_packet_list *outgoing;    /* The outgoing packet chain. */
} tn_connection;


/* Exported control functions (tn_setup.c). */
bool tn_instantiate(tn_connection **tnc, int socket);
bool tn_terminate(tn_connection **tnc);
const char *tn_error_string(tn_connection *tnc);


/* Exported read functions (tn_read.c). */
bool tn_scan_read(tn_connection *tnc, struct timeval *timeout);
bool tn_read(tn_connection *tnc, byte **payload, size_t *size);


/* Exported write functions (tn_write.c). */
bool tn_write_flush(tn_connection *tnc);
bool tn_write(tn_connection *tnc, const byte *payload, size_t size);


#endif /* ndef __TCPNET_H__ */
