/* $Header: /fridge/cvs/xscorch/sgtk/swidgets/sbar.h,v 1.2 2001/04/07 19:46:50 justins Exp $ */
/*
   
   xscorch - sbar.h           Copyright(c) 2001,2000 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/
    
   Draws a colored bar
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef __sbar_h_included
#define __sbar_h_included


/* Include files */
#include <sdrawbuf.h>


/* ScDrawbuf casts */
#define  SC_BAR(obj)             GTK_CHECK_CAST((obj), sc_bar_get_type(), ScBar)
#define  SC_BAR_CLASS(klass)     GTK_CHECK_CLASS_CAST((klass), sc_bar_get_type(), ScBarClass)
#define  IS_SC_BAR(obj)          GTK_CHECK_TYPE((obj), sc_bar_get_type())


/* ScBar structure */
typedef struct _ScBar {
   ScDrawbuf drawbuf;               /* Parent is a draw buffer */
   long value;                      /* Current bar value */
   long max;                        /* Largest allowed value */
} ScBar;


/* ScBarClass structure */
typedef struct _ScBarClass {
   ScDrawbufClass parent_class;     /* Drawing area class data */
} ScBarClass;


/* ScBar initialisation and basic info */
GtkType sc_bar_get_type(void);
GtkWidget *sc_bar_new(long maxvalue);


/* Hooks to get useful information from a drawbuf */
#define sc_bar_get_value(bar)       ((bar)->value)
#define sc_bar_get_max(bar)         ((bar)->max)


/* Modify the bar */
void sc_bar_set_value(ScBar *bar, long value);
void sc_bar_set_foreground(ScBar *bar, GdkColor *color);


#endif /* __sbar_h_included */
