/*
 * @(#)SkewbU.c
 *
 * Copyright 1994 - 2008  David A. Bagley, bagleyd@tux.org
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Undo algorithm */

#include "SkewbP.h"

static SkewbLoc startLoc[MAX_FACES][MAX_CUBES];

static void
newStack(SkewbStack *s)
{
	if (s->lastMove != NULL || s->firstMove != NULL)
		return;
	if (!(s->lastMove = (MoveStack *) malloc(sizeof (MoveStack)))) {
		DISPLAY_ERROR("Not enough memory, exiting.");
	}
	if (!(s->firstMove = (MoveStack *) malloc(sizeof (MoveStack)))) {
		DISPLAY_ERROR("Not enough memory, exiting.");
	}
	s->firstMove->previous = s->lastMove->next = NULL;
	s->firstMove->next = s->lastMove;
	s->lastMove->previous = s->firstMove;
	s->count = 0;
}

static void
pushStack(SkewbStack *s, moveRecord **move)
{
	if (!(s->currMove = (MoveStack *) malloc(sizeof (MoveStack)))) {
		DISPLAY_ERROR("Not enough memory, exiting.");
	}
	s->lastMove->previous->next = s->currMove;
	s->currMove->previous = s->lastMove->previous;
	s->currMove->next = s->lastMove;
	s->lastMove->previous = s->currMove;
	*move = &(s->currMove->move);
	s->count++;
}

static void
popStack(SkewbStack *s)
{
	s->currMove = s->lastMove->previous;
	s->lastMove->previous->previous->next = s->lastMove;
	s->lastMove->previous = s->lastMove->previous->previous;
	free(s->currMove);
	s->count--;
}

static moveRecord *
topStack(SkewbStack *s)
{
	return &(s->lastMove->previous->move);
}

static int
emptyStack(SkewbStack *s)
{
	return (s->lastMove->previous == s->firstMove);
}

static void
flushStack(SkewbStack *s)
{
	while (s->lastMove->previous != s->firstMove) {
		s->currMove = s->lastMove->previous;
		s->lastMove->previous->previous->next = s->lastMove;
		s->lastMove->previous = s->lastMove->previous->previous;
		free(s->currMove);
	}
	s->count = 0;
}

static void
deleteStack(SkewbStack *s)
{
	flushStack(s);
	if (s->firstMove) {
		free(s->firstMove);
		s->firstMove = NULL;
	}
	if (s->lastMove) {
		free(s->lastMove);
		s->lastMove = NULL;
	}
}

/**********************************/

void
newMoves(SkewbStack *s)
{
	newStack(s);
}

void
deleteMoves(SkewbStack *s)
{
	deleteStack(s);
}

static void
writeMove(moveRecord *move,
		int face, int position, int direction, int control)
{
#if 0
	move->face = face;
	move->position = position;
	move->direction = direction;
	move->control = control;
#endif
	move->packed = ((control & 0xF) << 12) + ((direction & 0xF) << 8) +
		((position & 0xF) << 4) + (face & 0xF);
}

static void
readMove(moveRecord *move,
		int *face, int *position, int *direction, int *control)
{
#if 0
	*face = move->face;
	*position = move->position;
	*direction = move->direction;
	*control = move->control;
#endif
	*face = (int) (move->packed & 0xF);
	*position = (int) ((move->packed >> 4) & 0xF);
	*direction = (int) ((move->packed >> 8) & 0xF);
	*control = (int) ((move->packed >> 12) & 0xF);
}

void
setMove(SkewbStack *s, int face, int position, int direction, int control)
{
	moveRecord *move;

	pushStack(s, &move);
	writeMove(move, face, position, direction, control);
}

void
getMove(SkewbStack *s, int *face, int *position, int *direction, int *control)
{
	readMove(topStack(s), face, position, direction, control);
	popStack(s);
}

int
madeMoves(SkewbStack *s)
{
	return !emptyStack(s);
}

void
flushMoves(SkewbWidget w, SkewbStack *s, Boolean undo)
{
	int face, position;

	flushStack(s);
	if (undo) {
		for (face = 0; face < MAX_FACES; face++)
			for (position = 0; position < MAX_CUBES; position++) {
				startLoc[face][position].face =
					w->skewb.cubeLoc[face][position].face;
				startLoc[face][position].rotation =
					w->skewb.cubeLoc[face][position].rotation;
			}
	}
}

int
numMoves(SkewbStack *s)
{
	return s->count;
}

void
scanMoves(FILE *fp, SkewbWidget w, int moves)
{
	int face, position, direction, control, k, c;

	for (k = 0; k < moves; k++) {
		while ((c = getc(fp)) != EOF && c != SYMBOL);
		(void) fscanf(fp, "%d %d %d %d",
			&face, &position, &direction, &control);
		movePuzzle(w, face, position, direction, control);
	}
}

void
printMoves(FILE *fp, SkewbStack *s)
{
	int face, position, direction, control, counter = 0;

	s->currMove = s->firstMove->next;
	(void) fprintf(fp, "moves\tface\tpos\tdir\tcon\n");
	while (s->currMove != s->lastMove) {
		readMove(&(s->currMove->move),
			&face, &position, &direction, &control);
		(void) fprintf(fp, "%d%c\t%d\t%d\t%d\t%d\n",
			++counter, SYMBOL, face, position, direction, control);
		s->currMove = s->currMove->next;
	}
}

void
scanStartPosition(FILE *fp, SkewbWidget w)
{
	int face, position, num, c;

	while ((c = getc(fp)) != EOF && c != SYMBOL);
	for (face = 0; face < MAX_FACES; face++)
		for (position = 0; position < MAX_CUBES; position++) {
			(void) fscanf(fp, "%d ", &num);
			startLoc[face][position].face = num;
			if (w->skewb.orient) {
				(void) fscanf(fp, "%d ", &num);
				startLoc[face][position].rotation = num;
			}
		}
}

void
printStartPosition(FILE *fp, SkewbWidget w)
{
	int face, position;

	(void) fprintf(fp, "\nstartingPosition%c\n", SYMBOL);
	for (face = 0; face < MAX_FACES; face++) {
		for (position = 0; position < MAX_CUBES; position++) {
			(void) fprintf(fp, "%d ", startLoc[face][position].face);
			if (w->skewb.orient)
				(void) fprintf(fp, "%d  ",
					startLoc[face][position].rotation);
		}
		(void) fprintf(fp, "\n");
	}
}

void
setStartPosition(SkewbWidget w)
{
	int face, position;

	for (face = 0; face < MAX_FACES; face++)
		for (position = 0; position < MAX_CUBES; position++) {
			w->skewb.cubeLoc[face][position].face =
				startLoc[face][position].face;
			if (w->skewb.orient)
				w->skewb.cubeLoc[face][position].rotation =
					startLoc[face][position].rotation;
		}
	drawAllPieces(w);
}
