/*-
# X-BASED SKEWB
#
#  SkewbGLP.h
#
###
#
#  Copyright (c) 2003 - 2006	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for SkewbGL */

#ifndef _SkewbGLP_h
#define _SkewbGLP_h

#include "SkewbGL.h"
#include <GL/gl.h>
#include <GL/glx.h>

#ifndef WINVER
/* This gets around C's inability to do inheritance */
typedef struct _SkewbGLClassPart {
	int         ignore;
} SkewbGLClassPart;

typedef struct _SkewbGLClassRec {
	CoreClassPart coreClass;
	SkewbClassPart skewbClass;
	SkewbGLClassPart skewbGLClass;
} SkewbGLClassRec;

extern SkewbGLClassRec skewbGLClassRec;
#endif

#define CCW 7
#define TOP 8
#define RIGHT 9
#define BOTTOM 10
#define LEFT 11
#define MAXROTATE 3
#define MINOR 0
#define MAJOR 1

#define TOP_FACE 0
#define LEFT_FACE 1
#define FRONT_FACE 2
#define RIGHT_FACE 3
#define BOTTOM_FACE 4
#define BACK_FACE 5
#define NO_FACE (-1)
#define TEST_FACE (MAXFACES)
#define ERROR_FACE (MAXFACES+1)
#define NO_ROTATION (2*MAXORIENT)

#define CUBELEN 0.5
#define CUBEROUND (CUBELEN-0.05)
#define STICKERLONG (CUBEROUND-0.05)
#define STICKERSHORT (STICKERLONG-0.05)
#define STICKERDEPTH (CUBELEN+0.01)
#define FACELEN (2.0*CUBELEN)
#define FACEROUND (2.0*CUBELEN-0.03)
#define FSTICKERLONG (FACEROUND-0.05)
#define FSTICKERSHORT (FSTICKERLONG-0.05)
#define FSTICKERDEPTH (FACELEN+0.01)
#define CUT 0.04
#define CUTDEPTH (STICKERDEPTH+0.001)
#define FCUTDEPTH (FSTICKERDEPTH+0.001)

#define SCALE (1.1)

typedef struct _SkewbMove {
        int         face, direction;
        int         position;
} SkewbMove;

typedef struct _SkewbSlice {
        int         face, rotation;
        int         depth;
} SkewbSlice;

typedef struct _SkewbGLPart {
	double angleStep;
	double vx, vy;
	double rotateStep;

	Position    faceDiagonal;
	Position    cubeDiagonalx, cubeDiagonaly, cubeDiagonalz;
	/*Point       cubeSizex, cubeSizey, cubeSizez;*/
	Point       faceSize, viewSize;
	Point       viewMiddle;
	SkewbMove   movement;
	int step;
} SkewbGLPart;

typedef struct _SkewbGLRec {
	CorePart    core;
	SkewbPart   skewb;
	SkewbGLPart skewbGL;
} SkewbGLRec;

extern Boolean SelectPiecesGL(SkewbGLWidget w, int x, int y,
	int *face, int *position);
extern void DrawFrameGL(SkewbGLWidget w, Boolean focus);
extern void DrawAllPiecesGL(SkewbGLWidget w);

#endif /* _SkewbGLP_h */
