/*

    xpuyopuyo - pmenu-gtk.c            Copyright(c) 1999,2000 Justin David Smith
    justins(at)chaos2.org              http://chaos2.org/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <xpuyopuyo.h>
#include <pconfigm.h>
#include <pmenu-gtk.h>
#include <pdialog-gtk.h>
#include <poptions-gtk.h>
#include <ptheme-gtk.h>
#include <phigh-gtk.h>
#include <pkey-gtk.h>
#include <pai-gtk.h>
#include <pgraph-gtk.h>
#include <pnet-gtk.h>
#include <pfield.h>
#include <ppiece.h>
#include <pmanip.h>
#include <pnet.h>
#include <psnprintf.h>


/***   Menu control  ***/


static inline void menu_enable(pwindow_gtk *w, int menuindex, gboolean enable) {
/* menu_enable */
   
   gtk_widget_set_sensitive(P_MENUW(w, menuindex), enable);
   return;

}


static inline void menu_check(pwindow_gtk *w, int menuindex, gboolean check) {
/* menu_check */
   
   gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(P_MENUW(w, menuindex)), check);
   return;

}


void p_window_update_menus(pwindow_gtk *w) {
/* menu_options_update */

   #define enable_options       (P_GAME_IDLE(w->c))
   #define enable_user_options  (enable_options && !P_TOURNAMENT(w->c))
   #define enable_end_game      (!P_GAME_IDLE(w->c) && !P_TOURNAMENT(w->c))
   #if !USE_NETWORK
   #define enable_net_options   0
   #else /* No network */
   #define enable_net_options   (P_GAME_IDLE(w->c))
   #endif /* Network support? */

   menu_enable(w, P_MENU_GAME_START,            !w->c->waiting && enable_options);
   menu_enable(w, P_MENU_GAME_RESTART,          !w->c->waiting && enable_end_game);
   menu_enable(w, P_MENU_GAME_END,              !w->c->waiting && enable_end_game);
   menu_enable(w, P_MENU_GAME_PAUSE,            !w->c->waiting && !enable_options);

   menu_enable(w, P_MENU_OPTIONS_SET_KEYS,      !w->c->waiting && enable_user_options);
   menu_enable(w, P_MENU_OPTIONS_SET_OPTIONS,   !w->c->waiting && enable_user_options && P_NETWORK_SERVER(w->c));
   menu_enable(w, P_MENU_OPTIONS_SINGLE_PLAYER, !w->c->waiting && enable_user_options && !P_NETWORK(w->c));
   menu_enable(w, P_MENU_OPTIONS_HUMAN_HUMAN,   !w->c->waiting && enable_user_options && !P_NETWORK(w->c));
   menu_enable(w, P_MENU_OPTIONS_HUMAN_AI,      !w->c->waiting && enable_user_options && !P_NETWORK(w->c));
   menu_enable(w, P_MENU_OPTIONS_AI_AI,         !w->c->waiting && enable_user_options && !P_NETWORK(w->c));
   menu_enable(w, P_MENU_OPTIONS_NETWORK,       FALSE);
   menu_enable(w, P_MENU_OPTIONS_NETWORK_AI,    FALSE);
   if(w->c->networked > 0 && w->c->ai > 0) {
      menu_check(w, P_MENU_OPTIONS_NETWORK_AI, TRUE);
   } else if(w->c->networked > 0) {
      menu_check(w, P_MENU_OPTIONS_NETWORK, TRUE);
   } else if(w->c->numplayers == 1) {
      menu_check(w, P_MENU_OPTIONS_SINGLE_PLAYER, TRUE);
   } else switch(w->c->ai) {
      case 0:
         menu_check(w, P_MENU_OPTIONS_HUMAN_HUMAN, TRUE);
         break;
      case 1:
         menu_check(w, P_MENU_OPTIONS_HUMAN_AI, TRUE);
         break;
      case 2:
         menu_check(w, P_MENU_OPTIONS_AI_AI, TRUE);
         break;
   }
   menu_enable(w, P_MENU_OPTION_EASY,          !w->c->waiting && enable_user_options && P_NETWORK_SERVER(w->c));
   menu_enable(w, P_MENU_OPTION_MEDIUM,        !w->c->waiting && enable_user_options && P_NETWORK_SERVER(w->c));
   menu_enable(w, P_MENU_OPTION_HARD,          !w->c->waiting && enable_user_options && P_NETWORK_SERVER(w->c));
   menu_enable(w, P_MENU_OPTIONS_TUTORIAL,     !w->c->waiting && enable_user_options && !P_NETWORK(w->c));
   menu_check(w,  P_MENU_OPTIONS_TUTORIAL,     w->c->tutorial);

   menu_enable(w, P_MENU_AI_RULE_0,            !w->c->waiting && enable_user_options);
   menu_enable(w, P_MENU_AI_RULE_1,            !w->c->waiting && enable_user_options);
   
   menu_enable(w, P_MENU_NET_CLIENT,           !w->c->waiting && enable_net_options && !P_NETWORK(w->c));
   menu_enable(w, P_MENU_NET_SERVER,           !w->c->waiting && enable_net_options && !P_NETWORK(w->c));
   menu_enable(w, P_MENU_NET_TERMINATE,        !w->c->waiting && enable_net_options && P_NETWORK(w->c));

   return;

}


/***  Actions  ***/


void action_game_new(gpointer data) {

   pwindow_gtk *w = data;
   int redraw = P_REDRAW_ALL;
   
   p_game_end(w->c);
   p_window_update_menus(w);
   p_window_paint(w->c, (pwindow *)w, redraw);

}


void action_game_restart(gpointer data) {

   pwindow_gtk *w = data;
   int redraw = P_REDRAW_ALL;

   p_game_new(w->c);
   p_window_update_menus(w);
   p_window_paint(w->c, (pwindow *)w, redraw);

}


void action_game_exit(gpointer data) {

   gtk_main_quit();

}


void action_game_pause(gpointer data) {

   pwindow_gtk *w = data;
   
   p_game_pause(w->c, !w->c->paused);
   p_window_update_menus(w);
   
}


static void action_game_high_scores(gpointer data) {

   pwindow_gtk *w = data;
   p_high_score_window(w);

}


static void action_help_manual(gpointer data) {

   p_dialog_text((pwindow_gtk *)data, P_MANUAL_FILE);

}


static void action_help_license(gpointer data) {

   p_dialog_text((pwindow_gtk *)data, P_LICENSE_FILE);

}


static void action_help_about(gpointer data) {

   pwindow_gtk *w = data;

   p_dialog(w, "About",
            "xpuyopuyo-gtk " VERSION "\n\n"
            "Copyright (c) 1999,2000 Justin David Smith (justins(at)chaos2.org), Owen Aftreth\n\n"
            "GTK contributions copyright (c) 1999 Havoc Pennington.\n"
            "Music copyright (c) 2000 theGREENzebra (tgz@orotech.net).\n\n"
            "Contributors:\n"
            "Denny Mingus - Theme \"3dRokz\" (c) 2000\n"
            "Brett Smith - Theme \"Smileys\" (c) 2000\n"
            "Andrew Carpenter - Theme \"Spheres\" (c) 2000\n");

}


static void action_option_select_theme(gpointer data) {

   pwindow_gtk *w = data;

   p_theme_select(w);
   p_config_save(w->c);

}


static void action_option_set_keys(gpointer data) {

   pwindow_gtk *w = data;

   p_key_select_keys(w);

}


static void action_option_set_options(gpointer data) {

   pwindow_gtk *w = data;

   p_options(w);
   p_config_save(w->c);
   p_window_update_menus(w);
   gtk_widget_set_usize(w->da, P_WINDOW_WIDTH(w->c->fieldwidth), P_WINDOW_HEIGHT(w->c->fieldheight));
      
}


static void action_option_single_player(gpointer data) {

   pwindow_gtk *w = data;
   
   p_config_players(w->c, P_CONFIG_SINGLE_PLAYER);
   p_config_save(w->c);
   
}


static void action_option_human_human(gpointer data) {

   pwindow_gtk *w = data;
   
   p_config_players(w->c, P_CONFIG_HUMAN_HUMAN);
   p_config_save(w->c);
   
}


static void action_option_human_ai(gpointer data) {

   pwindow_gtk *w = data;
   
   p_config_players(w->c, P_CONFIG_HUMAN_AI);
   p_config_save(w->c);
   
}


static void action_option_ai_ai(gpointer data) {

   pwindow_gtk *w = data;
   
   p_config_players(w->c, P_CONFIG_AI_AI);
   p_config_save(w->c);
   
}


static void action_option_network(gpointer data) {

   pwindow_gtk *w = data;
   
   p_config_players(w->c, P_CONFIG_HUMAN_NET);
   p_config_save(w->c);
   
}


static void action_option_network_ai(gpointer data) {

   pwindow_gtk *w = data;
   
   p_config_players(w->c, P_CONFIG_AI_NET);
   p_config_save(w->c);
   
}


static void action_option_easy(gpointer data) {

   pwindow_gtk *w = data;
   
   p_config_easy(w->c);
   p_config_save(w->c);
   p_window_update_menus(w);

}


static void action_option_medium(gpointer data) {

   pwindow_gtk *w = data;
   
   p_config_medium(w->c);
   p_config_save(w->c);
   p_window_update_menus(w);

}


static void action_option_hard(gpointer data) {

   pwindow_gtk *w = data;
   
   p_config_hard(w->c);
   p_config_save(w->c);
   p_window_update_menus(w);

}


static void action_option_tutorial(gpointer data) {

   pwindow_gtk *w = data;
   
   w->c->tutorial = GTK_CHECK_MENU_ITEM(P_MENUW(w, P_MENU_OPTIONS_TUTORIAL))->active;
   p_config_save(w->c);
   return;
   
}


static void action_ai_rule_1(gpointer data) {

   pwindow_gtk *w = data;

   p_ai_gtk_select_rule(w, &P_PLAYER_0(w->c)->airule);
   p_config_save(w->c);

}


static void action_ai_rule_2(gpointer data) {

   pwindow_gtk *w = data;

   p_ai_gtk_select_rule(w, &P_PLAYER_1(w->c)->airule);
   p_config_save(w->c);

}


static void action_ai_show_rules(gpointer data) {

   pwindow_gtk *w = data;

   p_ai_gtk_select_rule(w, NULL);

}


#if !USE_LISP_AI
static void action_ai_graph(gpointer data) {

   pwindow_gtk *w = data;

   p_graph_ai(w);

}
#endif /* Original AI graphs */


static void action_net_client(gpointer data) {

   pwindow_gtk *w = data;
   
   #if !USE_NETWORK
   p_dialog(w, "Oops", "Network support was not compiled in, sorry.");
   #else /* Network available */
   p_network_client(w);
   p_window_update_menus(w);
   #endif /* Network support? */

}


static void action_net_server(gpointer data) {

   pwindow_gtk *w = data;
   
   #if !USE_NETWORK
   p_dialog(w, "Oops", "Network support was not compiled in, sorry.");
   #else /* Network available */
   p_network_server(w);
   p_window_update_menus(w);
   #endif /* Network support? */

}


static void action_net_terminate(gpointer data) {

   pwindow_gtk *w = data;
   
   #if !USE_NETWORK
   p_dialog(w, "Oops", "Network support was not compiled in, sorry.");
   #else /* Network available */
   pnet_close(w->c, &w->c->socket);
   p_window_update_menus(w);
   #endif /* Network support? */

}


void p_window_create_menus(pwindow_gtk *w) {
/* p_window_create_menus */

   static GtkItemFactoryEntry menu_items[] = {
    { "/_Game",                        NULL,             NULL, 0, "<Branch>" },
    { "/_Game/_Start Game",            "<control>N",     action_game_restart, 0, NULL },
    { "/_Game/_Restart Game",          "<control>R",     action_game_restart, 0, NULL },
    { "/_Game/_End Game",              "<control>E",     action_game_new, 0, NULL },
    { "/_Game/_Pause Game",            "<control>Z",     action_game_pause, 0, NULL },
    { "/_Game/_High Scores ...",       "<control>H",     action_game_high_scores, 0, NULL },
    { "/_Game/sep1",                   NULL,             NULL, 0, "<Separator>" },
    { "/_Game/E_xit",                  "<control>X",     action_game_exit, 0, NULL },
    { "/_Options",                     NULL,             NULL, 0, "<Branch>" },
    { "/_Options/S_ingle-Player Game", NULL,             action_option_single_player, 0, "<RadioItem>" },
    { "/_Options/_Human-vs-Human Game",NULL,             action_option_human_human, 0, "/Options/Single-Player Game" },
    { "/_Options/Human-vs-_AI Game",   NULL,             action_option_human_ai, 0, "/Options/Single-Player Game" },
    { "/_Options/_Demonstration Mode", NULL,             action_option_ai_ai, 0, "/Options/Single-Player Game" },
    { "/_Options/Network Game",        NULL,             action_option_network, 0, "/Options/Single-Player Game" },
    { "/_Options/Network, Local AI",   NULL,             action_option_network_ai, 0, "/Options/Single-Player Game" },
    { "/_Options/sep1",                NULL,             NULL, 0, "<Separator>" },
    { "/_Options/_Easy Difficulty",    "<control>1",     action_option_easy, 0, NULL },
    { "/_Options/_Medium Difficulty",  "<control>2",     action_option_medium, 0, NULL },
    { "/_Options/Ha_rd Difficulty",    "<control>3",     action_option_hard, 0, NULL },
    { "/_Options/T_utorial Mode",      "<control>U",     action_option_tutorial, 0, "<CheckItem>" },
    { "/_Options/sep2",                NULL,             NULL, 0, "<Separator>" },
    { "/_Options/Select Theme ...",    NULL,             action_option_select_theme, 0, NULL },
    { "/_Options/Set _Keys ...",       "<control>K",     action_option_set_keys, 0, NULL },
    { "/_Options/Advanced _Options ...","<control>O",    action_option_set_options, 0, NULL },
    { "/_AI",                          NULL,             NULL, 0, "<Branch>" },
    { "/_AI/Player _1 AI Rule ...",    NULL,             action_ai_rule_1, 0, NULL },
    { "/_AI/Player _2 AI Rule ...",    "<control>I",     action_ai_rule_2, 0, NULL },
    { "/_AI/Display AI Rules ...",     NULL,             action_ai_show_rules, 0, NULL },
   #if !USE_LISP_AI
    { "/_AI/AI Graph ...",             NULL,             action_ai_graph, 0, NULL },
   #endif /* Original AI graph */
    { "/_Network",                     NULL,             NULL, 0, "<Branch>" },
    { "/_Network/New _Client Connection ...",NULL,       action_net_client, 0, NULL },
    { "/_Network/New _Server ...",     NULL,             action_net_server, 0, NULL },
    { "/_Network/_Terminate Connection","<control>T",    action_net_terminate, 0, NULL },
    { "/_Help",                        NULL,             NULL, 0, "<Branch>" },
    { "/_Help/_Manual page ...",       "F1",             action_help_manual, 0, NULL },
    { "/_Help/_License ...",           NULL,             action_help_license, 0, NULL },
    { "/_Help/_About ...",             NULL,             action_help_about, 0, NULL }
   };

   GtkItemFactory *menu_factory;
   GtkAccelGroup *menu_accel;
   gint num_menu_items = sizeof(menu_items) / sizeof(menu_items[0]);

   /* Create menus */   
   menu_accel = gtk_accel_group_new();
   menu_factory = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<main>", menu_accel);
   gtk_item_factory_create_items(menu_factory, num_menu_items, menu_items, w);
   gtk_accel_group_attach(menu_accel, GTK_OBJECT(w->app));

   while (gtk_events_pending()) gtk_main_iteration();

   P_MENUW(w, P_MENU_MAIN) =              gtk_item_factory_get_widget(menu_factory, "<main>");

   P_MENUW(w, P_MENU_GAME_START) =        gtk_item_factory_get_widget(menu_factory, "/Game/Start Game");
   P_MENUW(w, P_MENU_GAME_RESTART) =      gtk_item_factory_get_widget(menu_factory, "/Game/Restart Game");
   P_MENUW(w, P_MENU_GAME_END) =          gtk_item_factory_get_widget(menu_factory, "/Game/End Game");
   P_MENUW(w, P_MENU_GAME_PAUSE) =        gtk_item_factory_get_widget(menu_factory, "/Game/Pause Game");
   P_MENUW(w, P_MENU_GAME_HIGH_SCORES) =  gtk_item_factory_get_widget(menu_factory, "/Game/High Scores DBG ...");

   P_MENUW(w, P_MENU_OPTIONS_SINGLE_PLAYER) = gtk_item_factory_get_widget(menu_factory, "/Options/Single-Player Game");
   P_MENUW(w, P_MENU_OPTIONS_HUMAN_HUMAN)   = gtk_item_factory_get_widget(menu_factory, "/Options/Human-vs-Human Game");
   P_MENUW(w, P_MENU_OPTIONS_HUMAN_AI) =  gtk_item_factory_get_widget(menu_factory, "/Options/Human-vs-AI Game");
   P_MENUW(w, P_MENU_OPTIONS_AI_AI) =     gtk_item_factory_get_widget(menu_factory, "/Options/Demonstration Mode");
   P_MENUW(w, P_MENU_OPTIONS_NETWORK) =   gtk_item_factory_get_widget(menu_factory, "/Options/Network Game");
   P_MENUW(w, P_MENU_OPTIONS_NETWORK_AI) =gtk_item_factory_get_widget(menu_factory, "/Options/Network, Local AI");
   P_MENUW(w, P_MENU_OPTION_EASY) =       gtk_item_factory_get_widget(menu_factory, "/Options/Easy Difficulty");
   P_MENUW(w, P_MENU_OPTION_MEDIUM) =     gtk_item_factory_get_widget(menu_factory, "/Options/Medium Difficulty");
   P_MENUW(w, P_MENU_OPTION_HARD) =       gtk_item_factory_get_widget(menu_factory, "/Options/Hard Difficulty");
   P_MENUW(w, P_MENU_OPTIONS_TUTORIAL) =  gtk_item_factory_get_widget(menu_factory, "/Options/Tutorial Mode");
   P_MENUW(w, P_MENU_OPTIONS_SET_KEYS) =  gtk_item_factory_get_widget(menu_factory, "/Options/Set Keys ...");
   P_MENUW(w, P_MENU_OPTIONS_SET_OPTIONS)=gtk_item_factory_get_widget(menu_factory, "/Options/Advanced Options ...");

   P_MENUW(w, P_MENU_AI_RULE_0) =         gtk_item_factory_get_widget(menu_factory, "/AI/Player 1 AI Rule ...");
   P_MENUW(w, P_MENU_AI_RULE_1) =         gtk_item_factory_get_widget(menu_factory, "/AI/Player 2 AI Rule ...");

   P_MENUW(w, P_MENU_NET_CLIENT) =        gtk_item_factory_get_widget(menu_factory, "/Network/New Client Connection ...");
   P_MENUW(w, P_MENU_NET_SERVER) =        gtk_item_factory_get_widget(menu_factory, "/Network/New Server ...");
   P_MENUW(w, P_MENU_NET_TERMINATE) =     gtk_item_factory_get_widget(menu_factory, "/Network/Terminate Connection");

   /* Display menus in window */
   p_window_update_menus(w);

   return;

}


