/*

    xpuyopuyo - phighscore.h  Copyright(c) 1999,2000 Justin David Smith
    justins(at)chaos2.org     http://chaos2.org/
    
    Header for high scores
    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __phighscore_h_defined
#define __phighscore_h_defined


#include <pplayer.h>


/* Constants for high score data */
#define P_HIGH_SCORE_COUNT       16                      /* Number of high scores to have */


/* Structure for recording an entry in the high scores list */
typedef struct _phigh {
   char     name[P_PLAYER_NAME_SIZE];                    /* Name of winner */
   int      score;                                       /* Score of person */
   int      sfit;                                        /* Survival - number of pieces dropped */
   int      rfit;                                        /* Rocks sent to the opponent */
   int      cfit;                                        /* Rocks received from the opponent */
} phigh;


void p_high_score_load(phigh *h);
void p_high_score_save(const phigh *h);
int p_high_score_add(phigh *h, const pplayer *p);



#endif
