/*
 *	$COPYRIGHT$
 *
 *	$Id: xmpi_sys.h,v 1.4 2000/11/01 06:17:33 bbarrett Exp $
 *
 *	Function:	- XMPI portable definitions
 */

#ifndef _XMPI_SYS_H
#define _XMPI_SYS_H

#include "app_schema.h"
#include "args.h"
#include "blktype.h"
#include "mpitrace.h"
#include "ndi.h"

/*
 * process, trace and database states 
 */

#define XMPI_SMISSING   	(-2)		/* missing, trace/dbase only */
#define XMPI_SUNDEF		(-1)		/* undefined */
#define XMPI_SRUN		TRDTRUN		/* running */
#define XMPI_SBLOCK		TRDTBLOCK	/* blocked */
#define XMPI_SSYSTEM		TRDTSYSTEM	/* system overhead */

/*
 * MPI wildcards
 */

#define XMPI_ANY_SOURCE		(-1)
#define XMPI_ANY_TAG		(-1)

/*
 * MPI context IDs
 */

#define XMPI_CID_WORLD		0
#define XMPI_CID_SELF		1
#define XMPI_CID_PARENT		2

/*
 * MPI datatypes
 */

#define XMPI_CONTIG		0
#define XMPI_VECTOR		1
#define XMPI_HVECTOR		2
#define XMPI_INDEXED		3
#define XMPI_HINDEXED		4
#define XMPI_STRUCT		5
#define XMPI_BYTE		6
#define XMPI_CHAR		7
#define XMPI_UCHAR		8
#define XMPI_SHORT		9
#define XMPI_USHORT		10
#define XMPI_INT		11
#define XMPI_UINT		12
#define XMPI_LOGICAL		13
#define XMPI_LONG		14
#define XMPI_ULONG		15
#define XMPI_FLOAT		16
#define XMPI_DOUBLE		17
#define XMPI_COMPLEX		18
#define XMPI_UB			19
#define XMPI_LB			20
#define XMPI_PACKED		21
#define XMPI_2INT		22
#define XMPI_2FLOAT		23
#define XMPI_2DOUBLE		24
#define XMPI_FLOAT_INT		25
#define XMPI_DOUBLE_INT		26
#define XMPI_LONG_INT 		27
#define XMPI_SHORT_INT		28
#define XMPI_LONG_DOUBLE	29
#define XMPI_LONG_DOUBLE_INT	30
#define XMPI_INTEGER		31
#define XMPI_CHARACTER		32
#define XMPI_REAL		33
#define XMPI_DOUBLE_PRECISION	34
#define XMPI_DOUBLE_COMPLEX	35
#define XMPI_2INTEGER		36
#define XMPI_2REAL		37
#define XMPI_2DOUBLE_PRECISION	38
#define XMPI_LONG_LONG_INT	39		/* non-LAM types start here */
#define XMPI_INTEGER1		40
#define XMPI_INTEGER2		41
#define XMPI_INTEGER4		42
#define XMPI_INTEGER8		43
#define XMPI_REAL4		44
#define XMPI_REAL8		45
#define XMPI_REAL16		46

#define XMPI_MAX_BASIC_TYPE	46		/* all above this are derived */

/*
 * structures
 */

struct xmproc {
	int		xmp_cx;		/* center x ordinate */
	int		xmp_cy;		/* center y ordinate */
	int		xmp_state;	/* process state */
	int		xmp_func;	/* process function */
	int		xmp_wfunc;	/* process wrapper function */
	int		xmp_tag;	/* process tag */
	int		xmp_lrank;	/* process local rank */
	int		xmp_lpeer;	/* process local peer rank */
	int		xmp_lroot;	/* process local root rank */
	int		xmp_gpeer;	/* process global peer rank */
	int		xmp_groot;	/* process global root rank */
	int		xmp_cid;	/* process context ID */
  char* xmp_commname;
	int		xmp_cnt;	/* process count */
	int		xmp_dtype;	/* process datatype */
	int		xmp_nmsg;	/* total # of messages */
	int		xmp_more;	/* more messages */
	LIST		*xmp_msgs;	/* list of messages */
	struct xmmsg	*xmp_curmsg;	/* ptr current message */
	char		xmp_prog[TRDPROGMAX];	/* program name */
};

struct xmmsg {
	int		xmm_tag;	/* message tag */
	int		xmm_lsrc;	/* message local source rank */
	int		xmm_gsrc;	/* message global source rank */
	int		xmm_cid;	/* message context ID */
  char* xmm_commname;
	int		xmm_cnt;	/* message count */
	int		xmm_dtype;	/* message datatype */
	int		xmm_nmsg;	/* # of these messages */
};


typedef enum {
  XMPI_MENU_LABEL,
  XMPI_MENU_TEXTBOX,
  XMPI_MENU_TOGGLE,
  XMPI_MENU_RADIO
} xmpi_widget_type;

struct xmpi_menu_item {
  xmpi_widget_type xmpi_type;

  union {
    char *xmpi_text;             // for TEXTBOX
    int xmpi_toggle;             // for TOGGLE, RADIO 
  } current_val; 

  union {
    char *xmpi_text;
    int xmpi_toggle;
  } default_val;

  char *xmpi_label;
  int xmpi_radio_id;
};

struct xmpi_node {
  char* name;
  int exclusive;
  int default_sel;
  int selected;
};

/*
 * prototypes that make up the API
 */

#ifdef __cplusplus
extern "C" {
#endif

  int xmpi_sys_init();
  void xmpi_sys_finalize(void);
  int xmpi_sys_run(char *, struct _gps **, int *);
  int xmpi_sys_kill(struct _gps *, int);
  int xmpi_sys_snapshot(struct _gps *, int, struct xmproc *);
  void* xmpi_sys_comm(struct _gps *, int);
  void* xmpi_sys_dtype(struct _gps *, int);
  int xmpi_sys_trace(int, struct _gps *, int);
  char* xmpi_sys_errorstr(int);
  char** xmpi_sys_hosts(void);
  char** xmpi_sys_logo(void);
  char* xmpi_sys_version(void);

  int xmpi_sys_get_vendor_info(xmpi_menu_item**, int*, xmpi_menu_item**, 
			       int*, xmpi_node**, int*);
  int xmpi_sys_get_schema_line(char*, int, char*, xmpi_node*, 
			       int, xmpi_menu_item*, int, char**);
  int xmpi_sys_parse_schema_line(char**, int*, char**, xmpi_node**, 
				 int*, xmpi_menu_item**, int, char*);
  int xmpi_sys_verify_schema_line(char*, char**);
  int xmpi_sys_get_run_options(xmpi_menu_item*, int, char**);
  int xmpi_sys_parse_run_options(xmpi_menu_item**, int*, char*);

#ifdef __cplusplus
}
#endif

#endif	/* _XMPI_SYS_H */


