/*
 *	$COPYRIGHT$
 *
 *	$Id: xmpi.h,v 1.14 2001/07/11 15:27:22 bbarrett Exp $
 *
 *	Function:	- XMPI templates and constants
 */

#ifndef _XMPI_H
#define _XMPI_H

#include <X11/Intrinsic.h>
#include <limits.h>
#include <stdio.h>

#include "xmpi_sys.h"

/*
 * application resources
 */
#define XtNhelp		"help"
#define XtCHelp		"Help"
#define XtNbuffers	"buffers"
#define XtCBuffers	"Buffers"
#define XtNrankFont	"rankFont"
#define XtCRankFont	"RankFont"
#define XtNmsgFont	"msgFont"
#define XtCMsgFont	"MsgFont"
#define XtNlcomCol	"lcomCol"
#define XtCLcomCol	"LcomCol"
#define XtNrcomCol	"rcomCol"
#define XtCRcomCol	"RcomCol"
#define XtNbandCol	"bandCol"
#define XtCBandCol	"BandCol"
#define XtNbandDash	"bandDash"
#define XtCBandDash	"BandDash"
#define XtNbandWidth	"bandWidth"
#define XtCBandWidth	"BandWidth"
#define XtNhelpCmd	"helpCmd"
#define XtCHelpCmd	"HelpCmd"
#define XtNinfoLabel	"infoLabel"
#define XtCInfoLabel	"InfoLabel"

typedef struct {
	Boolean		ap_help;	/* prints help info */
	int		ap_buffers;	/* # msg status buffers */
	XFontStruct	*ap_rankfont;	/* process rank font */
	XFontStruct	*ap_msgfont;	/* message count font */
	Pixel		ap_lcomcol;	/* communicator local group colour */
	Pixel		ap_rcomcol;	/* communicator remote group colour */
	Pixel		ap_bandcol;	/* colour of rubber band */
	Boolean		ap_banddash;	/* use dashed rubber band */
	int		ap_bandwidth;	/* width of rubber band */
	char		*ap_helpcmd;	/* help invocation command line */
	char		*ap_infolbl;	/* label for info string display */
} AppData, *AppDataPtr;

/*
 * resources
 */
#define XMPI_RANKFONT	"-*-helvetica-bold-r-normal--*-140-*-*-*-*-*-*"
#define XMPI_MSGFONT	"-*-helvetica-medium-r-normal--*-120-*-*-*-*-*-*"

#define XMPI_HELPCMD 	"netscape http://www.mpi.nd.edu/lam/software/xmpi/"
#define XMPI_INFOLABEL 	"Boot"

/*
 * rubber band resources
 */
#define	XMPI_BANDCOLOUR	"cyan"		/* rubber band colour */
#define XMPI_BANDDASH	False		/* rubber band line style */
#define	XMPI_BANDWIDTH	1		/* rubber band line width */

/*
 * fixed colours
 */
#define XMPI_BLKCOLOUR	"red"		/* blocked process colour */
#define XMPI_SYSCOLOUR	"yellow"	/* system overhead colour */
#define XMPI_RUNCOLOUR	"green"		/* running process colour */
#define XMPI_LBLCOLOUR	"white"		/* plot labeling colour */
#define XMPI_LCOMCOLOUR	"cyan"		/* communicator local group colour */
#define XMPI_RCOMCOLOUR	"plum"		/* communicator remote group colour */

/*
 * constants
 */
#define XMPI_VWXNPROCS	4		/* def. view # horiz. procs */
#define XMPI_VWYNPROCS	4		/* def. view # vert. procs */
#define XMPI_VWRADIUS	50		/* view hexagon radius */
#define XMPI_VWXMARGIN	20		/* view horizontal margins */
#define XMPI_VWYMARGIN	20		/* view vertical margins */
#define XMPI_VWXWIDTH	4		/* extra view width */
#define XMPI_VWXHEIGHT	4		/* extra view height */
#define XMPI_VWLNWIDTH	2		/* view drawing line width */
#define XMPI_VWXRANK	-4		/* view horiz. rank displacement */
#define XMPI_VWYRANK	30		/* view vert. rank displacement */
#define XMPI_VWXLIGHT	-30		/* view horiz. light displacement */
#define XMPI_VWYLIGHT	-17		/* view vert. light displacement */
#define XMPI_VWXMESG	5		/* view horiz. msg displacement */
#define XMPI_VWYMESG	-17		/* view vert. msg displacement */
#define XMPI_VWXNMSG	17		/* view horiz. #msg displacement. */
#define XMPI_VWYNMSG	3		/* view vert. #msg displacement. */
#define XMPI_VWBFSMAX	200		/* message status table size */

#define XMPI_FOTITLE	25		/* focus title bar size */
#define XMPI_FOBORDER	10		/* focus border size */

#define XMPI_SHOWNONE	0		/* showing no datatype */
#define XMPI_SHOWPROC	1		/* showing process datatype */
#define XMPI_SHOWMESG	2		/* showing message datatype */

#define XMPI_DTINDENT   8		/* indentation level for datatypes */

#define XMPI_KVDEFSIZE	200		/* Kiviat def. window size */
#define XMPI_KVBORDER	20		/* Kiviat border size */
#define XMPI_KVTEXT	10		/* Kiviat text size */

#define XMPI_TRNVIEW	3		/* trace # cached views */
#define XMPI_TRWIDTH	400		/* trace width */
#define XMPI_TRHEIGHT	10		/* trace height */
#define XMPI_TRMINWIDTH	500		/* trace min. width */
#define XMPI_TRDISP	50		/* trace displacement */
#define XMPI_TRNPROCS	8		/* # visible trace processes */
#define XMPI_TRSCALE	1024		/* pixels/second scale factor */
#define XMPI_TRVCRPLAY	50		/* VCR play speed timeout */
#define XMPI_TRVCRFWD	5		/* VCR forward speed timeout */

#define XMPI_MTLNWIDTH	2		/* matrix line width */
#define XMPI_MTMINPROC	4		/* matrix default window size */
#define XMPI_MTMAXPROC	16		/* matrix scrollbar threshold */
#define XMPI_MTCELLSIZE	24		/* matrix single cell size */
#define XMPI_MTCNTINSET	4		/* matrix source count inset */
#define XMPI_MTCNTMAX	7		/* matrix max source count */

#define XMPI_FLUSHDELAY 2

#ifdef _POSIX_PATH_MAX
#define XMPI_PATHMAX	_POSIX_PATH_MAX
#else
#define XMPI_PATHMAX	255
#endif

#define SQRT3		((double) 1.73205)
#ifndef PI
#define PI		((double) 3.14159)
#endif

/*
 * button/menu actions
 */
#define XMPI_BSNAPSHOT	1
#define XMPI_BTRACE	2
#define XMPI_BKIVIAT	3
#define XMPI_BMATRIX	4
#define XMPI_BRERUN	5
#define XMPI_BCLEAN	6

/*
 * efficiency macros
 */
#define	al_prev_m(l,p) \
	((void *) (((struct al_head *) (p) - 1)->al_prev))

#define	al_next_m(l,p) \
	((((struct al_head *) (p) - 1)->al_next) ? \
		(void *) al_body(((struct al_head *) (p) - 1)->al_next) : \
		(void *) 0)

struct xmfocus {
	int		xmf_myrank;	/* my rank for callback */
	Widget		xmf_window;	/* focus window */
	Widget		xmf_rank;	/* rank label */
	Widget		xmf_light;	/* light label */
	Widget		xmf_func;	/* function label */
	Widget		xmf_pr_rt;	/* peer or root label */
	Widget		xmf_peer;	/* peer (src/dest) label */
#define xmf_root	xmf_peer	/* root (src/dest) label */
	Widget		xmf_com;	/* communicator label */
	Widget		xmf_compb;	/* communicator push button */
	Widget		xmf_dtb;	/* datatype push button */
	Widget		xmf_tag;	/* tag label */
	Widget		xmf_cnt;	/* count label */
	Widget		xmf_msgsrc;	/* message source label */
	Widget		xmf_msgcom;	/* message comm. label */
	Widget		xmf_msgcompb;	/* message comm. push button */
	Widget		xmf_msgtag;	/* message tag label */
	Widget		xmf_msgdtb;	/* message datatype push button */
	Widget		xmf_msgcnt;	/* message count */
	Widget		xmf_nmsg;	/* # messages label */
	Widget		xmf_nmsgpb;	/* # messages push button */
	struct xmproc	*xmf_proc;	/* ptr process structure */
};

struct xmtrace {
	int		xmt_rank;	/* process global rank */
	int		xmt_state;	/* process state */
	double		xmt_time;	/* start time (sec) */
	double		xmt_lapse;	/* time lapse (sec) */
};

struct xmarrow {
	int		xma_srank;	/* sender global rank */
	int		xma_rrank;	/* receiver global rank */
	double		xma_stime;	/* sender time */
	double		xma_rtime;	/* receiver time */
};

struct xmbuoy {
        int             xmb_rank;       /* process global rank */
        double          xmb_time;       /* start time (sec) */
        char            xmb_name[32];   /* buoy name */
};

/*
 * globally used variables
 */
extern XtAppContext	app;			/* application context */
extern AppData		app_res;		/* application resources */
extern Widget		xmpi_shell;		/* top level app. shell */
extern char		xmpi_info[];		/* information string */

/*
 * global functions
 */
void xmpi_bail();

void xmpi_busy();

void xmpi_unbusy();

Widget xmpi_wmshell(Widget);

void xmpi_setminmax(int, int, int, int);

void xmpi_setsize(int, int);

void xmpi_seticon(Pixmap);

void xmpi_cleanup();

#endif	/* _XMPI_H */
